<?php
    use App\Models\Events;
    use App\Models\Upload;
    use App\Models\CustomPages;
    use App\Models\EventCategories;
    use App\Models\NewsCategories;
    use App\Models\News;
?>
@extends('frontend/master')
@section('styles')
<style type="text/css">
    .bg-notice {
        background-color: rgba(11,11,11,0.8);
        padding: 10px;
        font-size: 18px;
        text-align: center;
        color: #fff;
        display: inline-block;
    }
</style>
@stop
@section('content')
    <!-- Start Hero Area -->
    <div class="hero-area">
    	<div class="flexslider heroflex hero-slider" data-autoplay="no" data-pagination="no" data-arrows="no" data-style="fade" data-pause="yes">
            <ul class="slides">
                <li class="parallax" style="background-image: url({!! URL::asset('frontend/images/maddys-22.jpg') !!})">
                	<div class="flex-caption text-align-left vertical-center">
                    	<div class="container">
                        	<div class="flex-caption-table">
                            	<div class="flex-caption-cell">
                                	<div class="flex-caption-text">
                                        {{-- <h3 class="margin-10">{!! CustomPages::getcontent("HPHPWelcomeTitle") !!}</h3>
                                        <h2>{!! CustomPages::getcontent("HPHPSecondTitle") !!}</h2> --}}
                                        {{-- <h3 class="margin-10">SATURDAY, 28th March 2020 | VGP - By the bay, Chennai.</h3> --}}
                                        <h2>Maddys 2022</h2>
                                        <!--<div style="margin-bottom:10px"><img src="{!!URL::asset('frontend/images/daily-hunt.png')!!}"></div>-->
                                        <a href="https://adclubmadras.com/maddys2022/" class="btn btn-default">View Details</a>
                                        {{-- <a href="http://adclubmadras.com/maddys2020/entry-form" class="btn btn-default">Submit your Entries</a> --}}
                                    </div>
                               	</div>
                          	</div>
                        </div>
                    </div>
                </li>
          	</ul>
       	</div>
    </div>

    <div class="container">
        <div class="featured-links row notice-bar">
            <div class="featured-link col-md-4 col-sm-4">
                <h4>{!! CustomPages::getcontent("HPHPWidOneTitle") !!}</h4>
                <?php
                    $categoryLink = "";
                    $category = EventCategories::find(CustomPages::getcontent("HPHPWidOneCate"));
                    if($category){
                        $categoryLink = URL::to('events/'.$category->categorySlug);
                    }
                    $events = Events::whereIn("id", explode(",", CustomPages::getcontent("HPHPWidOneEvents")))->orderBy('eventDate', 'DESC')->get();
                ?>

                @foreach($events as $event)
                    <?php
                        $catgegorySlug = '';
                        $check = EventCategories::find($event->eventCategoryID);
                        if($check){
                            $categorySlug = $check->categorySlug;
                        }
                        $link = '';
                        if($categorySlug != ''){
                            $link = $categorySlug."/".$event->eventSlug;
                        }
                    ?>
                    <p class="meta-title"><a href="{!! URL::to('events/'.$link) !!}">{!! ucwords($event->eventTitle) !!}</a>
                    <span class="meta-data">- On {!! date("d F, Y", strtotime($event->eventDate)) !!}</span></p>
                @endforeach

                <div class="featured-block-more text-center">
                    <a href="{!! $categoryLink !!}" class="basic-link">View all events</a>
                </div>
            </div>

            <div class="featured-link col-md-4 col-sm-4">
                <h4>{!! CustomPages::getcontent("HPHPWidTwoTitle") !!}</h4>
                <?php
                    $categoryLink = "";
                    $category = EventCategories::find(CustomPages::getcontent("HPHPWidTwoCate"));
                    if($category){
                        $categoryLink = URL::to('events/'.$category->categorySlug);
                    }
                    $events = Events::whereIn("id", explode(",", CustomPages::getcontent("HPHPWidTwoEvents")))->orderBy('eventDate', 'DESC')->get();
                ?>

                @foreach($events as $event)
                    <?php
                        $catgegorySlug = '';
                        $check = EventCategories::find($event->eventCategoryID);
                        if($check){
                            $categorySlug = $check->categorySlug;
                        }
                        $link = '';
                        if($categorySlug != ''){
                            $link = $categorySlug."/".$event->eventSlug;
                        }
                    ?>
                    <p class="meta-title"><a href="{!! URL::to('events/'.$link) !!}">{!! ucwords($event->eventTitle) !!}</a>
                    <span class="meta-data">- On {!! date("d F, Y", strtotime($event->eventDate)) !!}</span></p>
                @endforeach

                <div class="featured-block-more text-center">
                    <a href="{!! $categoryLink !!}" class="basic-link">View all events</a>
                </div>
            </div>

            <div class="featured-link col-md-4 col-sm-4">
                <h4>{!! CustomPages::getcontent("HPHPWidThreeTitle") !!}</h4>
                <?php
                    $newsLink = "";
                    $category = NewsCategories::find(CustomPages::getcontent("HPHPWidThreeCate"));
                    if($category){
                        $newsLink = URL::to('news/'.$category->categorySlug);
                    }
                    $news = News::whereIn("id", explode(",", CustomPages::getcontent("HPHPWidThreeEvents")))->orderBy('newsDate', 'DESC')->get();
                ?>

                @foreach($news as $news)
                    <?php
                        $catgegorySlug = '';
                        $check = NewsCategories::find($news->newsCategoryID);
                        if($check){
                            $categorySlug = $check->categorySlug;
                        }
                        $link = '';
                        if($categorySlug != ''){
                            $link = $categorySlug."/".$news->newsSlug;
                        }
                    ?>
                    <p class="meta-title"><a href="{!! URL::to('news/'.$link) !!}">{!! ucwords($news->newsTitle) !!}</a>
                    <span class="meta-data">- On {!! date("d F, Y", strtotime($news->newsDate)) !!}</span></p>
                @endforeach

                <div class="featured-block-more text-center">
                    <a href="{!! $newsLink !!}" class="basic-link">View all news</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div id="main-container">
    	<div class="content">
        	<div class="container">

            	<div class="row">
                	<div class="col-md-6 parallax">
                        <h5 class="subhead">{!! ucwords(CustomPages::getcontent("HPCMPSmallTitle")) !!}</h5>
                        <h2 class="accent-color">{!! ucwords(CustomPages::getcontent("HPCMPSecondTitle")) !!}</h2>
                        <p class="text-justify">{!! CustomPages::getcontent("HPCMPDescription") !!}</p>
                        <div class="featured-block-more">
                            <a href="{!! URL::to('about') !!}" class="basic-link">Know more about us</a>
                        </div>
                    </div>

                    <div class="spacer-30 visible-sm visible-xs"></div>

                	<div class="col-md-6">
                    	<div class="row">
                            <div class="col-md-6 col-sm-6 col-xs-6">
                                <div class="icon-box ibox-center ibox-plain">
                                    <div class="ibox-icon margin-0">
                                        <img src="{!! URL::asset('frontend/images/icons/member.png') !!}">
                                    </div>
                                    <h3>{!! ucwords(CustomPages::getcontent("HPCMPWidOneTitle")) !!}</h3>
                                    <p>{!! CustomPages::getcontent("HPCMPWidOneDescription") !!}</p>
                                    <div class="featured-block-more">
                                        <a href="{!! URL::to('membership/membership-application') !!}" class="basic-link">Join now</a>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-6 col-xs-6">
                                <div class="icon-box ibox-center ibox-plain">
                                    <div class="ibox-icon margin-0">
                                        <img src="{!! URL::asset('frontend/images/icons/pgda.png') !!}">
                                    </div>
                                    <h3>{!! ucwords(CustomPages::getcontent("HPCMPWidTwoTitle")) !!}</h3>
                                    <p>{!! CustomPages::getcontent("HPCMPWidTwoDescription") !!}</p>
                                    <div class="featured-block-more">
                                        <a href="https://pgda.adclubmadras.com/" target="_blank" class="basic-link">View details</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="clients">
                <div class="container">
                    <div class="row">
                        <div class="col-md-2 col-sm-2">
                            <div class="spacer-55 hidden-sm"></div>
                            <div class="spacer-40 visible-sm"></div>
                            <h4 class="margin-0">{!! ucwords(CustomPages::getcontent("HPCMPWidThreeTitle")) !!}</h4>
                        </div>

                        <div class="col-md-10 col-sm-10">
                            <div class="carousel-wrapper">
                                <div class="row">
                                    <ul class="owl-carousel carousel-fw" id="partners-slider" data-columns="4" data-autoplay="4000" data-pagination="no" data-arrows="no" data-single-item="no" data-items-desktop="4" data-items-desktop-small="3" data-items-tablet="3" data-items-mobile="2">
                                        <?php
                                            $sliders = Events::whereIn("id", explode(",", CustomPages::getcontent("HPCMPWidThreeEvents")))->orderBy('eventDate', 'DESC')->get();
                                        ?>
                                        @foreach($sliders as $slider)
                                            <?php
                                                $catgegorySlug = '';
                                                $check = EventCategories::find($slider->eventCategoryID);
                                                if($check){
                                                    $categorySlug = $check->categorySlug;
                                                }
                                                $link = '';
                                                if($categorySlug != ''){
                                                    $link = $categorySlug."/".$slider->eventSlug;
                                                }
                                            ?>
                                            <li class="item">
                                                <div class="grid-item-inner">
                                                    <div class="post-item-meta">
                                                        <i class="fa fa-clock-o"></i> {!! date("d M, Y", strtotime($slider->eventDate)) !!}
                                                    </div>

                                                    <h5><a href="{!! URL::to('events/'.$link) !!}">{!! ucwords($slider->eventTitle) !!}</a></h5>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>  
                </div>
            </div>

            <div class="spacer-30"></div>

            <div class="bg-color1 padding-tb75 color-text">
            	<div class="container">
                    <div class="row">
                        <div class="col-md-8">
                            <h2 class="color-text"><b>{!! CustomPages::getcontent("HPCBPTitle") !!}</b></h2>
                         	<p>{!! CustomPages::getcontent("HPCBPDescription") !!}</p>
                            <div class="featured-block-more">
                                <a href="{!! URL::to('about/our-facilities') !!}" class="basic-link" style="color: #fff">View Details</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="container">
            	<div class="row">
                    <div class="col-md-8">
                    <div class="spacer-40"></div>
                        <div class="row">
                        	<div class="col-md-12">
                                <!--<a href="javascript:;" class="btn btn-default pull-right">View all</a>-->
                                <h5 class="subhead">Participate in various sports competitions</h5>
                                <h2 class="accent-color margin-0">Sports Activities</h2>
                                <div class="carousel-wrapper">
                                    <div class="row">
                                        <ul class="owl-carousel carousel-fw" id="team-slider" data-columns="3" data-autoplay="" data-pagination="no" data-arrows="yes" data-single-item="no" data-items-desktop="3" data-items-desktop-small="3" data-items-tablet="2" data-items-mobile="1">
                                            <li class="item">
                                                <div class="team-grid-item grid-item format-standard">
                                                    <a href="javascript:;" class="media-box"><img src="{!!URL::asset('frontend/images/cricket.jpg')!!}" alt=""></a>
                                                    <div class="grid-item-inner" style="min-height:auto">
                                                        <h4><a href="javascript:;">Cricket</a></h4>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="item">
                                                <div class="team-grid-item grid-item format-standard">
                                                    <a href="javascript:;" class="media-box"><img src="{!!URL::asset('frontend/images/tt.jpg')!!}" alt=""></a>
                                                    <div class="grid-item-inner" style="min-height:auto">
                                                        <h4><a href="javascript:;">Table Tennis</a></h4>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="item">
                                                <div class="team-grid-item grid-item format-standard">
                                                    <a href="javascript:;" class="media-box"><img src="{!!URL::asset('frontend/images/football.jpg')!!}" alt=""></a>
                                                    <div class="grid-item-inner" style="min-height:auto">
                                                        <h4><a href="javascript:;">Football</a></h4>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="item">
                                                <div class="team-grid-item grid-item format-standard">
                                                    <a href="javascript:;" class="media-box"><img src="{!!URL::asset('frontend/images/chess.jpg')!!}" alt=""></a>
                                                    <div class="grid-item-inner" style="min-height:auto">
                                                        <h4><a href="javascript:;">Chess</a></h4>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="item">
                                                <div class="team-grid-item grid-item format-standard">
                                                    <a href="javascript:;" class="media-box"><img src="{!!URL::asset('frontend/images/8-ball-pool.jpg')!!}" alt=""></a>
                                                    <div class="grid-item-inner" style="min-height:auto">
                                                        <h4><a href="javascript:;">8 Ball Pool</a></h4>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="shadow-block">
                            <h3 class="accent-color">{!! ucwords(CustomPages::getcontent("HPCBPWidThreeTitle")) !!}</h3>
                            <ul class="events-list events-list-compact">
                                <?php
                                    $events = Events::whereIn("id", explode(",", CustomPages::getcontent("HPCBPEvents")))->orderBy('eventDate', 'DESC')->get();
                                ?>

                                @foreach($events as $event)
                                    <?php
                                        $catgegorySlug = '';
                                        $check = EventCategories::find($event->eventCategoryID);
                                        if($check){
                                            $categorySlug = $check->categorySlug;
                                        }
                                        $link = '';
                                        if($categorySlug != ''){
                                            $link = $categorySlug."/".$event->eventSlug;
                                        }
                                    ?>
                                    <li>
                                        <div class="event-date">
                                            <div class="event-month">{!! date("M'y", strtotime($event->eventDate)) !!}</div>
                                            <div class="event-day">{!! date("d", strtotime($event->eventDate)) !!}</div>
                                        </div>

                                        <a href="{!! URL::to('events/'.$link) !!}"><strong>{!! ucwords($event->eventTitle) !!}</strong></a>
                                        <span class="meta-data">{!! date("l, ", strtotime($event->eventDate)) !!} {!! gmdate("h:i A", $event->eventTime) !!}</span>
                                    </li>
                                @endforeach
                            </ul>
                        </div>

                        <div class="hidden-xs"><h4 class="widgettitle">Twitter Updates</h4>
                        <a data-width="350" data-height="330" data-chrome="noheader nofooter noborders noscrollbar" data-dnt="true" class="twitter-timeline" href="https://twitter.com/adclubmadras?ref_src=twsrc%5Etfw">Tweets by adclubmadras</a> <script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script></div>
                    </div>
                </div>
           	</div>

            <div class="spacer-30"></div>

            <div class="padding-tb45 color-text">
                <div class="container">
                    <div class="row">
                        <div class="text-align-center">
                            <h3 class="margin-0">Recent Photos from Gallery</h3>
                            <hr class="alt">
                        </div>
                        <div class="col-md-12">

                            <ul class="list-style" id="acmgallery">
                                <?php
                                    $galimg = Upload::where('type', 'home')->get();
                                ?>
                                @foreach($galimg as $gal)
                                    <li class="grid-item event-grid-item col-md-3 col-sm-3 col-xs-6 format-standard">
                                        <a href="{!! $gal->path !!}" class="media-box" title="Advertising Club Madras">
                                            <img src="{!! $gal->path !!}" alt="">
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                            <div class="text-center">
                                <a href="{!! URL::to('gallery') !!}" class="btn btn-default">View Gallery</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="padding-tb45 bg-color2">
                <h4 class="text-align-center margin-0">For more details contact: <a href="mailto:{!! CustomPages::getcontent("footerSectionOneBottomEmail") !!}">{!! CustomPages::getcontent("footerSectionOneBottomEmail") !!}</a><br>or {!! CustomPages::getcontent("footerSectionOneBottomContactNo") !!}</h4>
            </div>
        </div>
  	</div>
@stop