@extends('frontend/master')
@section('content')
    <div ng-app="AdclubMadras" ng-controller="individualMembersController">
        <div ng-if="loaded">
          <div class="overlay"></div>
            <div class="modal-loader bg-color1">
                <div class="spinner">
                    <div class="bounce1"></div>
                    <div class="bounce2"></div>
                    <div class="bounce3"></div>
                    <p class="text-center">Processing.... Please wait...</p>
                </div>
            </div>
        </div>

        <div class="hero-area">
            <div class="page-header bg-color1 text-center">
                <div class="container">
                    <h1>Individual Members</h1>
                    <ol class="breadcrumb">
                        <li><a href="{!! URL::to('') !!}">Home</a></li>
                        <li><a href="{!! URL::to('membership') !!}">Membership</a></li>
                        <li>Individual Members</li>
                    </ol>
                </div>
            </div>
        </div>

        <div id="main-container">
            <div class="content padding-b40">
                <div class="container">
                    <div class="col-md-12">

                        <div class="row">
                            <div class="col-md-10">
                                <h4 class="inblock" ng-if="params.currentAlphabet=='All'">Displaying All Members (@{{ datalength }})</h4>
                                <h4 class="inblock" ng-if="params.currentAlphabet!='All'">Displaying Members from Alphabet <b>@{{ params.currentAlphabet }}</b> (@{{ datalength }})</h4>
                                <ul class="nav-np hide">
                                    <li><a href="#"><i class="fa fa-angle-left"></i></a></li>
                                    <li><a href="#"><i class="fa fa-angle-right"></i></a></li>
                                </ul>
                            </div>
                            <div class="col-md-2">
                                <select class="form-control" ng-change="sortIndividualMembersByAlphabbet()" ng-model="params.currentAlphabet">
                                    <?php
                                        $alphabet = array('All','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'); 
                                    ?>
                                    @foreach($alphabet as $key=>$val)
                                        <option value="{!! $val !!}">{!! $val !!}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="row" id="individualMembersContainer">
                            <ul class="list-style">
                                <li class="grid-item col-md-3 col-sm-4" ng-repeat="rec in records">
                                    <div class="team-grid-item format-standard">
                                        <div class="grid-item-inner height-3">
                                            <h4>@{{ rec.org_name }}</h4>
                                            <span class="meta-data">@{{ rec.con_person }}</span>
                                            <p>@{{ rec.address }}</p>
                                            <div class="contact_details">
                                            <ul class="social-icons">
                                                <li ng-if="rec.facebook != ''"><a href="@{{ rec.facebook }}" target="_blank"><i class="fa fa-facebook"></i></a></li>
                                                <li ng-if="rec.twitter != ''"><a href="@{{ rec.twitter }}" target="_blank"><i class="fa fa-twitter"></i></a></li>
                                                <li ng-if="rec.linkedin != ''"><a href="@{{ rec.linkedin }}" target="_blank"><i class="fa fa-linkedin"></i></a></li>
                                            </ul>
                                            <p><i class="fa fa-phone"></i> @{{ rec.phone }} @{{ rec.mobile }}<br>
                                            <i class="fa fa-envelope"></i> <a href="mailto:@{{ rec.email }}">@{{ rec.email }}</a></p>
                                            </div> 
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('script')
    {!! HTML::script('backend/js/angular.min.js') !!}
    <script>
        var app = angular.module('AdclubMadras', []);
    
        app.controller('individualMembersController', function($timeout, $scope, $http){
            $scope.loaded = false;
            $timeout(function(){
                $scope.sortIndividualMembersByAlphabbet();
            }, 500);

            $scope.params = {};
            $scope.params.currentAlphabet = "All";
            
            $scope.sortIndividualMembersByAlphabbet = function(){
                $scope.loaded = true;
                angular.element(document.querySelector('#individualMembersContainer')).hide();
                $scope.records = [];
                $http({
                    method  : 'POST',
                    url     : '/membership/individual-members',
                    data    : $scope.params,
                }).success(function(data){
                    console.log(data);
                    $scope.records = data;
                    $scope.datalength = $scope.records.length;
                    if($scope.datalength > 0){
                        $scope.loaded = false;
                        angular.element(document.querySelector('#individualMembersContainer')).show();
                    }else{
                        $scope.loaded = false;
                        angular.element(document.querySelector('#individualMembersContainer')).hide();
                        swal("Empty!!!", "No Records Found", "info");
                        return false;
                    }
                }).error(function(e){
                    console.log(e.responseText);
                    swal("Error!!!", "Error processing your request", "error");
                    $scope.loaded = false;
                });
            }
        });/* end angular controller */
    </script>
@stop