<?php
    use App\Models\CustomPages;
?>
@extends('frontend/master')
@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Jobs Opportunities</h1>
                <ol class="breadcrumb">
                    <li><a href="{!! URL::to('') !!}">Home</a></li>
                    <li>Job Opportunities</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-md-7">
                        @if(Session::has('success'))
                            <div class="alert alert-success">{{Session::get('success')}}</div>
                        @endif
                        @if(Session::has('error'))
                            <div class="alert alert-danger">{{Session::get('error')}}</div>
                        @endif
                        <h4 class="widgettitle">Post a Job</h4>
                       {{ Form::open(['url' => '/job-opportunities/save', 'method' => 'POST', 'files' => true]) }}
                            @if(Auth::guest())
                                <div class="row">
                                    <div class="col-md-12 col-sm-12">
                                        <label>Your Email <span class="req">*</span></label>
                                        {{ Form::text('email', '', ['class' => 'form-control input-lg'])}}
                                        @if($errors->has("email"))
                                            <span class="required">{!! $errors->first("email") !!}</span>
                                        @endif
                                    </div>
                                </div>
                            @else
                                <input type="hidden" id="email" name="email" value="{{Auth::user()->email}}">
                            @endif
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Job Title <span class="req">*</span></label>
                                    {{ Form::text('job_title', '', ['class' => 'form-control input-lg'])}}
                                    @if($errors->has("job_title"))
                                        <span class="required">{!! $errors->first("job_title") !!}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Location</label>
                                    {{ Form::text('location', '', ['class' => 'form-control input-lg'])}}
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Job Type</label>
                                    {{ Form::select('job_type', ['full-time' => 'Full-time', 'part-time' => 'Part-time', 'internship' => 'Internship'], '', ['class' => 'form-control input-lg', 'placeholder' => 'Select']) }}
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Description <span class="req">*</span></label>
                                    {{ Form::textarea('description', '', ['class' => 'form-control input-lg', 'rows' => 4])}}
                                    @if($errors->has("description"))
                                        <span class="required">{!! $errors->first("description") !!}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Application Email/URL <span class="req">*</span></label>
                                    {{ Form::text('application_email', '', ['class' => 'form-control input-lg'])}}
                                    @if($errors->has("application_email"))
                                        <span class="required">{!! $errors->first("application_email") !!}</span>
                                    @endif
                                </div>
                            </div>

                            <h2>Company Details</h2>
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Company Name <span class="req">*</span></label>
                                    {{ Form::text('company_name', '', ['class' => 'form-control input-lg'])}}
                                    @if($errors->has("company_name"))
                                        <span class="required">{!! $errors->first("company_name") !!}</span>
                                    @endif
                                </div>
                            </div>

                             <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Website</label>
                                    {{ Form::text('website', '', ['class' => 'form-control input-lg'])}}
                                    @if($errors->has("website"))
                                        <span class="required">{!! $errors->first("website") !!}</span>
                                    @endif
                                </div>
                            </div>

                             <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Tagline</label>
                                    {{ Form::text('tagline', '', ['class' => 'form-control input-lg'])}}
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Video</label>
                                    {{ Form::text('video', '', ['class' => 'form-control input-lg'])}}
                                </div>
                            </div>

                             <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Twitter Username</label>
                                    {{ Form::text('twitter_username', '', ['class' => 'form-control input-lg'])}}
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Logo</label>
                                    {{ Form::file('logo', ['class' => 'form-control input-lg'])}}
                                    <em>File formats: png, jpg, jpeg, gif</em>
                                    @if($errors->has("logo"))
                                        <span class="required">{!! $errors->first("logo") !!}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="spacer-10"></div>

                            <div class="clearfix">
                                <button type="submit" class="btn btn-primary btn-lg">Submit</button>
                            </div>
                        {{ Form::close() }}
                    </div>
                    <div class="col-md-4 col-md-offset-1">
                        <h4 class="widgettitle">Get in touch with us</h4>
                        <h4 class="accent-color"><b>ADVERTISING CLUB MADRAS</b></h4>
                        <p>
                            {!! CustomPages::getcontent("contactUsAddress") !!}<br><br>
                            <b>Phone:</b> {!! CustomPages::getcontent("contactUsPhone") !!}<br>
                            <!--<b>Fax:</b> {!! CustomPages::getcontent("contactUsFax") !!}<br>-->
                            <b>Email:</b> 
                            <?php
                                $emails = CustomPages::getcontent("contactUsEmail");
                                $emailArray = explode(",", $emails);
                                $i = 0;
                            ?>

                            @foreach($emailArray as $array)
                                @if($i > 0) , @endif
                                <a href="mailto:{!! $array !!}">{!! $array !!}</a>
                            @endforeach
                        </p>

                        <p>
                            <b>PAN No.:</b> AAAAA5944J<br>
                            <b>GST No.:</b> 33AAAAA5944J1ZV
                        </p>
                    </div>
                </div>
            </div>
        </div>

    </div>
@stop