@extends('frontend/master')
@section('styles')
  <style type="text/css">
    .icon-box {
      padding: 0 0 0 80px;
    }

    .icon-box .ibox-icon i, .icon-box .ibox-icon img {
      border-radius: 0;
    }
  </style>
@stop

@section('content')
  <div class="hero-area">
    <div class="loadingDiv" style="display: none;">
      <div class="overlay"></div>
      <div class="modal-loader bg-color1">
        <div class="spinner">
          <div class="bounce1"></div>
          <div class="bounce2"></div>
          <div class="bounce3"></div>
          <p class="text-center">Processing.... Please wait...</p>
        </div>
      </div>
    </div>
    <div class="page-header bg-color1">
      <div class="container">
        <div class="text-center">
          <h1>Member Login</h1>
          <ol class="breadcrumb">
            <li><a href="{!! URL::to('') !!}">Home</a></li>
            <li>Member Login</li>
          </ol>
        </div>

        <div class="spacer-40"></div>

        <div class="col-md-6 col-md-offset-3">
          <div class="row" id="signinDiv" style="display: none;">
                <div class="bg-color3 padding-all25 clearfix">
                    <div class="col-md-12">
                      @if(Session::has('loginErrorMessage'))
                          <div class="alert alert-danger mt-10">
                              <strong>Error: </strong>{!! Session::get('loginErrorMessage') !!}
                          </div>
                      @endif
                    </div>
                  <form action="{!! url('login') !!}" method="POST">
                    {{csrf_field()}}
                    <div class="col-md-12">
                      <div class="form-group">
                        <label>Email Address</label>
                        <div class="form-icon">
                          <i class="fa fa-envelope"></i>
                          <input type="text" class="form-control" placeholder="Enter email address" name="userEmail" autofocus="autofocus" value="{!! old('userEmail') !!}">
                        </div>
                        @if($errors->has("userEmail"))
                            <div class="req">
                              <div>{!! $errors->first("userEmail") !!}</div>
                            </div>
                        @endif
                      </div>

                      <div class="form-group">
                        <label>Password</label>
                        <div class="form-icon">
                          <i class="fa fa-key"></i>
                          <input type="password" class="form-control" placeholder="Enter password" name="userPassword">
                          <input type="hidden" name="userIntendedURI">
                        </div>
                        @if($errors->has("userPassword"))
                            <div class="req">
                              <div>{!! $errors->first("userPassword") !!}</div>
                            </div>
                        @endif
                        <a href="javascript:;" id="forgotpasswordbtn">Forgot Password?</a>
                      </div>

                      <div class="form-group">
                        <button type="submit" class="btn btn-primary">Sign in</button>
                      </div>
                    </div><!--end col-md-6-->
                  </form>

                  <div class="col-md-1 col-sm-1 hide">
                    <div class="loginOr hidden-xs">
                    <span>or</span>
                    </div>
                  </div><!--end col-md-1-->

                  <div class="col-md-5 hide">
                    <div class="social_login">  
                      <div class="row">
                        <div class="col-md-12">
                          <label>Connect with</label>
                          <a href="#" class="social_boxfb mb24">
                            <span class="icon"><i class="fa fa-facebook"></i></span>
                            <span class="icon_title">Facebook</span>
                          </a>
                        </div> 

                        <div class="col-md-12">
                          <label>Connect with</label>
                          <a href="#" class="social_boxgoogle">
                            <span class="icon"><i class="fa fa-google-plus"></i></span>
                            <span class="icon_title">Google</span>
                          </a>
                        </div>
                      </div>
                    </div>
                  </div><!--end col-md-5-->

                  <div class="col-md-12">
                    <hr>
                    <div class="text-center">
                      New Member?&nbsp;  <a class="btn btn-primary" id="signup">Create New Account</a>
                    </div>
                  </div>
                </div><!--end row-->
          </div>

            <div class="row" id="forgotpasswordDiv" style="display: none;">
                <div class="bg-color3 padding-all25 clearfix" id="forgotpassword">
                  <div class="col-lg-12 text-center">
                    <h3>Forgot Password</h3>
                  </div>
                  <div class="col-md-12">
                    @if(Session::has('forgotError') && Session::get('forgotError') != '')
                        <div class="alert alert-danger mt-10">
                            <strong>Error: </strong>{!! Session::get('forgotError') !!}
                        </div>
                    @endif
                    @if(Session::has('forgotSuccess'))
                        <div class="alert alert-success mt-10">
                            <strong>Success: </strong>{!! Session::get('forgotSuccess') !!}
                        </div>
                    @endif
                    </div>
                  <form action="{!! url('/forgot/password/post') !!}" method="POST">
                    {{csrf_field()}}
                    <div class="col-md-12">
                      <p class="text-center">Forgotten your password? Enter your e-mail address below,<br>and we'll e-mail instructions for setting a new one.</p>
                      <div class="form-group">
                        <label>Email Address</label>
                        <div class="form-icon">
                          <i class="fa fa-envelope"></i>
                          <input type="text" class="form-control" placeholder="Enter email address" name="forgotEmail" value="{{ old('forgotEmail') }}">
                        </div>
                        @if($errors->has("forgotEmail"))
                            <div class="req">
                              <div>{!! $errors->first("forgotEmail") !!}</div>
                            </div>
                        @endif
                      </div>

                      <div class="form-group">
                        <button type="submit" id='continueForgetPassword' class="btn btn-primary">Continue</button>
                      </div>
                    </div><!--end col-md-6-->
                  </form>

                  <div class="col-md-12">
                    <hr>
                    <div class="text-center">
                      Already have an account?&nbsp;  <a class="btn btn-primary" id="signin">Sign in</a>
                    </div>
                  </div>
                </div><!--end #forgotpassword-->
            </div><!--end row-->

            <div class="row" id="signupDiv" style="display: none;">
                <div class="bg-color3 padding-all25 clearfix">
                    @if(Session::has('signupSuccess'))
                        <div class="alert alert-success mt-10">
                            <strong>Success: </strong>{!! Session::get('signupSuccess') !!}
                        </div>
                    @endif
                    @if(Session::has('signupError') && Session::get('signupError') != '')
                        <div class="alert alert-danger mt-10">
                            <strong>Error: </strong>{!! Session::get('signupError') !!}
                        </div>
                    @endif
                  <form action="{{'/sign-up/post'}}" method="POST">
                    {{csrf_field()}}
                    <div class="col-md-12">
                      <div class="form-group">
                        <label>Full Name</label>
                        <div class="form-icon">
                          <i class="fa fa-user"></i>
                          <input type="text" class="form-control" placeholder="Enter full name" name="signUpFullName">
                        </div>
                        @if($errors->has("signUpFullName"))
                            <div class="req">
                              <div>{!! $errors->first("signUpFullName") !!}</div>
                            </div>
                        @endif
                      </div>

                      <div class="form-group">
                        <label>Email Address</label>
                        <div class="form-icon">
                          <i class="fa fa-envelope"></i>
                          <input type="email" class="form-control" placeholder="Enter email address" name="signUpEmail">
                        </div>
                        @if($errors->has("signUpEmail"))
                            <div class="req">
                              <div>{!! $errors->first("signUpEmail") !!}</div>
                            </div>
                        @endif
                      </div>

                      <div class="form-group">
                        <label>Password</label>
                        <div class="form-icon">
                          <i class="fa fa-key"></i>
                          <input type="password" class="form-control" placeholder="Enter password" name="signUpPassword">
                        </div>
                        @if($errors->has("signUpPassword"))
                            <div class="req">
                              <div>{!! $errors->first("signUpPassword") !!}</div>
                            </div>
                        @endif
                      </div>

                      <div class="form-group">
                        <label>Confirm Password</label>
                        <div class="form-icon">
                          <i class="fa fa-key"></i>
                          <input type="password" class="form-control" placeholder="Re-enter password" name="signUpPassword_confirmation">
                        </div>
                        @if($errors->has("signUpPassword_confirmation"))
                            <div class="req">
                              <div>{!! $errors->first("signUpPassword_confirmation") !!}</div>
                            </div>
                        @endif
                      </div>

                      <div class="form-group">
                        <button type="submit" class="btn btn-primary">Sign Up</button>
                        
                      </div>
                    </div><!--end col-md-6-->
                  </form>

                  <div class="col-md-1 col-sm-1 hide">
                    <div class="loginOr hidden-xs">
                      <span>or</span>
                    </div>
                  </div><!--end col-md-1-->

                  <div class="col-md-5 hide">
                    <div class="social_login">  
                      <div class="row">
                        <div class="col-md-12">
                          <label>Connect with</label>
                          <a href="#" class="social_boxfb mb24">
                            <span class="icon"><i class="fa fa-facebook"></i></span>
                            <span class="icon_title">Facebook</span>
                          </a>
                        </div> 
                        <div class="col-md-12">
                          <label>Connect with</label>
                          <a href="#" class="social_boxgoogle">
                            <span class="icon"><i class="fa fa-google-plus"></i></span>
                            <span class="icon_title">Google</span>
                          </a>
                        </div>
                      </div>
                    </div>
                  </div><!--end col-md-5-->
                  

                  <div class="col-md-12">
                    <hr>
                    <div class="text-center">
                      Already have an account?&nbsp;  <a class="btn btn-primary" id="signin">Sign in</a>
                    </div>
                  </div>
                </div><!--end row-->
            </div>
        </div>

        <div class="spacer-40"></div>
      </div>

      
    </div>



    <!--<div id="main-container">
      <div class="content padding-b40">
        <div class="container">
          <div class="row">
            <div class="col-md-4">
              <div class="icon-box">
                <div class="ibox-icon">
                  <img src="{!! URL::asset('frontend/images/icons/membership.png') !!}">
                </div>

                <h3>Manage Membership</h3>
                <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
              </div>
            </div>

            <div class="col-md-4">
              <div class="icon-box">
                <div class="ibox-icon">
                  <img src="{!! URL::asset('frontend/images/icons/save-time.png') !!}">
                </div>

                <h3>Save Time</h3>
                <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
              </div>
            </div>

            <div class="col-md-4">
              <div class="icon-box">
                <div class="ibox-icon">
                  <img src="{!! URL::asset('frontend/images/icons/payment-reports.png') !!}">
                </div>

                <h3>Payment Records</h3>
                <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
              </div>
            </div>
          </div>
        </div>
      </div>-->

      <div class="padding-tb45 bg-color2">
        <h4 class="text-align-center margin-0">For more details contact: <a href="mailto:advertisingclubmadras@gmail.com">advertisingclubmadras@gmail.com</a><br>or 044 28141 1581, 044 281 42250</h4>
      </div>
    </div>

    
  </div>
@stop

@section('script')
  <script>
    $(document).ready(function(){
        $("#forgotpasswordbtn").click(function(){
            $("#signinDiv").hide();
            $("#signupDiv").hide();
            $("#forgotpasswordDiv").show();
        });
        $(document).on("click", "#signin", function(){
            $("#forgotpasswordDiv").hide();
            $("#signupDiv").hide();
            $("#signinDiv").show();
        });

        $("#signup").click(function(){
            $("#forgotpasswordDiv").hide();
            $("#signinDiv").hide();
            $("#signupDiv").show();
        });

        $(document).on('click', '#continueForgetPassword', function (){
            $('.loadingDiv').show();
            return true;
        });

        @if(Session::has('forgotError'))
            $('#signinDiv').hide();
            $("#signupDiv").hide();
            $('#forgotpasswordDiv').show();
            return false;
        @elseif(Session::has('signupError'))
            $('#signinDiv').hide();
            $('#forgotpasswordDiv').hide();
            $("#signupDiv").show();
            return false;
        @else
            $("#forgotpasswordDiv").hide();
            $("#signupDiv").hide();
            $("#signinDiv").show();
            return false;
        @endif
    });
  </script>
@stop