@extends('frontend/master')
@section('styles')
  <style type="text/css">
    .icon-box {
      padding: 0 0 0 80px;
    }

    .icon-box .ibox-icon i, .icon-box .ibox-icon img {
      border-radius: 0;
    }
  </style>
@stop

@section('content')
  <div class="hero-area" ng-app="AdclubMadras" ng-controller="formController">
    <div ng-show="loaded">
      <div class="overlay"></div>
      <div class="modal-loader bg-color1">
        <div class="spinner">
          <div class="bounce1"></div>
          <div class="bounce2"></div>
          <div class="bounce3"></div>
          <p class="text-center">Processing.... Please wait...</p>
        </div>
      </div>
    </div>

    <div class="page-header bg-color1">
      <div class="container">
        <div class="text-center">
          <h1>Member Login</h1>
          <ol class="breadcrumb">
            <li><a href="{!! URL::to('') !!}">Home</a></li>
            <li>Member Login</li>
          </ol>
        </div>

        <div class="spacer-40"></div>

        <div class="col-md-8 col-md-offset-2">
          <div class="row" id="signinDiv">
            <div class="bg-color3 padding-all25 clearfix">
              <form name="loginForm" novalidate>
                <div class="col-md-6">
                  <div class="form-group"  ng-class="{ 'has-error': loginForm.userEmail.$touched && loginForm.userEmail.$invalid }">
                    <label>Email Address</label>
                    <div class="form-icon">
                      <i class="fa fa-envelope"></i>
                      <input type="email" class="form-control" placeholder="Enter email address" name="userEmail" ng-model="login.userEmail" autofocus="autofocus" required>
                    </div>

                    <div class="req" ng-messages="loginForm.userEmail.$error" ng-show="loginForm.userEmail.$touched">
                      <div ng-message="required">Please enter login email</div>
                      <div ng-message="email">Please enter a valid email</div>
                    </div>
                  </div>

                  <div class="form-group"  ng-class="{ 'has-error': loginForm.userPassword.$touched && loginForm.userPassword.$invalid }">
                    <label>Password</label>
                    <div class="form-icon">
                      <i class="fa fa-key"></i>
                      <input type="password" class="form-control" placeholder="Enter password" name="userPassword" ng-model="login.userPassword" required>
                      <input type="hidden" name="userIntendedURI" ng-model="login.userIntendedURI" ng-init="login.userIntendedURI='{!! $intended !!}'">
                    </div>

                    <div class="req" ng-messages="loginForm.userPassword.$error" ng-show="loginForm.userPassword.$touched">
                      <div ng-message="required">Please enter login password</div>
                    </div>

                    <a href="javascript:;" id="forgotpasswordbtn">Forgot Password?</a>
                  </div>

                  <div class="form-group">
                    <button type="submit" class="btn btn-primary" ng-click="clickLoginSubmit()" ng-disabled="loginForm.$invalid">Sign in</button>
                  </div>
                </div><!--end col-md-6-->
              </form>

              <div class="col-md-1 col-sm-1">
                <div class="loginOr hidden-xs">
                <span>or</span>
                </div>
              </div><!--end col-md-1-->

              <div class="col-md-5">
                <div class="social_login">  
                  <div class="row">
                    <div class="col-md-12">
                      <label>Connect with</label>
                      <a href="#" class="social_boxfb mb24">
                        <span class="icon"><i class="fa fa-facebook"></i></span>
                        <span class="icon_title">Facebook</span>
                      </a>
                    </div> 

                    <div class="col-md-12">
                      <label>Connect with</label>
                      <a href="#" class="social_boxgoogle">
                        <span class="icon"><i class="fa fa-google-plus"></i></span>
                        <span class="icon_title">Google</span>
                      </a>
                    </div>
                  </div>
                </div>
              </div><!--end col-md-5-->

              <div class="col-md-12">
                <hr>
                <div class="text-center">
                  New Member?&nbsp;  <a class="btn btn-primary" id="signup">Create New Account</a>
                </div>
              </div>
            </div><!--end row-->
          </div>

          <div class="row" id="forgotpasswordDiv">
            <div class="bg-color3 padding-all25 clearfix" id="forgotpassword">
              <div class="col-lg-12 text-center">
                <h3>Forgot Password</h3>
              </div>

              <form name="forgotPasswordForm" novalidate>
                <div class="col-md-12">
                  <p class="text-center">Forgotten your password? Enter your e-mail address below,<br>and we'll e-mail instructions for setting a new one.</p>
                  <div class="form-group"  ng-class="{ 'has-error': forgotPasswordForm.forgotEmail.$touched && forgotPasswordForm.forgotEmail.$invalid }">
                    <label>Email Address</label>
                    <div class="form-icon">
                      <i class="fa fa-envelope"></i>
                      <input type="email" class="form-control" placeholder="Enter email address" name="forgotEmail" ng-model="forgot.forgotEmail" required>
                    </div>

                    <div class="req" ng-messages="forgotPasswordForm.forgotEmail.$error" ng-show="forgotPasswordForm.forgotEmail.$touched">
                      <div ng-message="required">Please enter login email</div>
                      <div ng-message="email">Please enter a valid email</div>
                    </div>
                  </div>

                  <div class="form-group">
                    <button class="btn btn-primary" ng-click="clickForgotPasswordSubmit()" ng-disabled="forgotPasswordForm.$invalid">Continue</button>
                  </div>
                </div><!--end col-md-6-->
              </form>

              <div class="col-md-12">
                <hr>
                <div class="text-center">
                  Already have an account?&nbsp;  <a class="btn btn-primary" id="signin">Sign in</a>
                </div>
              </div>
            </div><!--end #forgotpassword-->
          </div><!--end row-->

          <div class="row" id="signupDiv">
            <div class="bg-color3 padding-all25 clearfix">
              <form name="signUpForm" novalidate>
                <div class="col-md-6">
                  <div class="form-group" ng-class="{ 'has-error': signUpForm.signUpFullName.$touched && signUpForm.signUpFullName.$invalid }">
                    <label>Full Name</label>
                    <div class="form-icon">
                      <i class="fa fa-user"></i>
                      <input type="text" class="form-control" placeholder="Enter full name" name="signUpFullName" ng-model="signUp.signUpFullName" required>
                    </div>

                    <div class="req" ng-messages="signUpForm.signUpFullName.$error" ng-show="signUpForm.signUpFullName.$touched">
                      <div ng-message="required">Please enter your full name</div>
                    </div>
                  </div>

                  <div class="form-group" ng-class="{ 'has-error': signUpForm.signUpEmail.$touched && signUpForm.signUpEmail.$invalid }">
                    <label>Email Address</label>
                    <div class="form-icon">
                      <i class="fa fa-envelope"></i>
                      <input type="email" class="form-control" placeholder="Enter email address" name="signUpEmail" ng-model="signUp.signUpEmail" required>
                    </div>

                    <div class="req" ng-messages="signUpForm.signUpEmail.$error" ng-show="signUpForm.signUpEmail.$touched">
                      <p ng-message="required">Please enter your email</p>
                      <p ng-message="email">Please enter a valid email</p>
                    </div>
                  </div>

                  <div class="form-group" ng-class="{ 'has-error': signUpForm.signUpPassword.$touched && signUpForm.signUpPassword.$invalid }">
                    <label>Password</label>
                    <div class="form-icon">
                      <i class="fa fa-key"></i>
                      <input type="password" class="form-control" placeholder="Enter password" name="signUpPassword" ng-model="signUp.signUpPassword" required>
                    </div>

                    <div class="req" ng-messages="signUpForm.signUpPassword.$error" ng-show="signUpForm.signUpPassword.$touched">
                      <div ng-message="required">Please enter your password</div>
                    </div>
                  </div>

                  <div class="form-group" ng-class="{ 'has-error': signUpForm.signUpConfirmPassword.$touched && signUpForm.signUpConfirmPassword.$invalid }">
                    <label>Confirm Password</label>
                    <div class="form-icon">
                      <i class="fa fa-key"></i>
                      <input type="password" class="form-control" placeholder="Re-enter password" name="signUpConfirmPassword" ng-model="signUp.signUpConfirmPassword" match-password="signUpPassword" required>
                    </div>

                    <div class="req" ng-messages="signUpForm.signUpConfirmPassword.$error" ng-show="signUpForm.signUpConfirmPassword.$touched">
                      <div ng-message="required">Please re-enter your password</div>
                      <div ng-message="passwordMatch">Your passwords did not match</div>
                    </div>
                  </div>

                  <div class="form-group">
                    <button type="submit" class="btn btn-primary" ng-click="clickSignUpSubmit()" ng-disabled="signUpForm.$invalid">Sign Up</button>
                    
                  </div>
                </div><!--end col-md-6-->
              </form>

              <div class="col-md-1 col-sm-1">
                <div class="loginOr hidden-xs">
                  <span>or</span>
                </div>
              </div><!--end col-md-1-->

              <div class="col-md-5">
                <div class="social_login">  
                  <div class="row">
                    <div class="col-md-12">
                      <label>Connect with</label>
                      <a href="#" class="social_boxfb mb24">
                        <span class="icon"><i class="fa fa-facebook"></i></span>
                        <span class="icon_title">Facebook</span>
                      </a>
                    </div> 
                    <div class="col-md-12">
                      <label>Connect with</label>
                      <a href="#" class="social_boxgoogle">
                        <span class="icon"><i class="fa fa-google-plus"></i></span>
                        <span class="icon_title">Google</span>
                      </a>
                    </div>
                  </div>
                </div>
              </div><!--end col-md-5-->
              

              <div class="col-md-12">
                <hr>
                <div class="text-center">
                  Already have an account?&nbsp;  <a class="btn btn-primary" id="signin">Sign in</a>
                </div>
              </div>
            </div><!--end row-->
          </div>
        </div>

        <div class="spacer-40"></div>
      </div>

      
    </div>



    <div id="main-container">
      <div class="content padding-b40">
        <div class="container">
          <div class="row">
            <div class="col-md-4">
              <div class="icon-box">
                <div class="ibox-icon">
                  <img src="{!! URL::asset('frontend/images/icons/membership.png') !!}">
                </div>

                <h3>Manage Membership</h3>
                <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
              </div>
            </div>

            <div class="col-md-4">
              <div class="icon-box">
                <div class="ibox-icon">
                  <img src="{!! URL::asset('frontend/images/icons/save-time.png') !!}">
                </div>

                <h3>Save Time</h3>
                <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
              </div>
            </div>

            <div class="col-md-4">
              <div class="icon-box">
                <div class="ibox-icon">
                  <img src="{!! URL::asset('frontend/images/icons/payment-reports.png') !!}">
                </div>

                <h3>Payment Records</h3>
                <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="padding-tb45 bg-color2">
        <h4 class="text-align-center margin-0">For more details contact: <a href="mailto:advertisingclubmadras@gmail.com">advertisingclubmadras@gmail.com</a><br>or 044 28141 1581, 044 281 42250</h4>
      </div>
    </div>

    
  </div>
@stop

@section('script')
  {!! HTML::script('backend/js/angular.min.js') !!}
  {!! HTML::script('backend/js/angular-password.min.js') !!}
  {!! HTML::script('backend/js/angular-messages.js') !!}
  <script>
    $(document).ready(function(){
      $("#forgotpasswordbtn").click(function(){
          $("#signinDiv").hide();
          $("#signupDiv").hide();
          $("#forgotpasswordDiv").show();
      });

      $(document).on("click", "#signin", function(){
        $("#forgotpasswordDiv").hide();
        $("#signupDiv").hide();
        $("#signinDiv").show();
      });

      $("#signup").click(function(){
          $("#forgotpasswordDiv").hide();
          $("#signinDiv").hide();
          $("#signupDiv").show();
      });
    });

    var app = angular.module('AdclubMadras', ['ngMessages', 'ngPassword']);
    
    app.controller('formController', function($timeout, $scope, $http, $window){
      $scope.loaded = false;
      $scope.login = {};
      $scope.login.userEmail = '';
      $scope.login.userPassword = '';
      $scope.login.userIntendedURI = '';
      $scope.clickLoginSubmit = function(){
        $scope.loaded = true;
        $http.post('/login', $scope.login).then(function(response){
          if(response.data.status == 'validation'){
            swal("Not Valid!!!", "Please enter valid credentials", "error");
            $scope.loaded = false;
            return false;
          }

          if(response.data.status == 'success'){
            $window.location.href = response.data.userIntendedURI;
            $scope.loaded = false;
            return false;
          }
        },  function(e){
              console.log(e);
              swal('Error', 'Error processing your request. Please contact system administrator', 'error');
              return false;
        });
      }

      $scope.signUp = {};
      $scope.signUp.signUpFullName = '';
      $scope.signUp.signUpEmail = '';
      $scope.signUp.signUpPassword = '';
      $scope.signUp.signUpConfirmPassword = '';
      $scope.clickSignUpSubmit = function(){
        if($scope.signUp.signUpPassword != $scope.signUp.signUpConfirmPassword){
          swal("Password", "Password doesn't match", "warning");
          return false;
        }

        $scope.loaded = true;
        $http.post('/sign-up/post', $scope.signUp).then(function(response){
          console.log(response.data);
          if(response.data.validation == 'yes'){
            swal({
              title: "Warning", 
              text: "The given email has taken already, please enter a new email", 
              icon: "warning",
              closeOnClickOutside: false,
              closeOnEsc: false,
            });
            $scope.loaded = false;
            return false;
          }

          if(response.data.status == 'success'){
            swal("Success!!!", "Your account has been created successfully!!!", "success");
            $scope.loaded = false;
            $scope.reset('signUpForm');
            $window.location.href = "/";
            return false;
          }
        },
        function(e){
          console.log(e);
          swal('Error', 'Error processing your request. Please contact system administrator', 'error');
          return false;
        });
      }

      $scope.forgot = {};
      $scope.forgot.forgotEmail = '';
      $scope.clickForgotPasswordSubmit = function(){
        $scope.loaded = true;
        $http.post('/forgot/password/post', $scope.forgot).then(function(response){
          console.log(response.data);
          if(response.data.status == 'success'){
            swal("Success!!!", "Please check your email to reset your password", "success");
            $scope.loaded = false;
            $scope.reset('forgotPasswordForm');
            return false;
          }

          if(response.data.status == 'notexist'){
            swal("Ensure", "Please check, entered email is not valid", "warning");
            $scope.loaded = false;
            return false;
          }
        }, function(e){
          console.log(e);
          swal('Error', 'Error processing your request. Please contact system administrator', 'error');
          return false;
        });
      }

      $scope.reset = function(type) {
        if(type == "signUpForm"){
          $scope.signUp = {};
          $scope.signUpForm.$setPristine();
          $scope.signUpForm.$setUntouched();
        }else if(type == "forgotPasswordForm"){
          $scope.forgot = {};
          $scope.forgotPasswordForm.$setPristine();
          $scope.forgotPasswordForm.$setUntouched();
        }
      }
    });/* end of angular Controller */
  </script>
@stop