<?php
  use App\Models\Option;
  use App\Models\Upload;
  use App\Models\EventCategories;
  use App\Models\NewsCategories;
  use App\Models\GalleryCategories;
  use App\Models\Events;
?>
<!DOCTYPE HTML>
<html class="no-js">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Advertising Club Madras</title>
<meta name="description" content="">
<meta name="keywords" content="">
<meta name="author" content="">
<meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0">
<meta name="format-detection" content="telephone=no">
<meta name="csrf-token" content="{!! csrf_token() !!}" />
@yield('metadetails')
<link rel="shortcut icon" href="{!! URL::asset('frontend/images/favicon.ico') !!}" type="image/x-icon">
<!-- CSS -->
{!! HTML::style('frontend/css/bootstrap.css') !!}
{!! HTML::style('frontend/css/bootstrap-theme.css') !!}
{!! HTML::style('frontend/css/style.css') !!}
{!! HTML::style('frontend/vendor/magnific/magnific-popup.css') !!}
{!! HTML::style('frontend/vendor/owl-carousel/css/owl.carousel.css') !!}
{!! HTML::style('frontend/vendor/owl-carousel/css/owl.theme.css') !!}
{!! HTML::style('frontend/css/custom.css') !!}
{!! HTML::style('frontend/css/verticals.min.css') !!}
{!! HTML::style('frontend/css/color.css') !!}
<!--[if lte IE 9]>{!! HTML::style('frontend/css/ie.css', ["media"=>"screen"]) !!}<![endif]-->
@yield('styles')

<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-171075970-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-171075970-1');
</script>


<!-- End Google Tag Manager -->
<script data-ad-client="ca-pub-4466643665439520" async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
</head>
<body class="home header-style2">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WJ9R4VR"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<!--[if lt IE 7]>
    <p class="chromeframe">You are using an outdated browser. <a href="http://browsehappy.com/">Upgrade your browser today</a> or <a href="http://www.google.com/chromeframe/?redirect=true">install Google Chrome Frame</a> to better experience this site.</p>
<![endif]-->
<div class="body">
    <div class="header-wrapper">
        <div class="topbar">
            <div class="container">
                <div class="row hidden-xs">
                    <div class="col-md-7 col-sm-7">
                        <span>Call Us @ {!! Option::getvalue('header_contact_no') !!} | Email @ <a href="mailto:{!! Option::getvalue('header_contact_email') !!}">{!! Option::getvalue('header_contact_email') !!}</a></span>
                    </div>
                    <div class="col-md-5 col-sm-5">
                        <ul class="pull-right social-icons">
                            @if(Option::getvalue('social_facebooklink') != "")
                                <li class="facebook">
                                    <a href="{!! Option::getvalue('social_facebooklink') !!}" target="_blank"><i class="fa fa-facebook-f"></i></a>
                                </li>
                            @endif

                            @if(Option::getvalue('social_twitterlink') != "")
                                <li class="twitter">
                                    <a href="{!! Option::getvalue('social_twitterlink') !!}" target="_blank"><i class="fa fa-twitter"></i></a>
                                </li>
                            @endif

                            @if(Option::getvalue('social_linkedinlink') != "")
                                <li class="linkedin">
                                    <a href="{!! Option::getvalue('social_linkedinlink') !!}" target="_blank"><i class="fa fa-linkedin"></i></a>
                                </li>
                            @endif

                            <li>|</li>
                            
                            @if(Auth::check())
                                <li class="login"><a href="{!! URL::to('profile') !!}"><i class="fa fa-user-circle-o"></i>&nbsp;Hi, {!! Auth::User()->firstName !!}</a></li>
                                <li>|</li>
                                <li><a href="{!! URL::to('profile/logout') !!}"><i class="fa fa-power-off"></i>&nbsp; Logout</a></li>
                            @else
                                <li class="login"><a href="{!! URL::to('login') !!}"><i class="fa fa-user-circle-o"></i>&nbsp; Member Login</a></li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <!-- Start Header -->
        <div class="site-header">
            <div class="container">
                <div class="site-logo">
                    <a href="{!! URL::to('') !!}">
                        <img src="/frontend/images/adclubmadras-logo.png" alt="" class="default-logo">
                    </a>
                </div>
                <a href="#" id="menu-toggle">Menu</a>
                <nav class="main-navigation pull-right">
                    <ul class="dd-menu sf-menu">
                        <li><a href="{!! URL::to('') !!}">Home</a></li>
                        <li><a href="{!! URL::to('about') !!}">About Us</a>
                            <ul>
                                <li><a href="{!! URL::to('about/past-presidents') !!}">Past Presidents</a></li>
                                <li><a href="{!! URL::to('about/executive-comittee') !!}">Executive Comittee</a></li>
                                <li><a href="{!! URL::to('about/our-facilities') !!}">Our Facilities</a></li>
                            </ul>
                        </li>
                        <li><a href="https://pgda.adclubmadras.com/" target="_blank">Course Offered</a></li>
                        <li><a href="{!!URL::to('membership')!!}">Membership</a>
                            <ul>
                                <li><a href="{!! URL::to('membership/membership-application') !!}">Membership Registration</a></li>
                            </ul>
                        </li>
                        <li><a href="{!! URL::to('events') !!}">Events</a>
                            <ul>
                                <li><a href="{!! URL::to('events/upcoming') !!}">Upcoming</a>
                                    <ul>
                                        <li><a href="{!! URL::to('events/upcoming') !!}">Ad Club Events</a></li>
                                        <li><a href="{!! URL::to('events/upcoming') !!}">Partner Events</a></li>
                                    </ul>
                                </li>
                                <?php
                                    $categories = EventCategories::where("status", "active")->get();
                                ?>
                                @foreach($categories as $category)
                                    <?php $link = $category->categorySlug?>
                                    <li><a href="{!! URL::to('events/'.$link) !!}">{!! ucwords($category->categoryName) !!}</a></li>
                                @endforeach
                            </ul>
                        </li>
                        {{-- <li><a href="{!! URL::to('news') !!}">News</a>
                            <ul>
                                <li><a href="{!! URL::to('news/upcoming') !!}">Upcoming</a></li>
                                <?php
                                    $categories = NewsCategories::where("status", "active")->get();
                                ?>
                                @foreach($categories as $category)
                                    <?php $link = $category->categorySlug?>
                                    <li><a href="{!! URL::to('news/'.$link) !!}">{!! ucwords($category->categoryName) !!}</a></li>
                                @endforeach
                            </ul>
                        </li> --}}
                        <li><a href="{!! URL::to('gallery') !!}">Gallery</a>
                            <ul>
                            <?php
                                    $categories = GalleryCategories::where("status", "active")->get();
                                ?>
                            @foreach($categories as $category)
                                <?php $link = $category->categorySlug ?>
                                <li><a href="{!! URL::to('gallery/'.$link) !!}">{!! ucwords($category->categoryName) !!}</a></li>
                            @endforeach    
                            </ul>
                        </li>
                        <li><a href="{!! URL::to('job-opportunities') !!}">Jobs</a></li>
                        <li><a href="{!! URL::to('contact') !!}">Contact Us</a></li>
                        @if(Auth::check())
                            <li class="login hidden-md hidden-lg"><a href="{!! URL::to('profile') !!}"><i class="fa fa-user-circle-o"></i>&nbsp;Hi, {!! Auth::User()->firstName !!}</a></li>
                            <li class="hidden-md hidden-lg"><a href="{!! URL::to('profile/logout') !!}"><i class="fa fa-power-off"></i>&nbsp; Logout</a></li>
                        @else
                            <li class="login hidden-md hidden-lg"><a href="{!! URL::to('login') !!}"><i class="fa fa-user-circle-o"></i>&nbsp; Member Login</a></li>
                        @endif
                    </ul>
                </nav>
            </div>
        </div>
    </div>

    @yield('content')

    <!-- Site Footer -->
    <div class="site-footer">
        <div class="container">
            <div class="footer-row2">
                <ul class="pull-right social-icons social-icons-colored">
                    @if(Option::getvalue('social_facebooklink') != "")
                        <li class="facebook">
                            <a href="{!! Option::getvalue('social_facebooklink') !!}" target="_blank"><i class="fa fa-facebook-f"></i></a>
                        </li>
                    @endif

                    @if(Option::getvalue('social_twitterlink') != "")
                        <li class="twitter">
                            <a href="{!! Option::getvalue('social_twitterlink') !!}" target="_blank"><i class="fa fa-twitter"></i></a>
                        </li>
                    @endif

                    @if(Option::getvalue('social_linkedinlink') != "")
                        <li class="linkedin">
                            <a href="http://in.linkedin.com/pub/advertising-club-madras/79/b07/454" target="_blank"><i class="fa fa-linkedin"></i></a>
                        </li>
                    @endif
                </ul>

                <ul class="footer-menu">
                    <li><a href="{!! URL::to('privacy-policy') !!}">Privacy Policy</a></li>
                    <li><a href="{!! URL::to('terms-conditions') !!}">Terms & Conditions</a></li>
                    <li><a href="{!! URL::to('refund-and-cancellation') !!}">Refund and Cancellation</a></li>
                    <!--<li><a href="javascript:;">Sitemap</a></li>-->
                </ul>
            </div>

            <div class="footer-row3">
                <p>{!! Option::getvalue('footer_copyright') !!} <span class="pull-right">Designed by <a href="http://pixelhubstudio.com/" target="_blank">Pixel Hub Studio</a></span></p>
            </div>
        </div>
    </div>
    <a id="back-to-top"><i class="fa fa-angle-double-up"></i></a> 
</div>
<!-- SCRIPTS -->
{!! HTML::script('frontend/js/modernizr.js') !!}<!-- Modernizr -->
{!! HTML::script('frontend/js/jquery-2.2.3.min.js') !!}
{!! HTML::script('frontend/js/jquery.imageview.js') !!}
{!! HTML::script('frontend/vendor/magnific/jquery.magnific-popup.min.js') !!}
{!! HTML::script('frontend/js/ui-plugins.js') !!}
{!! HTML::script('frontend/js/helper-plugins.js') !!}
{!! HTML::script('frontend/vendor/owl-carousel/js/owl.carousel.min.js') !!}
{!! HTML::script('frontend/js/bootstrap.js') !!}
{!! HTML::script('frontend/js/init.js') !!}
{!! HTML::script('frontend/js/sweetalert.min.js') !!}
{!! HTML::script('frontend/vendor/flexslider/js/jquery.flexslider.js') !!}
<script type="text/javascript">
    $('#acmgallery').imageview();
</script>
@yield("script")
</body>
</html>