<?php
    use App\Models\Option;
?>
@extends('frontend/master')
@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Application for Membership</h1>
                <ol class="breadcrumb">
                    <li><a href="{!! URL::to('') !!}">Home</a></li>
                    <li><a href="{!! URL::to('membership') !!}">Membership</a></li>
                    <li>Application for Membership</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                @if(Auth::check())
                    @if(isset($basicInfo))
                        <div class="loadingDiv">
                          <div class="overlay"></div>
                          <div class="modal-loader bg-color1">
                            <div class="spinner">
                              <div class="bounce1"></div>
                              <div class="bounce2"></div>
                              <div class="bounce3"></div>
                              <p class="text-center">Processing.... Please wait...</p>
                            </div>
                          </div>
                        </div>
                        @include('frontend.payment-form-template', ['basicInfo' => $basicInfo])
                    @else
                        <div class="col-md-10 col-md-offset-1">
                            <div class="text-center">
                               <p>We hereby apply for Membership to <b>THE ADVERTISING CLUB MADRAS</b> , if selected we will be goverened by<br>
                                The By – Laws and rules and regulations of the club . “ Annual Subscription ‘’ </p>
                           </div>

                            <hr class="md">
                            @if($record && $record->paymentDate)
                                <div class="alert alert-info">Your last transaction date is {{ date('d-M-Y', strtotime($record->paymentDate)) }}</div>
                            @endif

                            <?php
                                $corporateAmount = Option::getvalue('corporate');
                                $IndividualAmount = Option::getvalue('individual');
                                $studentAmount = Option::getvalue('student');
                                $currentServiceTax = Option::getvalue('GST'); 

                                //corporate
                                $corpPayable = $corporateAmount / 100;
                                $finalCorporateCost = ceil($corporateAmount + ($corpPayable*$currentServiceTax));

                                //individual
                                $indiPayable = $IndividualAmount / 100;
                                $finalIndividualCost = ceil($IndividualAmount + ($indiPayable*$currentServiceTax));

                                //student
                                $studPayable = $studentAmount / 100;
                                $finalStudentCost = ceil($studentAmount + ($studPayable*$currentServiceTax));

                            ?>
                            @if(Session::has('warnings'))
                                <div class="alert alert-danger">{{ Session::get('warnings') }}</div>
                            @endif
                            {!! Form::open(["url"=>"membership/membership-application"]) !!}
                                <?php
                                    $category = 'corporate';
                                    $companyname = '';
                                    $contactperson = '';
                                    $address = '';
                                    $phoneno = '';
                                    $mobileno = '';
                                    $emailid = '';
                                    $fb = '';
                                    $twi = '';
                                    $ln = '';
                                    $members = [];
                                    if($record){
                                        $category = $record->mem_category;
                                        $companyname = $record->org_name;
                                        $contactperson = $record->con_person;
                                        $address = $record->address;
                                        $phoneno = $record->phone;
                                        $mobileno = $record->mobile;
                                        $emailid = $record->email;
                                        $fb = $record->facebook;
                                        $twi = $record->twitter;
                                        $ln = $record->linkedin;
                                        if($record->members){
                                            $members = json_decode($record->members);
                                        }
                                    }

                                    if(old('category') && old('category') != ''){
                                        $category = old('category');
                                    }
                                ?>
                                <div><label>Category of Membership: <span class="req">*</span></label></div>
                                <div class="row">
                                    <div class="col-md-4 col-sm-4">
                                        <label>
                                            <input type="radio" class="option-input radio radiobut" value="corporate" name="category" id="category" @if($category == 'corporate')  checked="checked" @endif/>
                                            Corporate Rs.{!! $finalCorporateCost !!}/-
                                        </label>
                                    </div>

                                    <div class="col-md-4 col-sm-4">
                                        <label>
                                            <input type="radio" class="option-input radio radiobut" value="individual" name="category" id="individual" @if($category == 'individual')  checked="checked" @endif/>
                                            Individual Rs.{!! $finalIndividualCost !!}/-
                                        </label>
                                    </div>

                                    <div class="col-md-4 col-sm-4">
                                        <label>
                                            <input type="radio" class="option-input radio radiobut" value="student" name="category" id="student" @if($category == 'student')  checked="checked" @endif/>
                                            Student Rs.{!! $finalStudentCost !!}/-
                                        </label>
                                    </div>
                                </div><!--end row-->

                                <div class="spacer-10"></div>

                                <hr class="md">

                                <div id="cate">
                                    <div id="validation_cate">
                                        <div class="row">
                                            <div class="col-md-6 col-sm-6">
                                                <label>Name of the Organisation <span class="req">*</span></label>
                                                {!! Form::text('companyname_c', $companyname, ['class' => 'form-control input-lg', 'id' => 'companyname_c']) !!}
                                                @if($errors->has('companyname_c'))
                                                    <div class='validation_msg' style='color:red; margin-top:-10px'>{{ $errors->first('companyname_c')}}</div>
                                                @endif
                                            </div>

                                            <div class="col-md-6 col-sm-6">
                                                <label>Contact Person <span class="req">*</span></label>
                                                {!! Form::text('contactperson_c', $contactperson, ['class' => 'form-control input-lg', 'id' => 'contactperson_c']) !!}
                                                @if($errors->has('contactperson_c'))
                                                    <div class='validation_msg' style='color:red; margin-top:-10px'>{{ $errors->first('contactperson_c')}}</div>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6 col-sm-6">
                                                <label>Address <span class="req">*</span></label>
                                                {!! Form::textarea('address1_c', $address, ['class' => 'form-control input-lg', 'id' => 'address1_c', 'rows' => 4]) !!}
                                                @if($errors->has('address1_c'))
                                                    <div class='validation_msg' style='color:red; margin-top:-10px'>{{ $errors->first('address1_c')}}</div>
                                                @endif
                                            </div>

                                            <div class="col-md-3 col-sm-6">
                                                <label>Telephone</label>
                                                {!! Form::text('phoneno_c', $phoneno, ['class' => 'form-control input-lg', 'id' => 'phoneno_c']) !!}
                                                @if($errors->has('phoneno_c'))
                                                    <div class='validation_msg' style='color:red; margin-top:-10px'>{{ $errors->first('phoneno_c')}}</div>
                                                @endif
                                            </div>

                                            <div class="col-md-3 col-sm-6">
                                                <label>Mobile Number <span class="req">*</span></label>
                                                {!! Form::text('mobileno_c', $mobileno, ['class' => 'form-control input-lg', 'id' => 'mobileno_c', 'placeholder' => 'Enter valid Mobile Number']) !!}
                                                @if($errors->has('mobileno_c'))
                                                    <div class='validation_msg' style='color:red; margin-top:-10px'>{{ $errors->first('mobileno_c')}}</div>
                                                @endif
                                            </div>

                                            <div class="col-md-6 col-sm-6">
                                                <label>Email ID <span class="req">*</span></label>
                                                {!! Form::text('emailid_c', $emailid, ['class' => 'form-control input-lg', 'id' => 'emailid_c', 'placeholder' => 'Enter valid Email Address']) !!}
                                                @if($errors->has('emailid_c'))
                                                    <div class='validation_msg' style='color:red; margin-top:-10px'>{{ $errors->first('emailid_c')}}</div>
                                                @endif
                                            </div>
                                        </div>

                                        <hr class="md">

                                        <div><label>Social Profile Links:</label></div>
                                        <div class="row">
                                            <div class="col-md-4 col-sm-12">
                                                <label>Facebook</label>
                                                {!! Form::text('fb_c', $fb, ['class' => 'form-control input-lg', 'id' => 'fb_c', 'placeholder' => 'Facebook URL']) !!}
                                                @if($errors->has('fb_c'))
                                                    <div class='validation_msg' style='color:red; margin-top:-10px'>{{ $errors->first('fb_c')}}</div>
                                                @endif
                                            </div>

                                            <div class="col-md-4 col-sm-12">
                                                <label>Twitter</label>
                                                {!! Form::text('twi_c', $twi, ['class' => 'form-control input-lg', 'id' => 'twi_c', 'placeholder' => 'Twitter URL']) !!}
                                                @if($errors->has('twi_c'))
                                                    <div class='validation_msg' style='color:red; margin-top:-10px'>{{ $errors->first('twi_c')}}</div>
                                                @endif
                                            </div>

                                            <div class="col-md-4 col-sm-12">
                                                <label>Linkedin</label>
                                                {!! Form::text('ln_c', $ln, ['class' => 'form-control input-lg', 'id' => 'ln_c', 'placeholder' => 'Linkedin URL']) !!}
                                                @if($errors->has('ln_c'))
                                                    <div class='validation_msg' style='color:red; margin-top:-10px'>{{ $errors->first('ln_c')}}</div>
                                                @endif
                                            </div>
                                        </div>

                                        <hr class="md">

                                        <div class="row">
                                            <div class="col-md-9">
                                                <h4 class="accent-color margin-5">Members Nominated</h4>
                                                <p class="margin-10">After Five Nominees, every additional nominee will be payable sum of rupees 690 (Inclusive of GST)</p>
                                            </div>

                                            <div class="col-md-3 text-right">
                                                <a class="btn btn-primary btn-md" href="javascript:;" id="addNew">
                                                    <i class="fa fa-user-circle-o"></i>
                                                    &nbsp; Add Member
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="md">

                                    <input type="hidden" name="tot_mem" id="tot_mem" value="5" class="">

                                    <?php
                                        $total_count = 5;
                                        if(count($members) > $total_count){
                                            $total_count = count($members);
                                        }

                                    ?>

                                    @for($i = 0; $i < $total_count; $i++)
                                        <h4 class="accent-color margin-5 member_nominated  members_{!! $i !!}"><b>Member {!! $i + 1 !!}</b>
                                            <span class="pull-right remove-member"></span>
                                        </h4>

                                        <?php
                                            $name = '';
                                            $email = '';
                                            $mobile = '';
                                            $designation = '';
                                            if(isset($members[$i])){
                                                $name = $members[$i]->name;
                                                $designation = $members[$i]->designation;
                                                $email = $members[$i]->email;
                                                $mobile = $members[$i]->mobile;
                                            }

                                        ?>
                                    
                                        <table class="table table-bordered nominee-members">
                                            <thead>
                                                <tr>
                                                    <th><b>Name</b></th>
                                                    <th><b>Designation</b></th>
                                                    <th><b>Email ID</b></th>
                                                    <th><b>Mobile No.</b></th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                <tr>
                                                    <td><input type="text" id="name{!! $i !!}" name="name{!! $i !!}" class="form-control input-lg" value="{{ old('name'.$i, $name)}}"></td>
                                                    <td><input type="text" id="designation{!! $i !!}" name="designation{!! $i !!}" class="form-control input-lg" value="{{ old('designation'.$i, $designation)}}"></td>
                                                    <td><input type="text" id="email{!! $i !!}" name="email{!! $i !!}" class="form-control input-lg" value="{{ old('email'.$i, $email)}}"></td>
                                                    <td><input type="text" id="mobile{!! $i !!}" name="mobile{!! $i !!}" class="form-control input-lg" value="{{ old('mobile'.$i, $mobile)}}"></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    @endfor

                                    <div id="addinput"></div>

                                    <p><b>Payment Breakup Details:</b>
                                    <ul class="carets">
                                        <li>
                                            Rs. {!! Option::getvalue("corporate") !!}/- + {!! Option::getvalue("GST") !!}% (CGST {!! Option::getvalue("GST") / 2 !!}%, SGST {!! Option::getvalue("GST") / 2 !!}%) = {!! (Option::getvalue("corporate") + ((Option::getvalue("corporate") / 100) * Option::getvalue("GST"))) !!}/-for Corporates
                                        </li>

                                        <li>
                                            Rs. {!! Option::getvalue("individual") !!}/- + {!! Option::getvalue("GST") !!}% (CGST {!! Option::getvalue("GST") / 2 !!}%, SGST {!! Option::getvalue("GST") / 2 !!}%) = {!! (Option::getvalue("individual") + ((Option::getvalue("individual") / 100) * Option::getvalue("GST"))) !!}/- for Individuals
                                        </li>

                                        <li>
                                            Rs. {!! Option::getvalue("student") !!}/- + {!! Option::getvalue("GST") !!}% (CGST {!! Option::getvalue("GST") / 2 !!}%, SGST {!! Option::getvalue("GST") / 2 !!}%) = {!! (Option::getvalue("student") + ((Option::getvalue("student") / 100) * Option::getvalue("GST"))) !!}/- for Students
                                        </li>
                                    </ul>

                                    For members those who make payments in offine, Cheques should be drawn in favour of <b>“Advertising Club Madras’’</b></p>

                                    <p>Note: (Please note that any change of names or address during the year, may please be notified immediately to the Secretariat). email: <a href="mailto:advertisingclubmadras@gmail.com">advertisingclubmadras@gmail.com</a></p>

                                    <div class="spacer-30"></div>

                                    <div class="b-links">
                                        <h4 class="margin-0">Selected Membership Category: <span class="accent-color"><b>CORPORATE</b></span><br>
                                        Amount Payable (Up to five nominees): Rs. <span id="head_corp_amount">{!! $finalCorporateCost !!}</span>/- (Including Sevice Tax)</h4>
                                    </div>

                                    <div class="spacer-30"></div>

                                    <label>
                                        <input type="checkbox" name="terms" value="agreed" id="terms" class="option-input checkbox" CHECKED /><span id="ter1">
                                        I agree to the <a href="">Terms and Conditions</a> of Advertising Club Madras<br><span id="ter1"></span>
                                    </label>

                                    <div class="spacer-40"></div>

                                    <div class="clearfix">
                                        <button type="submit" id="corp" name="submit" class="btn btn-primary btn-lg">Submit</button>
                                    </div>
                                </div>
                            
                                <div id="indi" style="display:none;">
                                    <div class="row">
                                        <div class="col-md-6 col-sm-6">
                                            <label><span id="stu_name">Name of the Individual</span> <span class="req">*</span></label>
                                            {!! Form::text('companyname_i', $companyname, ['class' => 'form-control input-lg', 'id' => 'companyname_i']) !!}
                                            @if($errors->has("companyname_i"))
                                                <span class="req">{!! $errors->first("companyname_i") !!}</span>
                                            @endif
                                        </div>

                                        <div class="col-md-6 col-sm-6">
                                            <label>Contact Person <span class="req">*</span></label>
                                            {!! Form::text('contactperson_i', $contactperson, ['class' => 'form-control input-lg', 'id' => 'contactperson_i']) !!}
                                            @if($errors->has("contactperson_i"))
                                                <span class="req">{!! $errors->first("contactperson_i") !!}</span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 col-sm-6">
                                            <label>Address <span class="req">*</span></label>
                                            {!! Form::textarea('address1_i', $address, ['class' => 'form-control input-lg', 'id' => 'address1_i', 'rows' => 4]) !!}
                                            @if($errors->has("address1_i"))
                                                <span class="req">{!! $errors->first("address1_i") !!}</span>
                                            @endif
                                        </div>

                                        <div class="col-md-3 col-sm-6">
                                            <label>Telephone</label>
                                            {!! Form::text('phoneno_i', $phoneno, ['class' => 'form-control input-lg', 'id' => 'phoneno_i']) !!}
                                            @if($errors->has("phoneno_i"))
                                                <span class="req">{!! $errors->first("phoneno_i") !!}</span>
                                            @endif
                                        </div>

                                        <div class="col-md-3 col-sm-6">
                                            <label>Mobile Number <span class="req">*</span></label>
                                            {!! Form::text('mobileno_i', $mobileno, ['class' => 'form-control input-lg', 'id' => 'mobileno_i', 'placeholder' => 'Enter valid Mobile Number']) !!}
                                            @if($errors->has("mobileno_i"))
                                                <span class="req">{!! $errors->first("mobileno_i") !!}</span>
                                            @endif
                                        </div>

                                        <div class="col-md-6 col-sm-6">
                                            <label>Email ID <span class="req">*</span></label>
                                            {!! Form::text('emailid_i', $emailid, ['class' => 'form-control input-lg', 'id' => 'emailid_i', 'placeholder' => 'Enter valid Email Address']) !!}
                                            @if($errors->has("emailid_i"))
                                                <span class="req">{!! $errors->first("emailid_i") !!}</span>
                                            @endif
                                        </div>
                                    </div>

                                    <hr class="md">

                                    <div><label>Social Profile Links:</label></div>
                                    <div class="row">
                                        <div class="col-md-4 col-sm-12">
                                            <label>Facebook</label>
                                            {!! Form::text('fb_i', $fb, ['class' => 'form-control input-lg', 'id' => 'fb_i', 'placeholder' => 'Facebook URL']) !!}
                                            @if($errors->has("fb_i"))
                                                <span class="req">{!! $errors->first("fb_i") !!}</span>
                                            @endif
                                        </div>

                                        <div class="col-md-4 col-sm-12">
                                            <label>Twitter</label>
                                             {!! Form::text('twi_i', $twi, ['class' => 'form-control input-lg', 'id' => 'twi_i', 'placeholder' => 'Twitter URL']) !!}
                                             @if($errors->has("twi_i"))
                                                <span class="req">{!! $errors->first("twi_i") !!}</span>
                                            @endif
                                        </div>

                                        <div class="col-md-4 col-sm-12">
                                            <label>Linkedin</label>
                                            {!! Form::text('ln_i', $ln, ['class' => 'form-control input-lg', 'id' => 'ln_i', 'placeholder' => 'Linkedin URL']) !!}
                                            @if($errors->has("ln_i"))
                                                <span class="req">{!! $errors->first("ln_i") !!}</span>
                                            @endif
                                        </div>
                                    </div>

                                    <hr class="md">

                                    <p><b>Payment Breakup Details:</b>
                                    <ul class="carets">
                                        <li>
                                            Rs. {!! Option::getvalue("corporate") !!}/- + {!! Option::getvalue("GST") !!}% (CGST {!! Option::getvalue("GST") / 2 !!}%, SGST {!! Option::getvalue("GST") / 2 !!}%) = {!! (Option::getvalue("corporate") + ((Option::getvalue("corporate") / 100) * Option::getvalue("GST"))) !!}/-for Corporates
                                        </li>

                                        <li>
                                            Rs. {!! Option::getvalue("individual") !!}/- + {!! Option::getvalue("GST") !!}% (CGST {!! Option::getvalue("GST") / 2 !!}%, SGST {!! Option::getvalue("GST") / 2 !!}%) = {!! (Option::getvalue("individual") + ((Option::getvalue("individual") / 100) * Option::getvalue("GST"))) !!}/- for Individuals
                                        </li>

                                        <li>
                                            Rs. {!! Option::getvalue("student") !!}/- + {!! Option::getvalue("GST") !!}% (CGST {!! Option::getvalue("GST") / 2 !!}%, SGST {!! Option::getvalue("GST") / 2 !!}%) = {!! (Option::getvalue("student") + ((Option::getvalue("student") / 100) * Option::getvalue("GST"))) !!}/- for Students
                                        </li>
                                    </ul>

                                    For members those who make payments in offine, Cheques should be drawn in favour of <b>“Advertising Club Madras’’</b></p>

                                    <p>Note: (Please note that any change of names or address during the year, may please be notified immediately to the Secretariat). email: <a href="mailto:advertisingclubmadras@gmail.com">advertisingclubmadras@gmail.com</a></p>

                                    <div class="spacer-30"></div>

                                    <div id="bot_indi" style="display:none;">
                                        <div class="b-links">
                                            <h4 class="margin-0">Selected Membership Category: <span class="accent-color"><b>INDIVIDUAL</b></span><br>
                                            Amount Payable: Rs. <span id="indi_amount"></span>/- (Including GST)</h4>
                                        </div>
                                        <input type="hidden" name="indi_amount" class="indi_amount" value="{!! $finalIndividualCost !!}"/>
                                    </div>

                                    <div id="bot_stu" style="display:none;">
                                        <div class="b-links">
                                            <h4 class="margin-0">Selected Membership Category: <span class="accent-color"><b>STUDENT</b></span><br>
                                            Amount Payable: Rs. <span id="stu_amount"></span>/- (Including GST)</h4>
                                        </div>
                                        <input type="hidden" name="stu_amount" class="stu_amount" value="{!! $finalStudentCost !!}"/>
                                    </div>

                                    <div class="spacer-30"></div>

                                    <label>
                                        <input type="checkbox" class="option-input checkbox" id="terms1" CHECKED />
                                        I agree to the <a href="javascript:void(0)">Terms and Conditions</a> of Advertisement club Madras
                                        <span id="ter2"></span>
                                    </label>

                                    <div class="spacer-40"></div>

                                    <div class="clearfix">
                                        <button type="submit" id="individuals" name="individuals" class="btn btn-primary btn-lg">Submit</button>
                                    </div>
                                </div>
                            {!! Form::close() !!}
                        </div>
                    @endif
                @else
                    <div class="col-md-10 col-md-offset-1">
                        <div class="text-center">
                           <p>We hereby apply for Membership to <b>THE ADVERTISING CLUB MADRAS</b> , if selected we will be goverened by<br>
                            The By – Laws and rules and regulations of the club . “ Annual Subscription ‘’ </p>
                        
                        <hr>
                        <div class="mt-30 mb-20">
                            <img src="{!! URL::asset('frontend/images/members.png') !!}">
                        </div>
                        <h3 class="margin-0">Please login to submit your application</h3>
                        <hr class="alt">

                        <div><a href="{!! URL::to('login') !!}" class="btn btn-primary btn-lg">Apply Now</a></div>
                        
                        <hr>
                        <div class="spacer-100"></div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@stop



@section("script")
    <script>
        @if(isset($basicInfo))
            $("#hiddenFormBox").submit();
        @endif
        $(document).on('click', '.radiobut', function() {
            showcategory();
        });

        showcategory();

        function showcategory(){
            var id = $("input[name='category']:checked").attr('id');//$(this).attr('id');
            if(id == 'category') {
                $('#indi').hide();
                $('#cate').show();
                $('#bot_corp').show();
                $('.individualmsg').hide();
                $('.studentmsg').hide();
            } else {
                $('#cate').hide();
                $('#indi').show();
                $('.corporatemsg').hide();
                if(id == "individual"){
                    $('#stu_name').html('Name of the Individual');
                    $('#stu_insi').html('Name of the working company');
                    $('#bot_indi').show();
                    $('#bot_stu').hide();
                    $('.studentmsg').hide();
                    var indi_amn = "{!! Option::getvalue('individual') !!}";
                    var re_ind_amn = indi_amn / 100;
                    var ind_ser_tx = "{!! Option::getvalue('GST') !!}";
                    var indi_tax_amn = re_ind_amn * ind_ser_tx;
                    var fin_ind_amn = Math.ceil(parseInt(indi_amn) + parseInt(indi_tax_amn));
                    $('#indi_amount').text(fin_ind_amn);
                    $('.indi_amount').val(fin_ind_amn);
                } else{
                    $('#stu_name').html('Name of the Student');
                    $('#stu_insi').html('Name of the Institution');
                    $('#bot_stu').show();
                    $('#bot_indi').hide();
                    $('.individualmsg').hide();
                    var stud_amn = "{!! Option::getvalue('student') !!}";
                    var re_stud_amn = stud_amn / 100;
                    var stu_ser_tx = "{!! Option::getvalue('GST') !!}";
                    var stu_tax_amn = re_stud_amn * stu_ser_tx;
                    var fin_stud_amn = Math.ceil(parseInt(stud_amn) + parseInt(stu_tax_amn));
                    $('#stu_amount').html(fin_stud_amn);
                    $('.stu_amount').val(fin_stud_amn);
                }
            }
        }

        $(document).on('click', '#addNew', function(){
            var tot_mem = $('#tot_mem').val();
            var num = $('.member_nominated').length;
            var i = 0;
            var result = "yes";
            for(i = 0; i < num; i++){        
                var name = $('#name'+i).val();
                var designation = $('#designation'+i).val();
                var email = $('#email'+i).val();
                var mobile = $('#mobile'+i).val();
                if(name == ''){
                   swal('Mandatory', 'Please fill the required fields', 'info');
                   return false;
                } else {
                    result = "yes";
                }
            }

            if(result == "yes"){ 
                swal({
                    title: "Are you sure?",
                    text: "After five nominees, every additional nominee will be payable sum of rupees 690 (Including GST) Would you like to proceed?",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                })
                .then((willDelete) => {
                    if(!willDelete) {
                        return false;
                    }
                    var req_num = parseInt(num) + 1;
                    $('#tot_mem').val(req_num);
           
                    //Append code
                    var req_code = '<div class="maindiv_members'+num+'"><h4 class="accent-color margin-5 member_nominated  members_'+num+'"><b><span class="title'+num+'">Member '+req_num+'</span></b>';
                    req_code += '<span class="pull-right remove-member"><a class="remove_member remove_member'+num+'" id="'+num+'" href="javascript:void(0)">Remove this member &nbsp;<i class="fa fa-minus-circle"></i></a></span></h4>';
                            
                    req_code += '<table class="table table-bordered nominee-members">';
                    req_code += '<thead>';
                    req_code += '<tr>';
                    req_code += '<th><b>Name</b></th>';
                    req_code += '<th><b>Designation</b></th>';
                    req_code += '<th><b>Email ID</b></th>';
                    req_code += '<th><b>Mobile No.</b></th>';
                    req_code += '</tr>';
                    req_code += '</thead>';

                    req_code += '<tbody>';
                    req_code += '<tr>';
                    req_code += '<td><input type="text" id="name'+num+'" name="name'+num+'" class="form-control input-lg"></td>';
                    req_code += '<td><input type="text" id="designation'+num+'" name="designation'+num+'" class="form-control input-lg"></td>';
                    req_code += '<td><input type="text" id="email'+num+'" name="email'+num+'" class="form-control input-lg"></td>';
                    req_code += '<td><input type="text" id="mobile'+num+'" name="mobile'+num+'" class="form-control input-lg"></td>';
                    req_code += '</tr>';
                    req_code += '</tbody>';
                    req_code += '</table>';
                    req_code += '</div>';

                    $('#addinput').append(req_code);
                    var corpPrice = "{!! Option::getvalue('corporate') !!}";
                    var withouttaxamt = parseFloat(corpPrice) + parseFloat(500 * (req_num - 5));
                    var tax = "{!! Option::getvalue('GST') !!}";
                    var taxamount = (parseFloat(withouttaxamt) * parseFloat(tax)) / 100;
                    var withtax = parseFloat(withouttaxamt) + parseFloat(taxamount);
                    $('#corp_amount').text(Math.ceil(withtax));
                    $('#head_corp_amount').text(Math.ceil(withtax));
                    return false;
                });/* end of .then function */
            } else {
               swall('Mandatory', 'Please fill the required fields', 'info');
               return false;
            }
        });

        $(document).on('click', '.remove_member', function(){
            var tot_mem = $('#tot_mem').val();
            var req_tot_mem = parseInt(tot_mem)-1;
            $('#tot_mem').val(req_tot_mem);
            var id = $(this).attr('id');//5
            var i = 0;
            $('.maindiv_members'+id).remove();
            var req_id = parseInt(id) + 1;//6
            var total_len = $('.member_nominated').length;//7
            if(req_id > total_len){
                var corpPrice = "{!! Option::getvalue('corporate') !!}";
                var withouttaxamt = parseInt(corpPrice) + parseInt(600 * (total_len - 5));
                var tax = "{!! Option::getvalue('GST') !!}";
                var taxamount = (parseFloat(withouttaxamt) * parseFloat(tax)) / 100;
                var withtax = parseFloat(withouttaxamt) + parseFloat(taxamount);
                $('#corp_amount').text(Math.ceil(withtax));
                $('#head_corp_amount').text(Math.ceil(withtax));
                return false;
            } else {
                var substract = parseInt(total_len) - parseInt(id);//2
                for(i = 0; i < substract; i++){
                    $('.maindiv_members'+req_id).addClass('maindiv_members'+id).removeClass('maindiv_members'+req_id);
                    $('.title'+req_id).html('Member '+req_id);
                    $('.members_'+req_id).addClass('members_'+id).removeClass('members_'+req_id);
                    $('.remove_member'+req_id).attr('id',id);
                    $('.remove_member'+req_id).addClass('remove_member'+id).removeClass('remove_member'+id);
                    $('#name'+req_id).attr('name','name'+id);
                    $('#name'+req_id).attr('id','name'+id);
                   
                   $('#designation'+req_id).attr('name','designation'+id);
                   $('#designation'+req_id).attr('id','designation'+id);
                   
                   $('#email'+req_id).attr('name','email'+id);
                   $('#email'+req_id).attr('id','email'+id);
                   
                   $('#mobile'+req_id).attr('name','mobile'+id);
                   $('#mobile'+req_id).attr('id','mobile'+id);
                   id++;
                   req_id++;
                }
               
                //var withouttaxamt = (total_len - 1) * 500;
                var corpPrice = "{!! Option::getvalue('corporate') !!}";
                var withouttaxamt = parseInt(corpPrice) + parseInt(600 * (total_len - 5));
                var tax = "{!! Option::getvalue('GST') !!}";
                var taxamount = (parseFloat(withouttaxamt) * parseFloat(tax)) / 100;
                var withtax = parseFloat(withouttaxamt) + parseFloat(taxamount);
                $('#corp_amount').text(Math.ceil(withtax));
                $('#head_corp_amount').text(Math.ceil(withtax));
            }
        });

        $(document).on("click", "#corp", function(){
            $(".validation_msg").remove();
            var error = "no";
            $("#validation_cate :input").each(function(){
                var fieldid = $(this).attr('id');
                if(fieldid != 'address2_c' && fieldid != 'phoneno_c'  && fieldid != 'fb_c'  && fieldid != 'twi_c' && fieldid != 'ln_c'){
                    var fieldvalue = $(this).val();
                    if(fieldvalue == '' || fieldvalue == null){
                       $('#'+fieldid).after("<div class='validation_msg'>Don't leave this field empty.</div>");
                       $('html, body').animate({
                            scrollTop: $("#"+fieldid).parent().position().top
                        }, 1000);
                       error = "yes";
                       return false;
                    }
                }
           
                if(fieldid == 'mobileno_c'){
                   var mob_num = $('#mobileno_c').val();
                    var filter = /^[0-9-+ ]+$/ ;
                    if (!filter.test(mob_num)) {
                        $('#'+fieldid).after("<div class='mobileno_msg'>Please enter valid Mobile number.</div>");
                        $('html, body').animate({
                            scrollTop: $("#"+fieldid).parent().position().top
                        }, 1000);
                        error = "mobile";
                        return false;
                    }
                }
            });
            
            if(error == "yes"){
                return false;
            }
            
            if(error==  "mobile"){
                return false;
            }
            
            var num = $('.member_nominated').length;
            for(i = 5; i < num; i++){     
                var name = $('#name'+i).val();
                var designation = $('#designation'+i).val();
                var email = $('#email'+i).val();
                var mobile = $('#mobile'+i).val();
                var j = parseInt(i) + parseInt(1);
                if(name == '' && designation == '' && email == '' && mobile == ''){
                    swal("Value Missing!", "Please fill the required fields in Member "+j, "info");
                    return false;
                }
            }
               
            if(!$('#terms').is(":checked")){
                $('#ter1').after("<div class='validation_msg' style='color:red;'><br>Please agree to our terms and conditions.</div>");
                return false;
            }
        });

        $(document).on("click", "#individuals", function(){
            $(".validation_msg").remove();
            var error = "no";
            $("#indi :input").each(function(){
                var fieldid = $(this).attr('id');
                if(fieldid != 'address2_i' && fieldid != 'phoneno_i'  && fieldid != 'fb_i'  && fieldid != 'twi_i' && fieldid != 'ln_i' && fieldid != 'individuals'){
                    var fieldvalue = $(this).val();
                    if(fieldvalue == '' || fieldvalue == null){
                       $('#'+fieldid).after("<div class='validation_msg' style='color:red; margin-top:-10px'>Don't leave this empty.</div>");
                       $('html, body').animate({
                            scrollTop: $("#"+fieldid).parent().position().top
                        }, 1000);
                       error = "yes";
                       return false;
                    }
                }
         
                // if(fieldid == 'phoneno_i'){
                //     var ph_num = $('#phoneno_i').val();
                //     var filter = /^[0-9-+ ]+$/ ;
                //     if(!filter.test(ph_num)) {
                //         $('#'+fieldid).after("<div class='phoneno_msg' style='color:red; margin-top:-10px'>Please enter valid Phone number.</div>");
                //         $('html,body').animate({ scrollTop: $('#'+fieldid).offset().top }, 500);
                //         error = "phone";
                //         return false;
                //     }
                // }
          
                if(fieldid == 'mobileno_i'){
                    var mob_num = $('#mobileno_i').val();
                    var filter = /^[0-9-+ ]+$/ ;
                    if (!filter.test(mob_num)) {
                        $('#'+fieldid).after("<div class='mobileno_msg' style='color:red; margin-top:-10px'>Please enter valid Mobile number.</div>");
                        $('html, body').animate({
                            scrollTop: $("#"+fieldid).parent().position().top
                        }, 1000);
                        error = "mobile";
                        return false;
                    }
                }
            });

            if(error == "yes"){
                return false;
            }
        
            // if(error == "phone"){
            //     setTimeout(function(){  $(".phoneno_msg").hide(); }, 5000);
            //     return false;
            // }
            
            if(error == "mobile"){
                return false;
            }

            if(!$('#terms1').is(":checked")){
                $('#ter2').after("<div class='validation_msg' style='color:red;'>Please Check terms and condition.</div>");
                return false;
            }      
        });
    </script>
@stop