<?php 
    use App\Models\CustomPages; 
    use App\Models\Option; 
?>
@extends('frontend/master')
@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>{!! CustomPages::getcontent("membershipMainPageTitle") !!}</h1>
                <ol class="breadcrumb">
                    <li><a href="{!!URL::to('')!!}">Home</a></li>
                    <li>{!! CustomPages::getcontent("membershipMainPageTitle") !!}</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-xs-12 col-sm-4 col-md-3">
                            <h2 class="accent-color">Ad Club's Membership</h3>
                            <a class="btn btn-primary btn-lg btn-block margin-20" href="{!! URL::to('membership/membership-application') !!}">
                                <i class="fa fa-user-circle-o"></i>
                                &nbsp; New / Renew Membership
                            </a>
                            {{-- @if(Auth::check())
                                <a class="btn btn-primary btn-lg btn-block" href="{!! URL::to('profile/membership-details') !!}">
                                    <i class="fa fa-user-circle"></i>
                                    &nbsp; Renew Membership
                                </a>
                            @endif --}}

                            <?php
                                $regMember = CustomPages::getcontent('uploadMembershipRegForm');
                                if($regMember == ""){
                                    $regMember = URL::to('frontend/pdf/Advertising-Club-Madras-Membership-form.pdf');
                                }

                                $regRenewal = CustomPages::getcontent('uploadMembershipRenewalForm');
                                if($regRenewal == ""){
                                    $regRenewal = URL::to('frontend/pdf/Advertising-Club-Madras-Membership-form.pdf');
                                }
                            ?>

                            <div class="spacer-40"></div>
                            <h4 class="widgettitle">Offline Application</h4>

                            <p class="margin-0">Application for Membership</p>
                            <div class="featured-block-more">
                                <a href="{!! $regMember !!}" class="basic-link" target="_blank"><i class="fa fa-download"></i>&nbsp; Download</a>
                            </div>

                            <hr class="fw">

                            <p class="margin-0">Application for Membership Renewal</p>
                            <div class="featured-block-more">
                                <a href="{!! $regRenewal !!}" class="basic-link" target="_blank"><i class="fa fa-download"></i>&nbsp; Download</a>
                            </div>
                        </div>

                        <div class="col-xs-12 col-sm-8 col-md-6 col-md-offset-1">
                            {!! CustomPages::getcontent("membershipPageWidgetOneDescription") !!}
                            {!! CustomPages::getcontent("membershipWidgetTwoDescription") !!}
                        </div>

                        
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop