<?php
    use App\Models\NewsCategories;
    use App\Models\News;
    use App\Models\Upload;
?>
@extends('frontend/master')

@section('styles')
    <style type="text/css">
        .grid-item-inner {
            min-height: 45px;
        }
        .event-grid-time {
            background-color: rgba(5, 60, 90,0.8);
            padding: 5px 10px;
            top: -35px;
        }
        .grid-item h4 {
            text-overflow: ellipsis;
            white-space: nowrap;
            overflow: hidden;
        }
        .grid-item-inner p {
            font-size: 14px;
            margin-bottom: 0
        }
    </style>
@stop

@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>News</h1>
                <ol class="breadcrumb">
                    <li><a href="{!! URL::to('') !!}">Home</a></li>
                    <li>News</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-3 sidebar left-sidebar positioned hidden-xs">
                        <div class="widget sidebar-widget custom_menu">
                            <ul class="pages-sub-menu">
                                <li><a href="{!! URL::to('news/') !!}">All News</a></li>
                                <li @if($slug == 'upcoming') {!! "class='active'" !!} @endif><a href="{!! URL::to('news/upcoming') !!}">Upcoming</a></li>
                                <?php
                                    $categories = NewsCategories::where("status", "active")->get();
                                ?>
                                @foreach($categories as $category)
                                    <?php $link = $category->categorySlug ?>
                                    <li  @if($slug != 'upcoming' && $cat->id == $category->id) {!! "class='active'" !!} @endif><a href="{!! URL::to('news/'.$link) !!}">{!! ucwords($category->categoryName) !!}</a></li>
                                @endforeach
                            </ul>
                        </div>
                    </div>

                    <div class="col-md-9 col-xs-12">
                        <h5 class="subhead">{!! count($news) !!} News</h5>
                        @if($slug == 'upcoming')
                            <h3 class="accent-color">Upcoming</h3>
                        @else
                            <h3 class="accent-color">{!! $cat->categoryName !!}</h3>
                            {!! $cat->categoryDescription !!}
                        @endif
                        
                        <ul class="events-list events-list-compact">
                            @foreach($news as $newss)
                                    <?php
                                        $link = $newss->news_link;
                                    ?>
                                <li>
                                    <div class="event-date">
                                        <div class="event-month">{!! date("M'y", strtotime($newss->newsDate)) !!}</div>
                                        <div class="event-day">{!! date("d", strtotime($newss->newsDate)) !!}</div>
                                    </div>
                                    <a href="{!! URL::to($link) !!}" target="_blank" class="btn btn-default btn-sm">News Details</a>
                                    <a href="{!! URL::to($link) !!}" target="_blank"><strong>{!! ucwords($newss->newsTitle) !!}</strong></a>
                                    <span class="meta-data">{!! date("l", strtotime($newss->newsDate)) !!}</span>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop