<?php
    use App\Models\PastPresidents;
?>
@extends('frontend/master')
@section('content')
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Past Presidents</h1>
                <ol class="breadcrumb">
                    <li><a href="{!!URL::to('')!!}">Home</a></li>
                    <li><a href="{!!URL::to('about')!!}">About Us</a></li>
                    <li>Past Presidents</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40 past-presidents">
            <div class="container">
                <div class="col-md-2 col-sm-12 parallax">
                    @include('frontend/about-sidebar')
                </div>

                <?php
                    $presidents = PastPresidents::where("status", "active")->orderBy('id','DESC')->get();
                ?>

                <div class="col-md-10">
                    <ul class="list-style">
                        @foreach($presidents as $president)
                            <li class="grid-item col-md-3 col-sm-4 text-center">
                                <div class="team-grid-item format-standard">
                                    <img src="{!! $president->presidentsImage !!}" alt="{!! ucwords($president->presidentName) !!}" class="img_icon">
                                    <div class="grid-item-inner">
                                        <h4>{!! ucwords($president->presidentName) !!}</h4>
                                        <span class="meta-data">{!! $president->yearRange !!}</span>
                                        <p class="margin-0">{!! $president->companyName !!}</p>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
@stop