@extends('frontend/master')
@section('styles')
    <style type="text/css">
        .req{
            color: #f00 !important;
        }
    </style>
@stop

@section('content')
    <div class="hero-area" ng-app="AdclubMadras" ng-controller="userProfileController">
        <div class="hero-area">
            <div class="page-header bg-color1 text-center">
                <div class="container">
                    <h1>Profile</h1>
                    <ol class="breadcrumb">
                        <li><a href="{!! URL::to('') !!}">Home</a></li>
                        <li>Profile</li>
                    </ol>
                </div>
            </div>
        </div>

        <div id="main-container">
            <div class="content padding-b40">
                <div class="container">
                    <div class="row">
                        <div class="col-md-2 col-sm-12 parallax">
                            @include('frontend/profile-sidebar')
                        </div>

                        <div class="col-md-10">
                            @if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

                            @if(Session::has('error')) {!! HTML::display_error('error') !!} @endif
                            <div class="row">
                                <div class="col-md-6">
                                    <h4 class="widgettitle"><i class="fa fa-user"></i>&nbsp; Profile Information</h4>
                                    {!! Form::open(["url"=>"profile/post"]) !!}
                                        <div class="form-group">
                                            <label>Full Name <span class="req">*</span></label>
                                            <input type="text" class="form-control input-lg" name="fullName" value="{!! Auth::User()->firstName !!}">
                                            @if($errors->has("fullName"))
                                                <div class="req">{!! $errors->first("fullName") !!}</div>
                                            @endif
                                        </div>

                                        <div class="form-group">
                                            <label>Registered Email Address</label>
                                            <input type="email" name="emailID" class="form-control input-lg" value="{!! Auth::User()->email !!}" disabled="disabled">
                                            @if($errors->has("emailID"))
                                                <div class="req">{!! $errors->first("emailID") !!}</div>
                                            @endif
                                        </div>

                                        <div class="form-group">
                                            <label>Contact Number</label>
                                            <input type="text" name="contactNO" class="form-control input-lg" value="{!! Auth::User()->phone !!}">
                                            @if($errors->has("contactNO"))
                                                <div class="req">{!! $errors->first("contactNO") !!}</div>
                                            @endif
                                        </div>

                                        <div class="spacer-10"></div>

                                        <div class="clearfix">
                                            <button type="submit" id="submit" class="btn btn-primary btn-lg">Save</button>
                                        </div>
                                    {!! Form::close() !!}
                                </div>

                                <div class="col-md-6">
                                    <a href="javascript:;"><h4 class="widgettitle"><i class="fa fa-key"></i>&nbsp; Change Account Password</h4></a>
                                    {!! Form::open(["url"=>"profile/change/password/post"]) !!}
                                        <div class="form-group">
                                            <label>Old Password <span class="req">*</span></label>
                                            <input type="password" id="oldPassword" name="oldPassword" class="form-control input-lg">
                                            @if($errors->has("oldPassword"))
                                                <div class="req">{!! $errors->first("oldPassword") !!}</div>
                                            @endif
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>New Password <span class="req">*</span></label>
                                            <input type="password" id="newPassword" name="newPassword" class="form-control input-lg">
                                            @if($errors->has("newPassword"))
                                                <div class="req">{!! $errors->first("newPassword") !!}</div>
                                            @endif
                                        </div>

                                        <div class="form-group">
                                            <label>Confirm New Password <span class="req">*</span></label>
                                            <input type="password" id="confirmPassword" name="confirmPassword" class="form-control input-lg">
                                            @if($errors->has("confirmPassword"))
                                                <div class="req">{!! $errors->first("confirmPassword") !!}</div>
                                            @endif
                                        </div>

                                        <div class="spacer-10"></div>

                                        <div class="clearfix">
                                            <button type="submit" id="submit" name="submit" class="btn btn-primary btn-lg">Submit</button>
                                        </div>
                                    {!! Form::close() !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop