<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

////////////////////////////////***Frontend Route Starts***\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
Route::get('getDate', function (){
	$date = "14\/08\/2018 23:22:53";
	$date = str_replace('\/', '-',  $date);
	$date = str_replace('/', '-', $date);
	$strtotime = strtotime($date);
	return date('Y-m-d H:i:s', $strtotime);
});

Route::get('/testing', function(){
	return  route('payment.success');
});

Route::get('/testingg', 'FrontendController@testingg');

Route::get("/", "FrontendController@indexpageget");
Route::get("about", "FrontendController@aboutpageget");
Route::get("about/past-presidents", "FrontendController@pastpresidentspageget");
Route::get("about/executive-comittee", "FrontendController@executivecomitteepageget");
Route::get("about/our-facilities", "FrontendController@ourfacilitiespageget");
Route::get("course-offered", "FrontendController@courseofferedpageget");
Route::get("course-offered/eligibility", "FrontendController@eligibilitypageget");
Route::get("course-offered/faculty", "FrontendController@facultypageget");

Route::get("contact", "FrontendController@contactpageget");
Route::post('contact/post', 'FrontendController@contactpost');
Route::get("job-opportunities", "FrontendController@jobopportunitiespageget");
Route::post("job-opportunities/save", "FrontendController@jobopportunitiessave");
Route::get("privacy-policy", "FrontendController@privacypolicypageget");
Route::get("terms-conditions", "FrontendController@termsconditionspageget");
Route::get("refund-and-cancellation", "FrontendController@returnpolicypageget");

//Gallery
Route::get("gallery", "FrontendController@gallerypageget");
Route::get("gallery/{categorySlug}/", "FrontendController@gallerycategorypageget");
Route::get("gallery/{categorySlug}/{gallerySlug}", "FrontendController@gallerydetailspage");

//Events
Route::get("events", "FrontendController@eventspageget");
Route::get("events/{categorySlug}", "FrontendController@eventscategorypageget");
Route::get("events/{categorySlug}/{eventSlug}", "FrontendController@eventdetailspageget");

//News
Route::get("news", "FrontendController@newspageget");
Route::get("news/{categorySlug}", "FrontendController@newscategorypageget");

//Sign Up
Route::post("check/auth/signup/isuniquevalue", "FrontendController@isUniqueValue");
Route::post('sign-up/post', 'FrontendController@postsignupform');

//Login
Route::get("login", "FrontendController@loginsignuppageget");
Route::post("login", "FrontendController@loginpagepost");

//Forgot Password
Route::post('forgot/password/post', 'FrontendController@postforgotpasswordform');
Route::get("forgot/password/reset/{code}/{time}", "FrontendController@getforgetpasswordpage");
Route::post("forgot/password/reset/{code}/{time}", "FrontendController@postforgetpasswordpage");

//Individual Membership
Route::get("membership/individual-members", "FrontendController@individualmemberspageget");
Route::post("membership/individual-members", "FrontendController@individualmemberspagepost");

//Corporate Members
Route::get("membership/corporate-members", "FrontendController@corporatememberspageget");
Route::post("membership/corporate-members", "FrontendController@corporatememberspagepost");

//Course Application
Route::get("course-offered/course-application", "FrontendController@courseapplicationpageget");

Route::get("membership", "FrontendController@membershippageget");

//Membership Application
Route::get("membership/membership-application", "FrontendController@membershipapplicationpageget");
// Route::post('payment/gateway/success', 'FrontendController@postpaymentsuccesspage')->name('payment.success');
// Route::post('payment/gateway/failure', 'FrontendController@postpaymentfailurepage')->name('payment.failure');


Route::group(['middleware' => 'auth.customers'], function (){
	//Event Registration
	Route::post('eventregistration', 'FrontendController@eventregistrationpost')->name('event.registration');
	Route::get('eventregistration/confirmationpage/{key}', 'FrontendController@eventregistrationconfirmationpage');

	//Course Application
	Route::post("course-offered/course-application", "FrontendController@courseapplicationpagepost")->name('course.application.post');
	Route::get("course-offered/course-application/course-application-payment-offline/{id}", "FrontendController@courseapplicationofflinepaymentconfirmationpage");
	Route::get("course-offered/course-application/course-application-payment-online/{id}", "FrontendController@courseapplicationonlinepaymentconfirmationpage");

	//Membership Application
	Route::post("membership/membership-application", "FrontendController@postmembershipapplicationpage");
	Route::post("membership/membership-application/membership-application-payment/{id}", "FrontendController@membersapplicationpaymentpost");
	Route::get("membership/membership-application/membership-application-payment-confirmation/{key}", "FrontendController@getmembersapplicationpaymentconfirmationpage");
	Route::get("membership/membership-application/membership-application-renewal-payment-confirmation/{key}", "FrontendController@getmembersrenewalapplicationpaymentconfirmationpage");
	
	//Payment
	Route::post('payment/gateway/success', 'FrontendController@postpaymentsuccesspage')->name('payment.success');
	Route::post('payment/gateway/failure', 'FrontendController@postpaymentfailurepage')->name('payment.failure');
	Route::get('payment/gateway/failure/{key}', 'FrontendController@getpaymentfailurepage')->name('payment.failure.page');
	

	//Profile Page
	Route::get("profile", "FrontendController@profilepageget");
	Route::post("profile/post", "FrontendController@profilepagepost");
	Route::post("profile/change/password/post", "FrontendController@postchangepassword");
	Route::get("profile/membership-details", "FrontendController@getprofilemembershippage");
	Route::post("profile/membership-details/check/renewal", "FrontendController@postcheckrenewalstatus");
	Route::get("profile/membership/renewal/form/{key}", "FrontendController@getmembershiprenewalpage");
	Route::post("profile/membership/renewal/form", "FrontendController@postmembershiprenewalpage")->name('membership.renewal.post');
	Route::post("profile/membership/renewal/payment/{id}", "FrontendController@membersapplicationrenewalpaymentpost");
	Route::get("profile/logout", "FrontendController@getlogoutpage");
});

//Testing Email Templates
Route::get("email/templates", "FrontendController@demoemails");
////////////////////////////////***Frontend Route Ends***\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

///////////////////////***************** Admin Route Starts Right Here******************\\\\\\\\\\\\\\\\\\\\\

// Middleware to restrict auth user url restrictions
Route::group(['middleware' => 'auth.admin'], function (){

	//Dashboard
	Route::get('admin', 'AdminController@index');

	//User Module
    Route::get("admin/users","AdminController@usersget");
	Route::get("admin/users/add","AdminController@addusersget");
	Route::post("admin/users/add","AdminController@adduserspost");
	Route::get("admin/users/modify/{id}","AdminController@modifyusersget");
	Route::post("admin/users/modify/{id}","AdminController@modifyuserspost");
	Route::post("admin/users/status","AdminController@statususerspost");
	Route::post("admin/users/delete","AdminController@deleteuserspost");
	

	Route::get("admin/users/change/password","AdminController@getchangepassword");
	Route::post("admin/users/change/password","AdminController@postchangepassword");
	Route::post("admin/users/regenerate/password","AdminController@regeneratepassword");

	Route::get('admin/users/role','AdminController@userrole');
	Route::get('admin/users/role/add','AdminController@adduserroleget');
	Route::post('admin/users/role/add','AdminController@adduserrolepost');
	Route::post('admin/users/role/status','AdminController@userrolestatus');
	Route::post('admin/users/role/delete','AdminController@userroledelete');
	Route::get('admin/users/role/modify/{id}','AdminController@userrolemodifyget');
	Route::post('admin/users/role/modify/','AdminController@userrolemodifypost');

	//Customer Module
	Route::get('admin/customers','AdminController@customerget');
	Route::post('admin/customers/status','AdminController@customerstatuspost');
	Route::post('admin/customer/delete','AdminController@deletecustomer');
	Route::get("admin/customer/modify/{id}","AdminController@modifycustomerget");
	Route::post("admin/customer/modify/{id}","AdminController@modifycustomerpost");
    Route::post("admin/customers/manage/search", "AdminController@postsearchcustomers");
	Route::get("admin/customers/manage/search", "AdminController@getsearchcustomers");

	//Marketing
	Route::get("admin/marketing/subscriptions/list/add","AdminController@addsubscriptionslistget");
	Route::post("admin/marketing/subscriptions/list/add","AdminController@addsubscriptionslistpost");
	Route::get("admin/marketing/subscriptions/subscribers/add","AdminController@addsubscribergetpage");
	Route::post("admin/marketing/subscriptions/subscribers/add","AdminController@addsubscriberpost");
	Route::get("admin/marketing/subscriptions","AdminController@subscriptionsget");
	Route::get("admin/marketing/subscriptions/subscribers/{listId}","AdminController@subscribersget");
	Route::post("admin/marketing/subscriptions/list/status","AdminController@subscriptionsstatuspost");
	Route::get("admin/marketing/subscriptions/subscribers/modify/{id}","AdminController@modifysubscriberget");
	Route::post("admin/marketing/subscriptions/subscribers/modify/{id}","AdminController@modifysubscriberpost");

	//Settings Module
	Route::get("admin/settings/general","AdminController@generalsettingsget");
	Route::post("admin/settings/general","AdminController@settingspost");
	Route::get("admin/settings/mail","AdminController@mailsettingsget");
	Route::get("admin/settings/system","AdminController@getsystemsettings");
	Route::post("admin/settings/system","AdminController@postsystemsettings");
	Route::get("admin/tools/designs/","AdminController@designsget");
	Route::post("admin/tools/designs/","AdminController@designspost");
	Route::get("admin/settings/store","AdminController@storesettingsget");
	Route::post("admin/settings/mail/testing","AdminController@testmailpost");

	//Locations Module
	Route::get("admin/masters/locations/country","AdminController@getcountrylist");
	Route::get("admin/masters/locations/country/add","AdminController@getaddcountry");
	Route::post("admin/masters/locations/country/add","AdminController@postaddcountry");
	Route::get("admin/masters/locations/country/modify/{id}","AdminController@getmodifycountry");
	Route::post("admin/masters/locations/country/modify/{id}","AdminController@postmodifycountry");
	Route::get("admin/masters/locations/state","AdminController@getstatelist");
	Route::post("admin/masters/locations/state/post","AdminController@poststatelist");
	Route::get("admin/masters/locations/state/add","AdminController@getaddstatelist");
	Route::post("admin/masters/locations/state/add","AdminController@postaddstatelist");
	Route::get("admin/masters/locations/state/modify/{id}","AdminController@getmodifystatelist");
	Route::post("admin/masters/locations/state/modify/{id}","AdminController@postmodifystatelist");
	Route::post("admin/masters/locations/country/status","AdminController@postcountrystatus");
	Route::post("admin/masters/locations/country/delete","AdminController@postcountrydelete");
	Route::post("admin/masters/locations/state/status","AdminController@poststatestatus");
	Route::post("admin/masters/locations/state/delete","AdminController@poststatedelete");
	Route::get("admin/masters/locations/city","AdminController@getcitylist");
	Route::post("admin/masters/locations/city/post","AdminController@postcitylist");
	Route::post("admin/masters/locations/city/option/post","AdminController@postcityoptionlist");
	Route::post("admin/masters/locations/city/status","AdminController@postcitystatus");
	Route::post("admin/masters/locations/city/delete","AdminController@postcitydelete");
	Route::get("admin/masters/locations/city/add","AdminController@getaddcity");
	Route::post("admin/masters/locations/city/add","AdminController@postaddcity");
	Route::post("admin/masters/locations/city/modify/toggles","AdminController@citynametogglepost");

	//theme option start
	Route::post('imageupload', 'AdminController@imageupload');
	Route::post('imageuploadwiththumbnail', 'AdminController@imageuploadwiththumbnail'); 
	Route::get('storeimages', 'AdminController@storeimages');
	Route::get('storefootericonimages', 'AdminController@storefootericonimages');
	Route::get('headertooption', 'AdminController@headertooption');
	Route::get('footertooption', 'AdminController@footertooption');
	Route::post('socialtooption', 'AdminController@socialtooption');  

	// Store settings start
	Route::get("storegeneraltooption","AdminController@storegeneraltooption");
	Route::get("statefromcountry","AdminController@statefromcountry"); 
	Route::get("cityfromstate","AdminController@cityfromstate");
	
	Route::get("admin/settings/email/templates","AdminController@getemailtemplates"); 
	Route::post("admin/settings/email/templates/upload","AdminController@posttemplateupload");
	Route::post("admin/settings/email/templates/save","AdminController@saveimages"); 
	Route::post("admin/settings/email/templates/fetch","AdminController@gettemplates"); 
	Route::post("admin/settings/email/templates/post","AdminController@postemailsettings");
	Route::post("admin/settings/email/templates/footer","AdminController@postfooter");     

	//Store Front
	Route::get('admin/storefrontend/reorder/categories','AdminController@categoryreorderpage');
	Route::post('admin/storefrontend/reorder/categories', 'AdminController@categoryreorderpost');

	Route::get("admin/storefront/footer/section/one", "AdminController@getfootersectionone");
	Route::post("admin/storefront/footer/section/one/post", "AdminController@postfootersectionone");

	Route::get('admin/storefrontend/menu/manager','FrontendController@menumanagerpage');
	Route::post('admin/storefrontend/menu/manager', 'FrontendController@menumanagerpost');

	Route::get('admin/storefrontend/menu/footerone','FrontendController@footeronepage');
	Route::post('savefooterone','FrontendController@savefooterone');
	Route::get('admin/storefrontend/menu/footertwo','FrontendController@footertwopage');
	Route::post('savefootertwo','FrontendController@savefootertwo');
	Route::get('admin/storefrontend/menu/footerthree','FrontendController@footerthreepage');
	Route::post('savefooterthree','FrontendController@savefooterthree');


	Route::get('admin/settings/menu/add','AdminController@addadminmenuget');
	Route::post('admin/settings/menu/add','AdminController@addadminmenupost');
	Route::post('admin/settings/menu/get','AdminController@getadminmenupost');
	Route::post('admin/settings/menu/status','AdminController@statusadminmenupost');
	Route::post('admin/settings/menu/edit','AdminController@editadminmenupost');
	Route::post('admin/settings/adminmenu/delete','AdminController@adminmenudelete');
	Route::get('admin/settings/adminmenu/manage','AdminController@adminmenumanagerget');
	Route::post('admin/settings/adminmenu/manage', 'AdminController@adminmenumanagerpost');

	//Downloads
	Route::get("admin/downloads/add", "AdminController@getadddownload");
	Route::post("admin/downloads/add", "AdminController@postadddownload");
	Route::get("admin/downloads/modify/{id}", "AdminController@getmodifydownload");
	Route::post("admin/downloads/modify/{id}", "AdminController@postmodifydownload");
	Route::get("admin/downloads", "AdminController@getdownloads");
	Route::post("admin/downloads/delete", "AdminController@postdownloadsdelete");

	//CMS Pages
	Route::get('admin/storefront/cms/about','AdminController@aboutget');
	Route::post('admin/storefront/cms/about','AdminController@aboutpost');
	Route::get('admin/storefront/cms/privacy','AdminController@privacyget');
	Route::post('admin/storefront/cms/privacy','AdminController@privacypost');
	Route::get('admin/storefront/cms/terms','AdminController@termsget');
	Route::post('admin/storefront/cms/terms','AdminController@termspost');
	Route::get('admin/storefront/cms/faq','AdminController@faqget');
	Route::get('admin/storefront/cms/faq/add','AdminController@addfaqget');
	Route::post('admin/storefront/cms/faq/add','AdminController@addfaqpost');
	Route::get('admin/storefront/cms/faq/modify/{id}','AdminController@modifyfaqget');
	Route::post('admin/storefront/cms/faq/modify','AdminController@modifyfaqpost');
	Route::post('admin/storefront/cms/faq/status','AdminController@faqstatus');
	Route::post('admin/storefront/cms/faq/delete','AdminController@faqdelete');

	//Admin
	Route::get('admin', 'AdminController@index');
	Route::get('admin/add', 'AdminController@admin');

	//Mostly common things
	Route::post("admin/country/state/lists","AdminController@statelists");
	Route::post('dropzone/uploadFiles', 'AdminController@uploadFiles');

	//Store front module
	Route::get("admin/storefront/header","AdminController@headerget");
	Route::get("admin/storefront/footer","AdminController@footerget");
	Route::get("admin/storefront/social","AdminController@socialget");
	Route::get("admin/storefront/home/page", "AdminController@gethomecustompage");
	Route::post("admin/storefront/home/page/category/events", "AdminController@postfetchevents");
	Route::post("admin/storefront/home/page", "AdminController@posthomecustompage");
	Route::post("admin/storefront/home/page/content/header/portion", "AdminController@posthomepagecontentheaderportion");
	Route::post("admin/storefront/home/page/content/middle/portion", "AdminController@posthomepagecontentmiddleportion");
	Route::post("admin/storefront/home/page/content/band/portion", "AdminController@posthomepagecontentbandportion");
	Route::post("admin/storefront/home/page/gallery/post", "AdminController@uploadgalleryhomepage");

	// Admin Login
	Route::get("admin/logout","AdminController@logoutpost");

	//News
	Route::get("admin/news/get", "AdminController@getnewspage");
	Route::post("admin/news/status/post", "AdminController@postnewsstatus");
	Route::post("admin/news/delete/post", "AdminController@postnewsdelete");
	Route::get("admin/news/add/get", "AdminController@getaddpostpage");
	Route::post("admin/news/add/post", "AdminController@postaddnewspost");
	Route::get("admin/news/modify/get/{id}", "AdminController@geteditnewspostpage");
	Route::post("admin/news/modify/post/{id}", "AdminController@posteditnewspostpage");

	Route::get("admin/news/category/add/get", "AdminController@getaddnewscategory");
	Route::post("admin/news/category/add/post", "AdminController@postaddnewscategory");
	Route::get("admin/news/categories/get", "AdminController@getnewscategory");
	Route::post("admin/news/category/status/post", "AdminController@postnewscategorystatus");
	Route::post("admin/news/category/delete/post", "AdminController@postnewscategorydelete");
	Route::post("admin/news/category/modify/post", "AdminController@postnewscategorymodify");

	//Pages
	Route::get("admin/pages/all/get", "AdminController@getallpages");
	Route::get("admin/pages/contactus/get", "AdminController@getcontactuspage");
	Route::get("admin/pages/privacypolicy/get", "AdminController@getprivacypolicypage");
	Route::get("admin/pages/termsandconditions/get", "AdminController@gettermsandconditionspage");
	Route::get("admin/pages/returnpolicy/get", "AdminController@getreturnpolicypage");
	Route::get("admin/pages/shippingpolicy/get", "AdminController@getshippingpolicypage");
	Route::get("admin/pages/disclaimer/get", "AdminController@getdisclaimerpage");
	Route::get("admin/pages/ask/nutritionist/get", "AdminController@getasknutritionistpage");
	Route::get("admin/pages/our/facilities/get", "AdminController@getourfacilitiespage");
	

	Route::post("admin/pages/aboutus/post", "AdminController@postaboutuspage");

	//FAQs
	Route::get("admin/pages/faq/add/get", "AdminController@getaddfaq");
	Route::post("admin/pages/faq/add/post", "AdminController@postaddfaq");
	Route::get("admin/pages/faq/modify/get/{id}", "AdminController@getmodifyfaq");
	Route::post("admin/pages/faq/modify/post/{id}", "AdminController@postmodifyfaq");
	Route::get("admin/pages/faq/get", "AdminController@getfaq");
	Route::post("admin/pages/faq/status/post", "AdminController@postfaqstatus");
	Route::post("admin/pages/faq/delete/post", "AdminController@postfaqdelete");

	//Testimonials
	Route::get("admin/testimonials/add/get", "AdminController@getaddtestimonials");
	Route::post("admin/testimonials/add/post", "AdminController@postaddtestimonials");
	Route::get("admin/testimonials/modify/get/{id}", "AdminController@getmodifytestimonials");
	Route::post("admin/testimonials/modify/post/{id}", "AdminController@postmodifytestimonials");
	Route::get("admin/testimonials/get", "AdminController@gettestimonials");
	Route::post("admin/testimonials/status/post", "AdminController@posttestimonialsstatus");
	Route::post("admin/testimonials/delete/post", "AdminController@posttestimonialsdelete");
	
	//Pop Up Banner Settings
	Route::get("admin/settings/popup/banner/get", "AdminController@getpopupbannersettings");
	Route::post("admin/settings/popup/banner/post", "AdminController@postpopupbannersettings");
	Route::post("admin/settings/diet/popup/banner/post", "AdminController@postpopupdietbannersettings");
	Route::post("admin/settings/popup/product/banner/post", "AdminController@postpopupproductbannersettings");

	//System Logs
	Route::get("admin/logs/system", "AdminController@getsystemlogs");
	Route::post("admin/logs/system", "AdminController@postsystemlogs");

	//Past Presidents
	Route::get("admin/about/past/presidents/add/get", "AdminController@getaddpastpresidentspage");
	Route::post("admin/about/past/presidents/add/post", "AdminController@addpastpresidentspost");
	Route::get("admin/about/past/presidents/modify/get/{id}", "AdminController@getmodifypastpresidentspage");
	Route::post("admin/about/past/presidents/modify/post/{id}", "AdminController@postmodifypastpresidentspage");
	Route::get("admin/about/past/presidents/get", "AdminController@getpastpresidentspage");
	Route::post("admin/about/past/presidents/status/post", "AdminController@postpastpresidentsstatus");
	Route::post("admin/about/past/presidents/delete/post", "AdminController@postpastpresidentsdelete");

	//About Page
	Route::get("admin/about/us/page/get", "AdminController@getaboutuspage");

	//Executive Committee Members
	Route::get("admin/about/executive/committee/members/add/get", "AdminController@getaddexecutivecommitteemembers");
	Route::post("admin/about/executive/committee/members/add/post", "AdminController@postaddexecutivecommitteemembers");
	Route::get("admin/about/executive/committee/members/modify/get/{id}", "AdminController@getmodifyexecutivecommitteemembers");
	Route::post("admin/about/executive/committee/members/modify/post/{id}", "AdminController@postmodifyexecutivecommitteemembers");
	Route::get("admin/about/executive/committee/members/get", "AdminController@getexecutivecommitteememberspage");
	Route::post("admin/about/executive/committee/members/status/post", "AdminController@postexecutivecommitteemembersstatus");
	Route::post("admin/about/executive/committee/members/delete/post", "AdminController@postexecutivecommitteemembersdelete");

	//Faculty
	Route::get("admin/courses/faculty/add/get", "AdminController@getaddfacultiespage");
	Route::post("admin/courses/faculty/add/post", "AdminController@addfacultiespost");
	Route::get("admin/courses/faculty/modify/get/{id}", "AdminController@getmodifyfacultiespage");
	Route::post("admin/courses/faculty/modify/post/{id}", "AdminController@postmodifyfacultiespage");
	Route::get("admin/courses/faculty/get", "AdminController@getfacultiespage");
	Route::post("admin/courses/faculty/status/post", "AdminController@postfacultiesstatus");
	Route::post("admin/courses/faculty/delete/post", "AdminController@postfacultiesdelete");

	//Courses Applied
	Route::get("admin/courses/applied/get", "AdminController@getcoursesappliedpage");
	Route::post("admin/courses/applied/post", "AdminController@postcoursesappliedpage");
	Route::get("admin/courses/applied/modify/get/{id}", "AdminController@getmodifyappliedcourse");
	Route::post("admin/courses/applied/modify/post/{id}", "AdminController@postmodifyappliedcourse");

	Route::get("admin/courses/offered/get", "AdminController@getcourseofferedpage");
	Route::get("admin/courses/eligibility/get", "AdminController@getcourseeligibilitypage");

	//Individual Members
	Route::get("admin/members/individual/get", "AdminController@getindividualmemberspage");
	Route::post("admin/members/individual/post", "AdminController@postindividualmemberspage");
	Route::post("admin/members/individual/status","AdminController@statusindividualpost");

	//Membership Main Page
	Route::get("admin/members/first/page/get", "AdminController@getmembershipfirstpage");
	Route::post("admin/members/first/page/post", "AdminController@postmembershipfirstpage");

	//Corporate Members
	Route::get("admin/members/corporate/get", "AdminController@getcorporatememberspage");
	Route::post("admin/members/corporate/post", "AdminController@postcorporatememberspage");
	Route::post("admin/members/corporate/status","AdminController@statusindividualpost");

	//Import Members
	Route::post('admin/memebers/import', 'AdminController@membersimport');

	//Members Applied
	Route::get("admin/members/applied/get", "AdminController@getmembersappliedpage");
	Route::post("admin/members/applied/post", "AdminController@postmembersappliedpage");
	Route::post("admin/members/applied/status/post", "AdminController@postmembersappliedstatus");
	Route::post("admin/members/applied/delete/post", "AdminController@postmembersapplieddelete");
	Route::get("admin/members/applied/modify/get/{key}", "AdminController@getmembersappliedmodifypage");
	Route::post("admin/members/applied/modify/post/{key}", "AdminController@postmembersappliedmodifypage");
	Route::get("admin/members/corporate/add/get", "AdminController@getcorporatemembersaddpage");
	Route::get("admin/members/individual/add/get", "AdminController@getindividualmembersaddpage");
	Route::post("admin/members/corporate/add/post", "AdminController@postcorporatemembersaddpage");
	Route::get("admin/members/corporate/modify/get/{key}", "AdminController@getcorporatemembersmodifypage");
	Route::get("admin/members/individual/modify/get/{key}", "AdminController@getindividualmembersmodifypage");
	Route::post("admin/members/individual/modify/post/{key}", "AdminController@postindividualmembersmodifypage");

	//Gallery
	Route::get("admin/gallery/category/add/get", "AdminController@getaddgallerycategory");
	Route::post("admin/gallery/category/add/post", "AdminController@addgallerycategorypost");

	//Event Categories
	Route::get("admin/events/categories/add/get", "AdminController@getaddeventcategorypage");
	Route::post("admin/events/categories/add/post", "AdminController@postaddeventcategorypage");
	Route::get("admin/events/categories/modify/get/{slug}/{key}", "AdminController@geteventcategorymodifypage");
	Route::post("admin/events/categories/modify/post/{slug}/{key}", "AdminController@posteventcategorymodify");
	Route::get("admin/events/categories/get", "AdminController@geteventcategorypage");
	Route::post("admin/events/categories/status/post", "AdminController@posteventcategorystatus");
	Route::post("admin/events/categories/delete/post", "AdminController@posteventcategorydelete");

	//Events
	Route::get("admin/events/add/get", "AdminController@getaddeventpage");
	Route::post("admin/events/add/post", "AdminController@postaddeventpage");
	Route::get("admin/events/get", "AdminController@geteventspage");
	Route::post("admin/events/status/post", "AdminController@posteventsstatus");
	Route::post("admin/events/delete/post", "AdminController@posteventsdelete");
	Route::get("admin/events/modify/get/{slug}/{key}", "AdminController@geteventmodifypage");
	Route::post("admin/events/modify/post/{slug}/{key}", "AdminController@posteventmodify");
	Route::post("admin/events/modify/customfields/add", "AdminController@posteventmodifycustomfields");
	Route::post("admin/events/modify/customfields/gettemplate", "AdminController@eventcustomfieldstemplate");
	Route::post("admin/events/modify/customfields/updatedata", "AdminController@posteventupdatecustomfieldsdata");
	Route::post("admin/events/modify/customfields/file/remove", "AdminController@posteventremovecustomfieldfile");
	Route::post("admin/events/modify/customfields/remove", "AdminController@posteventremovecustomfield");
	Route::post("admin/events/modify/customfields/sorting", "AdminController@posteventsortingcustomfield");

	Route::post("admin/events/modify/customfields/reg/add", "AdminController@posteventmodifycustomfieldsreg");
	Route::post("admin/events/modify/customfields/reg/gettemplate", "AdminController@eventcustomfieldstemplatereg");
	Route::post("admin/events/modify/customfields/sorting/reg", "AdminController@posteventsortingcustomfieldreg");
	Route::post("admin/events/modify/customfields/remove/reg", "AdminController@posteventremovecustomfieldreg");

	//Events Registration
	Route::get("admin/eventsregistration/get", "AdminController@geteventsregistration");
	Route::post("admin/eventsregistration/post", "AdminController@posteventregistration");
	Route::post("admin/eventsregistration/player/details", "AdminController@eventregistrationplayerdetail");

	//Job Opportunities
	Route::get("admin/job-opportunities/get", "AdminController@getjobopportunities");
	Route::post("admin/job-opportunities/post", "AdminController@postjobopportunities");

	//Gallery Categories
	Route::get("admin/gallery/categories/add/get", "AdminController@getaddgallerycategorypage");
	Route::post("admin/gallery/categories/add/post", "AdminController@postaddgallerycategorypage");
	Route::post("admin/gallery/categories/modify/post", "AdminController@postgallerycategorymodify");
	Route::get("admin/gallery/categories/get", "AdminController@getgallerycategorypage");
	Route::post("admin/gallery/categories/status/post", "AdminController@postgallerycategorystatus");
	Route::post("admin/gallery/categories/delete/post", "AdminController@postgallerycategorydelete");

	//Add Gallery
	Route::get("admin/gallery/add/get", "AdminController@getaddgallerypage");
	Route::post("admin/gallery/add/post", "AdminController@postaddgallerypage");
	Route::get("admin/gallery/get", "AdminController@getgallerypage");
	Route::post("admin/gallery/status/post", "AdminController@postgallerystatus");
	Route::post("admin/gallery/delete/post", "AdminController@postgallerydelete");
	Route::get("admin/gallery/modify/{slug}/{key}", "AdminController@getmodifygallerypage");
	Route::post("admin/gallery/modify/delete/image", "AdminController@postdeletegalleryimage");
	Route::post("admin/gallery/modify/{slug}/{key}", "AdminController@postmodifygallerypage");

	//Reports
	Route::get("admin/reports/payment/get", "AdminController@getpaymentreportpage");
	Route::post("admin/reports/payment/post", "AdminController@postpaymentreportpage");
	Route::get("admin/reports/payment/excel/get/{from?}/{to?}/{order?}/{status?}", "AdminController@getpaymentreportsexcelpage");

	//Maddys Reports
	Route::get("admin/reports/maddys/get", "AdminController@getmaddysreportpage");
	Route::post("admin/reports/maddys/post", "AdminController@postmaddysreportpage");
	Route::get("admin/reports/maddys/excel/get/{from?}/{to?}", "AdminController@getmaddysreportsexcelpage");

	//Entry Ticket Reports
	Route::get("admin/reports/entryticket/get", "AdminController@getentryticketreportpage");
	Route::post("admin/reports/entryticket/post", "AdminController@postentryticketreportpage");
	Route::get("admin/reports/entryticket/excel/get/{from?}/{to?}", "AdminController@getentryticketreportsexcelpage");

});/* End of auth middleware */ 


//Admin Login
Route::get("admin/acm/console/login", "AdminController@loginget");
Route::post("admin/acm/console/login", "AdminController@loginpost");
Route::get("upload/db/course/applied", "AdminController@getuploadcoursesappliedtable");

/////////////////***********Admin Route Ends Over Here*************\\\\\\\\\\\\\

//Success Message display function
HTML::macro('display_success', function($success){
    $result = '<div class="alert alert-success" role="alert">
	<strong> '.Session::get($success).'
	 </strong></div>';
   return $result;
});

//Success Message display function
HTML::macro('display_error', function($error)
{
    $result = '<div class="alert alert-danger" role="alert">
	<strong> '.Session::get($error).'
	 </strong></div>';
   return $result;
});
