<?php 
	use App\Models\User;
	use App\Models\Adminmenumanage;  
	use App\Models\Usergroupmeta;
?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">User Role</li>
					<li class="active">Modify</li>
				</ol>
			</div>
			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Modify User Role</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							<?php echo HTML::link("admin/users/role","Manage Users Role",["class"=>"btn ink-reaction btn-block btn-primary"]); ?>

						</div>
					</div><!--end .col -->
					<div class="col-md-8">
						<?php echo Form::open(["class"=>"form",'id'=>'modifyuserroleForm']); ?>

							<div class="card">
								<div class="card-head style-primary">
									<header>Modify user role</header>
								</div>
								<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>
								<div class="card-body">
									<div class="row">
											<div class="form-group">
												<?php echo Form::text("roleName",$roleName,["class"=>"form-control",'id'=>'roleName']); ?>

												<?php echo HTML::decode(Form::label("roleName","Role Name<span class='text-danger'>*</span>")); ?>

											</div>
									</div>

									<div class="table-responsive">
						<table class="table table-striped table-hover">
							<thead>
								<tr>
									<th>Name</th>
									<th>View <input type="checkbox" class="selectAll view"></th>
									<th>Create <input type="checkbox" class="selectAll create"></th></th>
									<th>Update <input type="checkbox" class="selectAll update"></th></th>
									<th>Delete <input type="checkbox" class="selectAll delete"></th></th>
									<!-- <th>Edit</th> -->
								</tr>
							</thead>
							<tbody>
							
							<?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $first): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<?php 
								$firstname=Adminmenumanage::getmenuname($first->menuId);
								$details=Usergroupmeta::getusergroupmeta($roleId,$first->menuId);
								?>
								<?php if($details!=''): ?>
									<tr>
								<td><?php echo $firstname; ?><input type="hidden" value="<?php echo $first->menuId; ?>" class="menuId" name="menuIds[]"></td>
								<td><?php echo Form::checkbox('viewClass[]','',($details->viewPermission==1),['class'=>'single viewClass']); ?> </td>
								<td><?php echo Form::checkbox('createClass[]','',($details->createPermission==1),['class'=>'single createClass']); ?></td>
								<td><?php echo Form::checkbox('updateClass[]','',($details->updatePermission==1),['class'=>'single updateClass']); ?></td>
								<td><?php echo Form::checkbox('deleteClass[]','',($details->deletePermission==1),['class'=>'single deleteClass']); ?></td>
							</tr>
							<?php else: ?>
								<tr>
									<td><?php echo $firstname; ?><input type="hidden" value="<?php echo $first->menuId; ?>" class="menuId" name="menuIds[]"></td>
									<td><input type="checkbox" class="single viewClass" name="viewClass[]"></td>
									<td><input type="checkbox" class="single createClass" name="createClass[]"></td>
									<td><input type="checkbox" class="single updateClass" name="updateClass[]"></td>
									<td><input type="checkbox" class="single deleteClass" name="deleteClass[]"></td>
								</tr>
							<?php endif; ?>
							

							<?php if(Adminmenumanage::hasSubmenu($first->menuId)>0): ?>
								<?php $__currentLoopData = Adminmenumanage::getSubmenu($first->menuId); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $second): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<?php 
								$secondname=Adminmenumanage::getmenuname($second->menuId); 
								$details=Usergroupmeta::getusergroupmeta($roleId,$second->menuId);
								?>
								<?php if($details!=''): ?>
								<tr>
									<td><?php echo $firstname." -> ".$secondname; ?><input type="hidden" value="<?php echo $second->menuId; ?>" class="menuId" name="menuIds[]"></td>
								<td><?php echo Form::checkbox('viewClass[]','',($details->viewPermission==1),['class'=>'single viewClass']); ?> </td>
								<td><?php echo Form::checkbox('createClass[]','',($details->createPermission==1),['class'=>'single createClass']); ?></td>
								<td><?php echo Form::checkbox('updateClass[]','',($details->updatePermission==1),['class'=>'single updateClass']); ?></td>
								<td><?php echo Form::checkbox('deleteClass[]','',($details->deletePermission==1),['class'=>'single deleteClass']); ?></td>
							</tr>
								<?php else: ?>
								<tr>
									<td><?php echo $firstname." -> ".$secondname; ?><input type="hidden" value="<?php echo $second->menuId; ?>" class="menuId" name="menuIds[]"></td>
								<td><input type="checkbox" class="single viewClass" name="viewClass[]"></td>
								<td><input type="checkbox" class="single createClass" name="createClass[]"></td>
								<td><input type="checkbox" class="single updateClass" name="updateClass[]"></td>
								<td><input type="checkbox" class="single deleteClass" name="deleteClass[]"></td>
								</tr>
								<?php endif; ?>
								<?php if(Adminmenumanage::hasSubmenu($second->menuId)>0): ?>
									<?php $__currentLoopData = Adminmenumanage::getSubmenu($second->menuId); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $third): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<?php 
									$thirdname=Adminmenumanage::getmenuname($third->menuId); 
									?>
									<?php if($details!=''): ?>
									<tr>
										<td><?php echo $firstname." -> ".$secondname." -> ".$thirdname; ?><input type="hidden" value="<?php echo $third->menuId; ?>" class="menuId" name="menuIds[]"></td>
									<td><?php echo Form::checkbox('viewClass[]','',($details->viewPermission==1),['class'=>'single viewClass']); ?> </td>
								<td><?php echo Form::checkbox('createClass[]','',($details->createPermission==1),['class'=>'single createClass']); ?></td>
								<td><?php echo Form::checkbox('updateClass[]','',($details->updatePermission==1),['class'=>'single updateClass']); ?></td>
								<td><?php echo Form::checkbox('deleteClass[]','',($details->deletePermission==1),['class'=>'single deleteClass']); ?></td>
							</tr>
								<?php else: ?>
									<tr>
										<td><?php echo $firstname." -> ".$secondname." -> ".$thirdname; ?><input type="hidden" value="<?php echo $third->menuId; ?>" class="menuId" name="menuIds[]"></td>
								<td><input type="checkbox" class="single viewClass" name="viewClass[]"></td>
								<td><input type="checkbox" class="single createClass" name="createClass[]"></td>
								<td><input type="checkbox" class="single updateClass" name="updateClass[]"></td>
								<td><input type="checkbox" class="single deleteClass" name="deleteClass[]"></td>
									</tr>
										<?php endif; ?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<?php endif; ?>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							<?php endif; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>

									
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn btn-flat btn-primary ink-reaction updateUserrole">Update User Role</button>
									</div>
								</div>

							</div><!--end .card -->
						<?php echo Form::close(); ?>

					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
<?php echo HTML::script('backend/js/adminmenu.js'); ?>

<script type="text/javascript">

$(document).ready(function(){
	if($('.viewClass:checked').length==$('.viewClass').length){
		$('.view').prop('checked',true);
	}

	if($('.createClass:checked').length==$('.createClass').length){
		$('.create').prop('checked',true);
	}

	if($('.updateClass:checked').length==$('.updateClass').length){
		$('.update').prop('checked',true);
	}

	if($('.deleteClass:checked').length==$('.deleteClass').length){
		$('.delete').prop('checked',true);
	}
});
	$(document).on('click','.selectAll',function(){
		var selected=$(this);
		if(selected.hasClass('view')){
			if(selected.is(':checked')){
				$('.viewClass').prop('checked',true);
			}else{
				$('.viewClass').prop('checked',false);
			}
		}

		if(selected.hasClass('create')){
			if(selected.is(':checked')){
				$('.createClass').prop('checked',true);
			}else{
				$('.createClass').prop('checked',false);
			}
		}


		if(selected.hasClass('update')){
			if(selected.is(':checked')){
				$('.updateClass').prop('checked',true);
			}else{
				$('.updateClass').prop('checked',false);
			}
		}

		if(selected.hasClass('delete')){
			if(selected.is(':checked')){
				$('.deleteClass').prop('checked',true);
			}else{
				$('.deleteClass').prop('checked',false);
			}
		}	
	});

	$(document).on('click','.single',function(){
		var selected=$(this);
		if(selected.hasClass('viewClass')){
			if(selected.is(':checked')){
				selected.parent().parent().find('.viewClass').prop('checked',true);
				if($('.viewClass:checked').length==$('.viewClass').length){
					$('.view').prop('checked',true);
				}
			}else{
				selected.parent().parent().find('input').prop('checked',false);
				$('.view').prop('checked',false);
			}
		}

		if(selected.hasClass('createClass')){
			if(selected.is(':checked')){
				selected.parent().parent().find('.createClass').prop('checked',true);
				if($('.createClass:checked').length==$('.createClass').length){
					$('.create').prop('checked',true);
				}
				selected.parent().parent().find('.viewClass').prop('checked',true);
			}else{
				selected.parent().parent().find('.createClass').prop('checked',false);
				$('.create').prop('checked',false);
			}
		}


		if(selected.hasClass('updateClass')){
			if(selected.is(':checked')){
				selected.parent().parent().find('.updateClass').prop('checked',true);
				if($('.updateClass:checked').length==$('.updateClass').length){
					$('.update').prop('checked',true);
				}
				selected.parent().parent().find('.viewClass').prop('checked',true);
			}else{
				selected.parent().parent().find('.updateClass').prop('checked',false);
				$('.update').prop('checked',false);
			}
		}

		if(selected.hasClass('deleteClass')){
			if(selected.is(':checked')){
				selected.parent().parent().find('.deleteClass').prop('checked',true);
				if($('.deleteClass:checked').length==$('.deleteClass').length){
					$('.delete').prop('checked',true);
				}
				selected.parent().parent().find('.viewClass').prop('checked',true);
			}else{
				selected.parent().parent().find('.deleteClass').prop('checked',false);
				$('.delete').prop('checked',false);
			}
		}

	});
	

	$(document).on('click','.updateUserrole',function(){
		$('.has-error').removeClass('has-error');
		var roleName=$('#roleName').val();
		var roleId='<?php echo $roleId; ?>';
		if(roleName==''){
			$('#roleName').parent().addClass('has-error');
			error_msg('Please enter user role name.');
			return false;
		}
		var record=[];
		$('#modifyuserroleForm tbody tr').each(function(){
			var menuId=$(this).find('.menuId').val();
			if($(this).find('.viewClass').is(':checked')){
				var view=1;
			}else{
				var view=0;
			}

			if($(this).find('.createClass').is(':checked')){
				var create=1;
			}else{
				var create=0;
			}

			if($(this).find('.updateClass').is(':checked')){
				var update=1;
			}else{
				var update=0;
			}

			if($(this).find('.deleteClass').is(':checked')){
				var deleteId=1;
			}else{
				var deleteId=0;
			}

			var details={menuId:menuId,view:view,create:create,update:update,deleteId:deleteId};
			record.push(details);
		});
		$.ajax({
		    url:'/admin/users/role/modify', 
		    data: { roleName:roleName,details:record,roleId:roleId },
		    headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
		    dataType:'json', 
		    type:'POST',
		    success: function(res){ 
		    	console.log(res);
		      if(res.status == 'success'){ 
		      	success_msg(res.msg); 
		      }else{
		      	error_msg('Error Found.');
		      }
		    }, error: function(e){ 
		    	console.log(e.responseText); 
		    }
		  }); 
		return false;
	});


</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/users/modifyuserrole.blade.php ENDPATH**/ ?>