<?php 
	use App\Models\User; 
	use App\Models\Option; 
	use App\Models\Generalsetting; 
?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i> Home</li>
					<li class="active">Settings</li>
					<li class="active">General</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">General Settings</h1>
					</div><!--end .col -->

					<div class="col-md-12">
						<div class="card">
							<div class="card-head style-primary">
								<header>General Settings</header>
							</div>

							<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

							<div class="card-body">
								<?php echo Form::open(["url"=>"admin/settings/general","class"=>"form"]); ?>

									<div class="form-group <?php if($errors->has('siteTitle')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("siteTitle",Option::getvalue("siteTitle"),["class"=>"form-control"]); ?>

											<?php if($errors->has("siteTitle")): ?>
												<span id="siteTitle-error" class="help-block"><?php echo $errors->first("siteTitle"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("siteTitle","Site Title<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('portalName')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("portalName",Option::getvalue("portalName"),["class"=>"form-control"]); ?>

											<?php if($errors->has("portalName")): ?>
												<span id="portalName-error" class="help-block"><?php echo $errors->first("portalName"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("portalName","Portal Name<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('emailNotification')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("emailNotification",Option::getvalue("emailNotification"),["class"=>"form-control"]); ?>

											<?php if($errors->has("emailNotification")): ?>
												<span id="emailNotification-error" class="help-block"><?php echo $errors->first("emailNotification"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("emailNotification","E-Mail Notification<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('smsNotification')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("smsNotification",Option::getvalue("smsNotification"),["class"=>"form-control"]); ?>

											<?php if($errors->has("smsNotification")): ?>
												<span id="smsNotification-error" class="help-block"><?php echo $errors->first("smsNotification"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("smsNotification","SMS Notification<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('homeUrl')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("homeUrl",Option::getvalue("homeUrl"),["class"=>"form-control"]); ?>

											<?php if($errors->has("homeUrl")): ?>
												<span id="homeUrl-error" class="help-block"><?php echo $errors->first("homeUrl"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("homeUrl","Home URL<span class='text-danger'>*</span>")); ?>

									</div>

									<div>
										<?php $dateFormat=Option::getvalue("dateFormat"); ?>
										<label>Date Format<span class='text-danger'>*</span></label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="dateFormat" value="d S F Y" <?php if($dateFormat=="d S F Y"){ echo "checked";} ?>><span><?php echo date("dS F Y"); ?></span>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="dateFormat" value="Y-m-d" <?php if($dateFormat=="Y-m-d"){ echo "checked";} ?>><span><?php echo date("Y-m-d"); ?></span>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="dateFormat" value="m/d/Y" <?php if($dateFormat=="m/d/y"){ echo "checked";} ?>><span><?php echo date("m/d/Y"); ?></span>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="dateFormat" value="d/m/Y" <?php if($dateFormat=="d/m/Y"){ echo "checked";} ?>><span><?php echo date("d/m/Y"); ?></span><br>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="dateFormat" value="D, d-M-Y" <?php if($dateFormat=="D, d-M-Y"){ echo "checked";} ?>><span><?php echo date("D, d-M-Y"); ?></span><br>
										</label><br>
										<span id="dateFormat-error" class="help-block"><?php echo $errors->first("dateFormat"); ?></span>
									</div>

									<div>
										<?php $timeFormat=Option::getvalue("timeFormat"); ?>
										<label>Time Format<span class='text-danger'>*</span></label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="timeFormat" value="h:i a" <?php if($timeFormat=="h:i a"){ echo "checked";} ?>><span><?php echo date("h:i a"); ?></span>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="timeFormat" value="h:i A" <?php if($timeFormat=="h:i A"){ echo "checked";} ?>><span><?php echo date("h:i A"); ?></span>
										</label><br>
										<label class="radio-inline radio-styled">
											<input type="radio" name="timeFormat" value="h:i" <?php if($timeFormat=="h:i"){ echo "checked";} ?>><span><?php echo date("h:i"); ?></span>
										</label>
										<span id="timeFormat-error" class="help-block"><?php echo $errors->first("timeFormat"); ?></span>
									</div>

									<div class="form-group <?php if($errors->has('corporate')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("corporate", Option::getvalue("corporate"), ["class"=>"form-control"]); ?>

											<?php if($errors->has("corporate")): ?>
												<span id="corporate-error" class="help-block"><?php echo $errors->first("corporate"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("corporate","Corporate Price<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('individual')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("individual", Option::getvalue("individual"), ["class"=>"form-control"]); ?>

											<?php if($errors->has("individual")): ?>
												<span id="individual-error" class="help-block"><?php echo $errors->first("individual"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("individual","Individual Price<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('student')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("student", Option::getvalue("student"), ["class"=>"form-control"]); ?>

											<?php if($errors->has("student")): ?>
												<span id="student-error" class="help-block"><?php echo $errors->first("student"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("student","Student Price<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('courseFee')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("courseFee", Option::getvalue("courseFee"), ["class"=>"form-control"]); ?>

											<?php if($errors->has("courseFee")): ?>
												<span id="courseFee-error" class="help-block"><?php echo $errors->first("courseFee"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("courseFee","Course Fee<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('GST')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("GST", Option::getvalue("GST"), ["class"=>"form-control"]); ?>

										<em>Enter Only Percentage value Ex: 18</em>
											<?php if($errors->has("GST")): ?>
												<span id="GST-error" class="help-block"><?php echo $errors->first("GST"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("GST","GST<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="card-actionbar">
										<div class="card-actionbar-row">
											<button type="submit" class="btn ink-reaction btn-primary-dark">Save Settings</button>
											<?php echo Form::close(); ?>

										</div>
									</div>
								<?php echo Form::close(); ?>

							</div><!--end .card-body -->
						</div><!--end .card -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
	<?php echo HTML::script('backend/js/bala.js'); ?>

	<script>
		$('input[name="GST"]').keyup(function() {
	        if (this.value.match(/[^0-9 ]/g)) {
	            this.value = this.value.replace(/[^0-9 ]/g, '');
	        }
	    });
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/settings/generalSettings.blade.php ENDPATH**/ ?>