<?php 
	use App\Models\CustomPages; 
	use App\Models\Option;
?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active"><?php echo CustomPages::getcontent("contactUsPageTitle"); ?></li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary"><?php echo CustomPages::getcontent("contactUsPageTitle"); ?></h1>
					</div><!--end .col -->

					<div class="clearfix"></div>
					<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>
					
					<div class="col-lg-12 col-md-12">
						<?php echo Form::open(["url"=>"admin/pages/aboutus/post","class"=>"form","enctype"=>"multipart/form-data","files"=>true]); ?>

								<div class="panel panel-default">
				        			<div class="panel-body">
				            			<div class="row">
				                			<div class="col-md-8 col-lg-8">
					                			<div class="form-group <?php if($errors->has('contactUsPageTitle')): ?>has-error <?php endif; ?>">
													<?php echo Form::text("contactUsPageTitle",CustomPages::getcontent("contactUsPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]); ?>

													<?php if($errors->has("contactUsPageTitle")): ?>
														<span id="contactUsPageTitle-error" class="help-block"><?php echo $errors->first("contactUsPageTitle"); ?></span>
													<?php endif; ?>
													<?php echo HTML::decode(Form::label("contactUsPageTitle","Page Title <span class='text-danger'>*</span>")); ?>

												</div>
				                			</div>

							                <?php
					                    		$data = CustomPages::where("fieldName", "contactUsPageTitle")->first();
					                    	?>

							                <div class="col-md-4 col-lg-4 brd-left">
							                  	<div class="text-right">
							                    	<?php echo e(Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary'])); ?>

								                    <?php if($data): ?>
						                    			<p>
						                    				<b>Last Modified:</b>  <?php echo strtoupper($data->updatedByName); ?> (<?php echo date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)); ?>)
						                    			</p>
						                    		<?php endif; ?>
							                  	</div>
							                </div>
				            			</div>
				        			</div>
				        		</div>

				        <div class="panel panel-default">
				        	<div class="panel-body">
				            	<div class="row">
				                	<div class="col-md-12 col-lg-12">
					                	<div class="form-group <?php if($errors->has('contactUsAddress')): ?>has-error <?php endif; ?>">
											<?php echo Form::textarea("contactUsAddress",CustomPages::getcontent("contactUsAddress"),["class"=>"form-control","placeholder"=>"enter address","rows"=>"4"]); ?>

											<?php if($errors->has("contactUsAddress")): ?>
												<span id="contactUsAddress-error" class="help-block"><?php echo $errors->first("contactUsAddress"); ?></span>
											<?php endif; ?>
											<?php echo HTML::decode(Form::label("contactUsAddress","Address <span class='text-danger'>*</span>")); ?>

										</div>
				                	</div>
				            	</div>
				        	</div>
				        </div>

				        <div class="panel panel-default">
				        	<div class="panel-body">
				            	<div class="row">
				                	<div class="col-md-12 col-lg-12">
						                <div class="form-group <?php if($errors->has('contactUsPhone')): ?>has-error <?php endif; ?>">
											<?php echo Form::text("contactUsPhone",CustomPages::getcontent("contactUsPhone"),["class"=>"form-control","placeholder"=>"enter phone"]); ?>

											<?php if($errors->has("contactUsPhone")): ?>
												<span id="contactUsPhone-error" class="help-block"><?php echo $errors->first("contactUsPhone"); ?></span>
											<?php endif; ?>
											<?php echo HTML::decode(Form::label("contactUsPhone","Phone <span class='text-danger'>*</span>")); ?>

										</div>

										<div class="form-group <?php if($errors->has('contactUsFax')): ?>has-error <?php endif; ?>">
											<?php echo Form::text("contactUsFax",CustomPages::getcontent("contactUsFax"),["class"=>"form-control","placeholder"=>"enter fax"]); ?>

											<?php if($errors->has("contactUsFax")): ?>
												<span id="contactUsFax-error" class="help-block"><?php echo $errors->first("contactUsFax"); ?></span>
											<?php endif; ?>
											<?php echo HTML::decode(Form::label("contactUsFax","Fax <span class='text-danger'>*</span>")); ?>

										</div>

										<div class="form-group <?php if($errors->has('contactUsEmail')): ?>has-error <?php endif; ?>">
											<?php echo Form::text("contactUsEmail",CustomPages::getcontent("contactUsEmail"),["class"=>"form-control","placeholder"=>"enter email"]); ?>

											<?php if($errors->has("contactUsEmail")): ?>
												<span id="contactUsEmail-error" class="help-block"><?php echo $errors->first("contactUsEmail"); ?></span>
											<?php endif; ?>
											<?php echo HTML::decode(Form::label("contactUsEmail","E-Mail <span class='text-danger'>*</span>")); ?>

										</div>

										<div class="form-group <?php if($errors->has('contactUsMap')): ?>has-error <?php endif; ?>">
											<?php echo Form::textarea("contactUsMap",CustomPages::getcontent("contactUsMap"),["class"=>"form-control","placeholder"=>"enter map embedd","rows"=>"4"]); ?>

											<?php if($errors->has("contactUsMap")): ?>
											<span id="contactUsMap-error" class="help-block"><?php echo $errors->first("contactUsMap"); ?></span>
											<?php endif; ?>
											<?php echo HTML::decode(Form::label("contactUsMap","Map Embedd Code <span class='text-danger'>*</span>")); ?>

										</div>
				                	</div>
				            </div>
				        </div>
				        </div>

				        <div class="panel panel-default">
			        		<div class="panel-body">
			            		<div class="row">
			            			<div class="col-md-12 col-lg-12">
				                		<h4 class="text-primary"><b>Search Engine Optimization</b></h4>

										<div class="form-group">
											<?php echo Form::text("contactUsMetaTitle",CustomPages::getcontent("contactUsMetaTitle"),["class"=>"form-control","placeholder"=>"Meta Title","rows"=>"4"]); ?>

											<?php if($errors->has("contactUsMetaTitle")): ?>
												<span id="contactUsMetaTitle-error" class="help-block"><?php echo $errors->first("contactUsMetaTitle"); ?></span>
											<?php endif; ?>
											<?php echo HTML::decode(Form::label("contactUsMetaTitle","Meta Title <span class='text-danger'>*</span>")); ?>

										</div>

										<div class="form-group">
											<?php echo Form::textarea("contactUsMetaDescription",CustomPages::getcontent("contactUsMetaDescription"),["class"=>"form-control","placeholder"=>"Meta Description","rows"=>"4"]); ?>

											<?php if($errors->has("contactUsMetaDescription")): ?>
												<span id="contactUsMetaDescription-error" class="help-block"><?php echo $errors->first("contactUsMetaDescription"); ?></span>
											<?php endif; ?>
											<?php echo HTML::decode(Form::label("contactUsMetaDescription","Meta Description <span class='text-danger'>*</span>")); ?>

										</div>

										<div class="form-group">
											<?php echo Form::text("contactUsMetaKeywords",CustomPages::getcontent("contactUsMetaKeywords"),["class"=>"form-control","placeholder"=>"Meta Keywords","rows"=>"4"]); ?>

											<?php if($errors->has("contactUsMetaKeywords")): ?>
												<span id="contactUsMetaKeywords-error" class="help-block"><?php echo $errors->first("contactUsMetaKeywords"); ?></span>
											<?php endif; ?>
											<?php echo HTML::decode(Form::label("contactUsMetaKeywords","Meta Keywords <span class='text-danger'>*</span>")); ?>

											<p class="help-block">Enter keywords seperated with comma</p>
										</div>
									</div>
								</div>
							</div>
						</div>

				        <?php echo Form::close(); ?>

					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
	<?php echo HTML::script('backend/js/bala.js'); ?>

	<?php echo HTML::script('backend/ckeditor/ckeditor.js'); ?>

	<script type="text/javascript">
	    $(document).ready(function() 
	    {
	      CKEDITOR.replace('aboutdetailsOne');
	      CKEDITOR.replace('aboutdetailsTwo');
	    });
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/pages/contactUs.blade.php ENDPATH**/ ?>