<?php 
	use App\Models\Returnstatuses; 
	use App\Models\Option;
	use App\Models\Upload; 
?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i> Home</li>
					<li class="active">Store Frontend</li>
					<li class="active">Header</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Theme Options</h1>
					</div><!--end .col -->
					<div class="col-md-3">
						<?php echo $__env->make("backend/storefront/storeFrontSidebar", ["page"=>"header"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div><!--end .col -->
					<div class="col-md-6">
						<form class="form" id="headerform">
						<div class="card">
							<div class="card-head style-primary">
								<header>Header</header>
							</div>
							<div class="card-body">
								<div class="form-group">
									<input type="text" id="header_logo" name="header_logo" class="form-control" value="<?php echo Upload::getimageurl(Option::getvalue('header_logo')); ?>">
									<label for="uploadLogo">Upload Logo</label>
									<p class="help-block">Please upload your logo.</p>
								</div><!--end form-group-->
								<p>
									<button class="btn ink-reaction btn-raised btn-sm btn-primary" id="headerlogobox" type="button">Upload</button> &nbsp;&nbsp;
									<button class="btn ink-reaction btn-raised btn-sm btn-default" id="header_removelogo" type="button">Remove</button>
									 <div class="progress progress-striped active" id="logoprogressbox" style="display:none;">
												    <div class="progress-bar progress-bar-warning" id="logoprogress"></div>
									</div>
									<input type="file" id="headerlogo" style="display:none;">
								</p>

								<div class="row">
									<div class="col-md-3" id="logoplace">
										<img src="<?php echo Upload::getimageurl(Option::getvalue('header_logo')); ?>" id="logoplace" class="uploadedImage">
									</div>
								</div>

								<br>

								<div class="form-group">
									<input type="text" id="header_favicon" name="header_favicon" class="form-control" value="<?php echo Upload::getimageurl(Option::getvalue('header_favicon')); ?>">
									<label for="uploadLogo">Upload Favicon</label>
									<p class="help-block">Add your custom Favicon image. 16x16px .ico or .png file required.</p>
								</div><!--end form-group-->
								<p>
									<button class="btn ink-reaction btn-raised btn-sm btn-primary" id="headerfaviconbox" type="button">Upload</button> &nbsp;&nbsp;
									<button class="btn ink-reaction btn-raised btn-sm btn-default" id="header_removefavicon" type="button">Remove</button>
								</p>

								<div class="progress progress-striped active" id="faviconprogressbox" style="display:none;">
									<div class="progress-bar progress-bar-warning" id="faviconprogress"></div>
								</div>
								<input type="file" id="headerfavicon" style="display:none;">

								<div class="row">
									<div class="col-md-3" id="faviconplace">
										<img src="<?php echo Upload::getimageurl(Option::getvalue('header_favicon')); ?>" class="uploadedImage">
									</div>
								</div>

								<br>
								<div class="form-group">
									<input type="text" id="header_contact_no" name="header_contact_no" class="form-control" value="<?php echo Option::getvalue('header_contact_no'); ?>">
									<label for="uploadLogo">Contact No.</label>
								</div><!--end form-group-->

								<div class="form-group">
									<input type="text" id="header_contact_email" name="header_contact_email" class="form-control" value="<?php echo Option::getvalue('header_contact_email'); ?>">
									<label for="uploadLogo">Contact Email</label>
								</div><!--end form-group-->

								<?php if(Option::getvalue('header_scrolltotopbutton') == 'true'){ $check = 'checked'; }else{ $check = ''; } ?>
								<div class="form-group">
									<div class="checkbox checkbox-styled">
										<label>
											<input type="checkbox" name="header_scrolltotopbutton" value="true" <?php echo $check; ?>>
											<span>Show "Scroll to Top" button</span>
										</label>
									</div>
								</div><!--end form-group-->

								<?php if(Option::getvalue('header_signupbutton') == 'true'){ $check = 'checked'; }else{ $check = ''; } ?>
								<div class="form-group">
									<div class="checkbox checkbox-styled">
										<label>
											<input type="checkbox" name="header_signupbutton" value="true" <?php echo $check; ?> >
											<span>Show "Signup/Login" button</span>
										</label>
									</div>
								</div><!--end form-group-->
							</div><!--end .card-body -->
							<div class="card-actionbar">
								<div class="card-actionbar-row">
									<button type="submit" id="saveheadersettings" class="btn ink-reaction btn-primary-dark">Save Changes</button>
								</div>
							</div>
						</div><!--end .card -->
					</form>
					</div><!-- end of col-md-8 -->

				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
	<?php echo HTML::script('backend/assets/js/libs/global/iframe-transport.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/global/jquery-ui.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/global/fileupload.js'); ?>

	<?php echo HTML::script('backend/js/catalogfunction.js'); ?> 
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/storefront/header.blade.php ENDPATH**/ ?>