<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>


<?php $__env->startSection('styles'); ?>
<?php $__env->startSection('styles'); ?>
	<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css'); ?>

	<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css'); ?>

	<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css'); ?>

	<?php echo HTML::style('backend/assets/css/jquery-ui.css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li><a href="<?php echo url('admin/events/get'); ?>">Events</a></li>
					<li>Registration</li>
				</ol>
			</div>

			<div id="exclUploadDiv">
		      	<div class="card">
		        	<div class="card-body">
		          		<div class="row">
		            		<?php echo Form::open(["id"=>"registrationForm"]); ?>

		            			<div class="col-lg-3">
		              				<?php echo Form::select("events",$events,"",["class"=>"form-control","id"=>"events", 'placeholder'=>'Select Event']); ?>

					              	<?php if($errors->has("events")): ?>
										<span id="events-error" class="help-block"><?php echo $errors->first("events"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="col-lg-3">
		              				<?php echo Form::text("dateFrom","",["class"=>"form-control","id"=>"dateFrom","placeholder"=>"From Date"]); ?>

					              	<?php if($errors->has("dateFrom")): ?>
										<span id="dateFrom-error" class="help-block"><?php echo $errors->first("dateFrom"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="col-lg-3">
		              				<?php echo Form::text("dateTo","",["class"=>"form-control","id"=>"dateTo","placeholder"=>"To Date"]); ?>

					              	<?php if($errors->has("dateTo")): ?>
										<span id="dateTo-error" class="help-block"><?php echo $errors->first("dateTo"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="clearfix"></div>	
		            			<br>
		            			
					            <div class="col-lg-2">
					                <input type="button" class="btn ink-reaction btn-success" value="Search" id="searchRegistration">
					                <input type="reset" class="btn ink-reaction btn-danger" value="Reset">
					            </div>
		            		<?php echo Form::close(); ?>

		          		</div>
		        	</div>
		      	</div>
		  	</div>

		  	<div class="clearfix"></div>

  			<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

  			<div class="processLoadingDiv" style='display:none'>
		        <div class="spinner">
				  <div class="bounce1"></div>
				  <div class="bounce2"></div>
				  <div class="bounce3"></div>
				</div>
		        <p class="text-center">Processing.... Please wait...</p>
		    </div>

			<section id="eventRegistrationTable" style="display:none;">

				<div class="section-header">
					<div class="row">
						<div class="col-lg-6">
							<h2 class="text-primary">Event Registration</h2>
						</div>
					</div>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="col-lg-12">
							<div class="table-responsive">
								<table id="myTable" class="table table-striped table-hover">
									<thead>
										<tr>
											<th>#</th>
											<th>Unique ID</th>
											<th>Event</th>
											<th>User</th>
											<th>Tickets</th>
											<th>Amount (Rs.)</th>
											<th>GST (%)</th>
											<th>Total Amount (Rs.)</th>
											<th>Payment Date</th>
											<th>Player Detail</th>
										</tr>
									</thead>

									<tbody>
										
									</tbody>
								</table>
							</div><!--end .table-responsive -->
						</div><!--end .col -->
					</div><!--end .row -->
					<!-- END DATATABLE 1 -->
				</div><!--end .section-body -->
			</section>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->

	<div class="modal" id="playerModel" tabindex="-1" role="dialog">
	  <div class="modal-dialog" role="document">
	    <div class="modal-content">
	      <div class="modal-header">
	        <h5 class="modal-title">Player Details</h5>
	        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
	          <span aria-hidden="true">&times;</span>
	        </button>
	      </div>
	      <div class="modal-body" id="playerDetailBox">
	        		


	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
	      </div>
	    </div>
	  </div>
	</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
  	<?php echo HTML::script('backend/assets/js/jquery-ui.js'); ?>

  	<?php echo HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js'); ?>

	<script>
		$('#myTable').DataTable();
		$(document).ready(function(){
	    	$("#dateFrom").datepicker({
		      	changeMonth: false,
		      	dateFormat:'yy-mm-dd',
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$("#dateTo").datepicker( "option", "minDate", selectedDate );
		      	}
		    });

		    $( "#dateTo" ).datepicker({
		      	dateFormat:'yy-mm-dd',
		      	changeMonth: false,
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$( "#dateFrom" ).datepicker( "option", "maxDate", selectedDate );
		      	}
		    });
		});/* end of ready function */


		//payment reports
		$(document).on("click","#searchRegistration",function(){
	    	var clicked = $(this);
	    	$("#eventRegistrationTable").slideUp();
	        clicked.after('<span id="processingIcon" style="color:#399bff"><i class="fa fa-circle-o-notch fa-spin"></i></span>');
	  		var form = $('#registrationForm').serialize();
	  		console.log(form);
	        $.ajax({
	        	headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
	            type: 'POST',
	            url: '/admin/eventsregistration/post',
	            data: form,
	            dataType: 'json',
	            success:function(data){
	              	console.log(data);
	          		if(data.status == 'success' && data.count > 0){
							var oTable = $('#myTable').dataTable();
	              		oTable.fnClearTable();
						$.each(data.result,function(key,value){
							oTable.fnAddData([data.result[key]['sno'],data.result[key]['uniqueId'],data.result[key]['event'],data.result[key]['user'],data.result[key]['tickets'],data.result[key]['amount'],data.result[key]['gst'],data.result[key]['totalAmount'],data.result[key]['paymentDate'],data.result[key]['sportEvent']]);
						});
						$("#eventRegistrationTable").slideDown();
					}else{
						swal("Empty!", data.msg , "warning");
					}
					$("#processingIcon").remove();
	            },
	            error:function(e){
	              console.log(e.responseText);
	              $("#processingIcon").remove();
	              swal("Error!", "Error processing your request, please try later", "error");
	              return false;
	            }
	        });/* end of ajax */
			return false;
	    });

	    $(document).on("click",".playerDetail",function(){
	    	var clicked = $(this); txt = clicked.text();
	    	clicked.text('fetching...');
	    	var id = clicked.attr('data-id');
	        $.ajax({
	        	headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
	            type: 'POST',
	            url: '/admin/eventsregistration/player/details',
	            data: { id:id },
	            dataType: 'json',
	            success:function(data){
	            	clicked.text(txt);
	          		if(data.status == 'success'){
						$('#playerModel').modal('show');
						$('#playerDetailBox').html(data.template);
					}else{
						swal("Empty!", data.msg , "warning");
					}
	            },
	            error:function(e){
	              clicked.text(txt);
	              swal("Error!", "Error processing your request, please try later", "error");
	              return false;
	            }
	        });/* end of ajax */
			return false;
	    });
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/events/eventsregistration.blade.php ENDPATH**/ ?>