<?php 
	use App\Models\CustomPages; 
	use App\Models\Option; 
?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active"><?php echo CustomPages::getcontent("membershipMainPageTitle"); ?></li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary"><?php echo CustomPages::getcontent("membershipMainPageTitle"); ?></h1>
					</div><!--end .col -->
					
					<div class="clearfix"></div>
					
					<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

					<div class="col-lg-12 col-md-12">
						<?php echo Form::open(["url"=>"admin/members/first/page/post","class"=>"form","enctype"=>"multipart/form-data","files"=>true]); ?>

							<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-8 col-lg-8">
							                <div class="form-group <?php if($errors->has('membershipMainPageTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("membershipMainPageTitle",CustomPages::getcontent("membershipMainPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]); ?>

												<?php if($errors->has("membershipMainPageTitle")): ?>
													<span id="membershipMainPageTitle-error" class="help-block"><?php echo $errors->first("membershipMainPageTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("membershipMainPageTitle","Page Title <span class='text-danger'>*</span>")); ?>

											</div>
						                </div>

						                <div class="col-md-4 col-lg-4 brd-left">
						                  	<div class="text-right">
						                    	<?php echo Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary']); ?>

						                    	<?php
						                    		$data = CustomPages::where("fieldName", "membershipMainPageTitle")->first();
						                    	?>
					                    		<?php if($data): ?>
					                    			<p><b>Last Modified:</b>  <?php echo strtoupper($data->updatedByName); ?> (<?php echo date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)); ?>)</p>
					                    		<?php endif; ?>
						                      
						                  	</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-6 col-lg-6">
						                	<div class="form-group <?php if($errors->has('membershipPageWidgetOneDescription')): ?>has-error <?php endif; ?>">
											<?php echo HTML::decode(Form::label("membershipPageWidgetOneDescription","First Widget Text <span class='text-danger'>*</span>")); ?>

											<?php echo Form::textarea("membershipPageWidgetOneDescription",CustomPages::getcontent("membershipPageWidgetOneDescription"),["class"=>"form-control"]); ?>

												<?php if($errors->has("membershipPageWidgetOneDescription")): ?>
												<span id="membershipPageWidgetOneDescription-error" class="help-block"><?php echo $errors->first("membershipPageWidgetOneDescription"); ?></span>
												<?php endif; ?>
											</div>
						                </div>

						                <div class="col-md-6 col-lg-6">
						                	<div class="form-group <?php if($errors->has('membershipWidgetTwoDescription')): ?>has-error <?php endif; ?>">
											<?php echo HTML::decode(Form::label("membershipWidgetTwoDescription","Second Widget Text <span class='text-danger'>*</span>"),["id"=>"membershipWidgetTwoDescription"]); ?>

											<?php echo Form::textarea("membershipWidgetTwoDescription",CustomPages::getcontent("membershipWidgetTwoDescription"),["class"=>"form-control"]); ?>

												<?php if($errors->has("membershipWidgetTwoDescription")): ?>
												<span id="membershipWidgetTwoDescription-error" class="help-block"><?php echo $errors->first("membershipWidgetTwoDescription"); ?></span>
												<?php endif; ?>
											</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-6 col-lg-6">
							                <div class="form-group <?php if($errors->has('uploadMembershipRegForm')): ?>has-error <?php endif; ?>">
												<?php echo Form::file("uploadMembershipRegForm",["class"=>"form-control"]); ?>

												<?php if($errors->has("uploadMembershipRegForm")): ?>
													<span id="uploadMembershipRegForm-error" class="help-block"><?php echo $errors->first("uploadMembershipRegForm"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("uploadMembershipRegForm","Upload Membership Registration Form <span class='text-danger'>*</span>")); ?>

											</div>
						                </div>

						                <div class="col-md-6 col-lg-6">
						                	<div class="form-group <?php if($errors->has('uploadMembershipRenewalForm')): ?>has-error <?php endif; ?>">
												<?php echo HTML::decode(Form::label("uploadMembershipRenewalForm","Upload Membership Renewal Form <span class='text-danger'>*</span>"),["id"=>"uploadMembershipRenewalForm"]); ?>

												<?php echo Form::file("uploadMembershipRenewalForm",["class"=>"form-control"]); ?>

												<?php if($errors->has("uploadMembershipRenewalForm")): ?>
													<span id="uploadMembershipRenewalForm-error" class="help-block"><?php echo $errors->first("uploadMembershipRenewalForm"); ?></span>
												<?php endif; ?>
											</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>
				        <?php echo Form::close(); ?>

					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
	<?php echo HTML::script('backend/js/bala.js'); ?>

	<?php echo HTML::script('backend/ckeditor/ckeditor.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/global/iframe-transport.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/global/jquery-ui.js'); ?>

	<script type="text/javascript">
	    $(document).ready(function(){
	      	CKEDITOR.replace('membershipPageWidgetOneDescription');
	      	CKEDITOR.replace('membershipWidgetTwoDescription');
	    });
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/members/membership.blade.php ENDPATH**/ ?>