<?php 
	use App\Models\User; 
?>

<?php $__env->startSection('maincontent'); ?>
<!-- BEGIN CONTENT-->
<div id="content">
<section>
	<div class="section-header ">
		<ol class="breadcrumb">
			<li class="active">Home</li>
			<li class="active">Faculties</li>
			<li>Add Faculties</li>
		</ol>
	</div>

	<div class="section-body">
		<!-- BEGIN VERTICAL FORM -->
		<div class="row">
			<div class="col-lg-12">
				<h1 class="text-primary">Add Faculties</h1>
			</div><!--end .col -->

			<div class="col-lg-2 col-md-4">
				<div class="section-header">
					<?php echo HTML::link("admin/courses/faculty/get", "Manage Faculties", ["class"=>"btn ink-reaction btn-block btn-primary"]); ?>

				</div>
			</div><!--end .col -->

			<div class="col-md-10">
				<?php echo Form::open(['url'=>'admin/courses/faculty/add/post', 'class'=>'form']); ?>

					<div class="card">
						<div class="card-head style-primary">
							<header>Add Faculties</header>
						</div>

						<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

						<div class="card-body">
							<div class="row">
								<div class="col-md-6">
									<div class="row">
										<div class="col-sm-12">
											<div class="form-group <?php if($errors->has('facultyName')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("facultyName","",["class"=>"form-control"]); ?>

												<?php if($errors->has("facultyName")): ?>
													<span id="facultyName-error" class="help-block"><?php echo $errors->first("facultyName"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("facultyName","Faculty's Name <span class='text-danger'>*</span>")); ?>

											</div>
										</div>

										<div class="col-sm-12">
											<div class="form-group <?php if($errors->has('facultyDesignation')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("facultyDesignation","",["class"=>"form-control"]); ?>

												<?php if($errors->has("facultyDesignation")): ?>
													<span id="facultyDesignation-error" class="help-block"><?php echo $errors->first("facultyDesignation"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("facultyDesignation","Faculty Designation <span class='text-danger'>*</span>")); ?>

											</div>
										</div>
										
										<div class="col-sm-12">
											<div class="form-group <?php if($errors->has('description')): ?>has-error <?php endif; ?>">
												<?php echo Form::textarea("description","",["class"=>"form-control"]); ?>

												<?php if($errors->has("description")): ?>
													<span id="description-error" class="help-block"><?php echo $errors->first("description"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("description","Description <span class='text-danger'>*</span>")); ?>

											</div>
										</div>
									</div>
								</div>

								<div class="col-md-6">
									<div class="card">
										<div class="card-head">
											<header>Upload Image</header>
										</div><!--end .card-head -->
										
										<div class="card-body">
											<div class="form-group <?php if($errors->has('facultyImage')): ?>has-error <?php endif; ?>">
												<input type="text" value="" class="form-control" name="facultyImage" id="header_logo" readonly>
												<?php if($errors->has("facultyImage")): ?>
													<span id="facultyImage-error" class="help-block"><?php echo $errors->first("facultyImage"); ?></span>
												<?php endif; ?>
												<label for="uploadLogo">Upload Faculty's Photo</label>
												<p class="help-block">Please upload Faculty's Photo.</p>
											</div>

											<p>
												<button type="button" id="headerlogobox" class="btn ink-reaction btn-raised btn-sm btn-primary">Upload</button> &nbsp;&nbsp;
												<button type="button" id="header_removelogo" class="btn ink-reaction btn-raised btn-sm btn-default">Remove</button>
												<div class="progress progress-striped active" id="logoprogressbox" style="display:none;">
													<div class="progress-bar progress-bar-warning" id="logoprogress"></div>
												</div>
												<input type="file" id="headerlogo" style="display:none;">
											</p>

											<div class="row">
												<div class="col-md-3" id="logoplace"><img class="uploadedImage" src=""></div>
											</div>
											<br>
										</div>
									</div>
								</div><!--end col-md-6-->
							</div><!--end row-->
						</div><!--end card-body-->

						<div class="card-actionbar">
							<div class="card-actionbar-row">
								<button class="btn ink-reaction btn-primary-dark" type="submit">SAVE</button>
							</div>
						</div>
					</div><!--end col-md-10-->
				<?php echo Form::close(); ?>

			</div>
		</div>
	</div>
</section>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
	<?php echo HTML::script('backend/assets/js/libs/global/iframe-transport.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/global/jquery-ui.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/global/fileupload.js'); ?>

	<?php echo HTML::script('backend/js/adminmenu.js'); ?>

	<script type="text/javascript">
		$('select').select2();

  		$('#headerlogobox').click(function () { $("#headerlogo").trigger('click'); });
  		$('#header_removelogo').on('click', function(){ $('#header_logo').val(''); $('#logoplace').remove(); });
  		$('#headerlogo').fileupload({
            url: '/imageupload',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
            dataType: 'json',
            formData: { path:'' },
            done: function (e, data) {
                var baseurl = document.location.origin;
                var src = baseurl+'/'+data.result.files[0].url;
                $('#logoplace').html('').html('<img src="'+src+'" id="logoplace" class="uploadedImage">');
                $('#header_logo').val(src);
                storeimages();
                console.log(src);
            },
            progressall: function (e, data) {
                $('#logoprogressbox').show();
                var progress = parseInt(data.loaded / data.total * 100, 10);
                $('#logoprogress').css(
                    'width',
                    progress + '%'
                ).text(progress+'%');
            },error: function(e){
              console.log(e.responseText);
            }
        }).prop('disabled', !$.support.fileInput)
        .parent().addClass($.support.fileInput ? undefined : 'disabled');

        function storeimages(u,key){
         	$('.progress').next().css('width','0%').text(''); $('.progress').hide();
        	console.log(res); return false;
		}
  	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/courses/addFaculties.blade.php ENDPATH**/ ?>