<?php 
	use App\Models\Option; 
	use App\Models\Upload; 
	use App\Models\Events; 
	use App\Models\CustomPages; 
?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i>Home</li>
					<li class="active">Store Frontend</li>
					<li class="active">Footer</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-md-12">

						<div class="clearfix"></div>

						<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

						<?php echo Form::open(["url"=>"admin/storefront/home/page/content/header/portion", "class"=>"form"]); ?>

							<div class="card">
								<div class="card-head style-primary">
									<header>Content Header Portion</header>
								</div>

								<?php
									$events = Events::where("status", "active")->pluck("eventTitle", "id");
								?>

								<div class="card-body">
									<div class="row">
										<div class="col-lg-12">
											<div class="form-group <?php if($errors->has('HPHPWelcomeTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPHPWelcomeTitle",CustomPages::getcontent("HPHPWelcomeTitle"),["class"=>"form-control","placeholder"=>"enter heading one"]); ?>

												<?php if($errors->has("HPHPWelcomeTitle")): ?>
													<span id="HPHPWelcomeTitle-error" class="help-block"><?php echo $errors->first("HPHPWelcomeTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPHPWelcomeTitle","Heading One <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<div class="form-group <?php if($errors->has('HPHPSecondTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPHPSecondTitle",CustomPages::getcontent("HPHPSecondTitle"),["class"=>"form-control","placeholder"=>"enter heading two"]); ?>

												<?php if($errors->has("HPHPSecondTitle")): ?>
													<span id="HPHPSecondTitle-error" class="help-block"><?php echo $errors->first("HPHPSecondTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPHPSecondTitle","Heading Two <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->
										</div>

										<div class="col-lg-4 col-md-4 col-sm-6">
											<h4><b>Widget One</b></h4>
											<div class="form-group <?php if($errors->has('HPHPWidOneTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPHPWidOneTitle",CustomPages::getcontent("HPHPWidOneTitle"),["class"=>"form-control","placeholder"=>"enter widget title"]); ?>

												<?php if($errors->has("HPHPWidOneTitle")): ?>
													<span id="HPHPWidOneTitle-error" class="help-block"><?php echo $errors->first("HPHPWidOneTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPHPWidOneTitle","Title <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<div class="form-group <?php if($errors->has('HPHPWidOneCate')): ?>has-error <?php endif; ?>">
												<?php echo Form::select("HPHPWidOneCate",$eventCategories,CustomPages::getcontent("HPHPWidOneCate"),["class"=>"form-control","placeholder"=>"Category","id"=>"HPHPWidOneCate"]); ?>

												<?php if($errors->has("HPHPWidOneCate")): ?>
													<span id="HPHPWidOneCate-error" class="help-block"><?php echo $errors->first("HPHPWidOneCate"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPHPWidOneCate","Category <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<?php
												$eventsWidgetOne = CustomPages::getcontent("HPHPWidOneEvents");
												$eventsOne = [];
												if($eventsWidgetOne != ''){
													$eventsOne = array_map('intval', explode(',',$eventsWidgetOne)) ;
												}
											?>

											<div class="form-group <?php if($errors->has('HPHPWidOneEvents')): ?>has-error <?php endif; ?>">
												<?php echo Form::select("HPHPWidOneEvents[]",$events,$eventsOne,["class"=>"form-control placeEvents","multiple"=>"multiple"]); ?>

												<?php if($errors->has("HPHPWidOneEvents")): ?>
													<span id="HPHPWidOneEvents-error" class="help-block"><?php echo $errors->first("HPHPWidOneEvents"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPHPWidOneEvents","Events <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->
										</div>

										<div class="col-lg-4 col-md-4 col-sm-6">
											<h4><b>Widget Two</b></h4>
											<div class="form-group <?php if($errors->has('HPHPWidTwoTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPHPWidTwoTitle",CustomPages::getcontent("HPHPWidTwoTitle"),["class"=>"form-control","placeholder"=>"enter widget title"]); ?>

												<?php if($errors->has("HPHPWidTwoTitle")): ?>
													<span id="HPHPWidTwoTitle-error" class="help-block"><?php echo $errors->first("HPHPWidTwoTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPHPWidTwoTitle","Title <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<div class="form-group <?php if($errors->has('HPHPWidTwoCate')): ?>has-error <?php endif; ?>">
												<?php echo Form::select("HPHPWidTwoCate",$eventCategories,CustomPages::getcontent("HPHPWidTwoCate"),["class"=>"form-control","placeholder"=>"Category","id"=>"HPHPWidTwoCate"]); ?>

												<?php if($errors->has("HPHPWidTwoCate")): ?>
													<span id="HPHPWidTwoCate-error" class="help-block"><?php echo $errors->first("HPHPWidTwoCate"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPHPWidTwoCate","Category <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<?php
												$eventsWidgetTwo = CustomPages::getcontent("HPHPWidTwoEvents");
												$eventsTwo = [];
												if($eventsWidgetTwo != ''){
													$eventsTwo = array_map('intval', explode(',',$eventsWidgetTwo)) ;
												}
											?>

											<div class="form-group <?php if($errors->has('HPHPWidTwoEvents')): ?>has-error <?php endif; ?>">
												<?php echo Form::select("HPHPWidTwoEvents[]",$events,$eventsTwo,["class"=>"form-control placeEvents","multiple"=>"multiple"]); ?>

												<?php if($errors->has("HPHPWidTwoEvents")): ?>
													<span id="HPHPWidTwoEvents-error" class="help-block"><?php echo $errors->first("HPHPWidTwoEvents"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPHPWidTwoEvents","Events <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->
										</div>

										<div class="col-lg-4 col-md-4 col-sm-6">
											<h4><b>Widget Three</b></h4>
											<div class="form-group <?php if($errors->has('HPHPWidThreeTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPHPWidThreeTitle",CustomPages::getcontent("HPHPWidThreeTitle"),["class"=>"form-control","placeholder"=>"enter widget title"]); ?>

												<?php if($errors->has("HPHPWidThreeTitle")): ?>
													<span id="HPHPWidThreeTitle-error" class="help-block"><?php echo $errors->first("HPHPWidThreeTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPHPWidThreeTitle","Title <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<div class="form-group <?php if($errors->has('HPHPWidThreeCate')): ?>has-error <?php endif; ?>">
												<?php echo Form::select("HPHPWidThreeCate",$newsCategories,CustomPages::getcontent("HPHPWidThreeCate"),["class"=>"form-control getEvents","placeholder"=>"Category","id"=>"HPHPWidThreeCate"]); ?>

												<?php if($errors->has("HPHPWidThreeCate")): ?>
													<span id="HPHPWidThreeCate-error" class="help-block"><?php echo $errors->first("HPHPWidThreeCate"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPHPWidThreeCate","Category <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<?php
												$eventsWidgetThree = CustomPages::getcontent("HPHPWidThreeEvents");
												$eventsThree = [];
												if($eventsWidgetThree != ''){
													$eventsThree = array_map('intval', explode(',',$eventsWidgetThree)) ;
												}
											?>
											<div class="form-group <?php if($errors->has('HPHPWidThreeEvents')): ?>has-error <?php endif; ?>">
												<?php echo Form::select("HPHPWidThreeEvents[]",$news,$eventsThree,["class"=>"form-control placeEvents","multiple"=>"multiple"]); ?>

												<?php if($errors->has("HPHPWidThreeEvents")): ?>
													<span id="HPHPWidThreeEvents-error" class="help-block"><?php echo $errors->first("HPHPWidThreeEvents"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPHPWidThreeEvents","Events <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->
										</div>
									</div><!--end row-->
								</div><!--end card-body-->
					
								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<!-- <button class="btn ink-reaction btn-primary">Preview</button> -->
										<button type="submit" id="publishGallery" class="btn ink-reaction btn-primary-dark">Publish Content</button>
									</div>
								</div>
							</div><!--end .card -->
						<?php echo Form::close(); ?>


						<?php echo Form::open(["url"=>"admin/storefront/home/page/content/middle/portion", "class"=>"form"]); ?>

							<div class="card">
								<div class="card-head style-primary">
									<header>Content Middle Portion</header>
								</div>

								<div class="card-body">
									<div class="row">
										<div class="col-lg-12">
											<div class="form-group <?php if($errors->has('HPCMPSmallTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPCMPSmallTitle",CustomPages::getcontent("HPCMPSmallTitle"),["class"=>"form-control","placeholder"=>"enter heading one"]); ?>

												<?php if($errors->has("HPCMPSmallTitle")): ?>
													<span id="HPCMPSmallTitle-error" class="help-block"><?php echo $errors->first("HPCMPSmallTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCMPSmallTitle","Heading One <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<div class="form-group <?php if($errors->has('HPCMPSecondTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPCMPSecondTitle",CustomPages::getcontent("HPCMPSecondTitle"),["class"=>"form-control","placeholder"=>"enter heading two"]); ?>

												<?php if($errors->has("HPCMPSecondTitle")): ?>
													<span id="HPCMPSecondTitle-error" class="help-block"><?php echo $errors->first("HPCMPSecondTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCMPSecondTitle","Heading Two <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<div class="form-group <?php if($errors->has('HPCMPDescription')): ?>has-error <?php endif; ?>">
												<?php echo Form::textarea("HPCMPDescription",CustomPages::getcontent("HPCMPDescription"),["class"=>"form-control","placeholder"=>"enter description","rows"=>4]); ?>

												<?php if($errors->has("HPCMPDescription")): ?>
													<span id="HPCMPDescription-error" class="help-block"><?php echo $errors->first("HPCMPDescription"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCMPDescription","Description <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->
										</div>

										<div class="col-lg-4 col-md-4 col-sm-6">
											<h4><b>Widget One</b></h4>
											<div class="form-group <?php if($errors->has('HPCMPWidOneTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPCMPWidOneTitle",CustomPages::getcontent("HPCMPWidOneTitle"),["class"=>"form-control","placeholder"=>"enter widget title"]); ?>

												<?php if($errors->has("HPCMPWidOneTitle")): ?>
													<span id="HPCMPWidOneTitle-error" class="help-block"><?php echo $errors->first("HPCMPWidOneTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCMPWidOneTitle","Title <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<div class="form-group <?php if($errors->has('HPCMPWidOneDescription')): ?>has-error <?php endif; ?>">
												<?php echo Form::textarea("HPCMPWidOneDescription",CustomPages::getcontent("HPCMPWidOneDescription"),["class"=>"form-control placeEvents","placeholder"=>"description","rows"=>"4"]); ?>

												<?php if($errors->has("HPCMPWidOneDescription")): ?>
													<span id="HPCMPWidOneDescription-error" class="help-block"><?php echo $errors->first("HPCMPWidOneDescription"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCMPWidOneDescription","Description <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->
										</div>

										<div class="col-lg-4 col-md-4 col-sm-6">
											<h4><b>Widget Two</b></h4>
											<div class="form-group <?php if($errors->has('HPCMPWidTwoTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPCMPWidTwoTitle",CustomPages::getcontent("HPCMPWidTwoTitle"),["class"=>"form-control","placeholder"=>"enter widget title"]); ?>

												<?php if($errors->has("HPCMPWidTwoTitle")): ?>
													<span id="HPCMPWidTwoTitle-error" class="help-block"><?php echo $errors->first("HPCMPWidTwoTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCMPWidTwoTitle","Title <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<div class="form-group <?php if($errors->has('HPCMPWidTwoDescription')): ?>has-error <?php endif; ?>">
												<?php echo Form::textarea("HPCMPWidTwoDescription",CustomPages::getcontent("HPCMPWidTwoDescription"),["class"=>"form-control placeEvents","placeholder"=>"description","rows"=>"4"]); ?>

												<?php if($errors->has("HPCMPWidTwoDescription")): ?>
													<span id="HPCMPWidTwoDescription-error" class="help-block"><?php echo $errors->first("HPCMPWidTwoDescription"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCMPWidTwoDescription","Description <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->
										</div>

										<div class="col-lg-4 col-md-4 col-sm-6">
											<h4><b>Widget Three</b></h4>
											<div class="form-group <?php if($errors->has('HPCMPWidThreeTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPCMPWidThreeTitle",CustomPages::getcontent("HPCMPWidThreeTitle"),["class"=>"form-control","placeholder"=>"enter widget title"]); ?>

												<?php if($errors->has("HPCMPWidThreeTitle")): ?>
													<span id="HPCMPWidThreeTitle-error" class="help-block"><?php echo $errors->first("HPCMPWidThreeTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCMPWidThreeTitle","Title <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->
											<?php
												$eventsWidgetThree = CustomPages::getcontent("HPCMPWidThreeEvents");
												$eventsThree = [];
												if($eventsWidgetThree != ''){
													$eventsThree = array_map('intval', explode(',',$eventsWidgetThree)) ;
												}
											?>

											<div class="form-group <?php if($errors->has('HPCMPWidThreeEvents')): ?>has-error <?php endif; ?>">
												<?php echo Form::select("HPCMPWidThreeEvents[]",$events,$eventsThree,["class"=>"form-control placeEvents","multiple"=>"multiple"]); ?>

												<?php if($errors->has("HPCMPWidThreeEvents")): ?>
													<span id="HPCMPWidThreeEvents-error" class="help-block"><?php echo $errors->first("HPCMPWidThreeEvents"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCMPWidThreeEvents","Events <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->
										</div>
									</div><!--end row-->
								</div><!--end card-body-->
					
								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<!-- <button class="btn ink-reaction btn-primary">Preview</button> -->
										<button type="submit" id="publishGallery" class="btn ink-reaction btn-primary-dark">Publish Content</button>
									</div>
								</div>
							</div><!--end .card -->
						<?php echo Form::close(); ?>


						<?php echo Form::open(["url"=>"admin/storefront/home/page/content/band/portion","class"=>"form"]); ?>

							<div class="card">
								<div class="card-head style-primary">
									<header>Content Band Portion</header>
								</div>

								<div class="card-body">
									<div class="row">
										<div class="col-lg-12">
											<div class="form-group <?php if($errors->has('HPCBPTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPCBPTitle",CustomPages::getcontent("HPCBPTitle"),["class"=>"form-control","placeholder"=>"enter heading"]); ?>

												<?php if($errors->has("HPCBPTitle")): ?>
													<span id="HPCBPTitle-error" class="help-block"><?php echo $errors->first("HPCBPTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCBPTitle","Heading <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<div class="form-group <?php if($errors->has('HPCBPDescription')): ?>has-error <?php endif; ?>">
												<?php echo Form::textarea("HPCBPDescription",CustomPages::getcontent("HPCBPDescription"),["class"=>"form-control","placeholder"=>"enter description","rows"=>4]); ?>

												<?php if($errors->has("HPCBPDescription")): ?>
													<span id="HPCBPDescription-error" class="help-block"><?php echo $errors->first("HPCBPDescription"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCBPDescription","Description <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->
										</div>

										<div class="col-lg-4 col-md-4 col-sm-6">
											<h4><b>Widget</b></h4>
											<div class="form-group <?php if($errors->has('HPCBPWidThreeTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("HPCBPWidThreeTitle",CustomPages::getcontent("HPCBPWidThreeTitle"),["class"=>"form-control","placeholder"=>"enter widget title"]); ?>

												<?php if($errors->has("HPCBPWidThreeTitle")): ?>
													<span id="HPCBPWidThreeTitle-error" class="help-block"><?php echo $errors->first("HPCBPWidThreeTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCBPWidThreeTitle","Title <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->

											<?php
												$eventsWidgetThree = CustomPages::getcontent("HPCBPEvents");
												$eventsThree = [];
												if($eventsWidgetThree != ''){
													$eventsThree = array_map('intval', explode(',',$eventsWidgetThree)) ;
												}
											?>

											<div class="form-group <?php if($errors->has('HPCBPEvents')): ?>has-error <?php endif; ?>">
												<?php echo Form::select("HPCBPEvents[]",$events,$eventsThree,["class"=>"form-control placeEvents","multiple"=>"multiple"]); ?>

												<?php if($errors->has("HPCBPEvents")): ?>
													<span id="HPCBPEvents-error" class="help-block"><?php echo $errors->first("HPCBPEvents"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("HPCBPEvents","Events <span class='text-danger'>*</span>")); ?>

											</div><!--end form-group-->
										</div>
									</div><!--end row-->
								</div><!--end card-body-->
					
								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<!-- <button class="btn ink-reaction btn-primary">Preview</button> -->
										<button type="submit" id="publishGallery" class="btn ink-reaction btn-primary-dark">Publish Content</button>
									</div>
								</div>
							</div><!--end .card -->
						<?php echo Form::close(); ?>

					
					
						<div class="card">
							<div class="card-head">
								<header>Gallery Images</header>
							</div>

							<div class="card-body">
								<?php echo Form::open(["url"=>"admin/storefront/home/page/gallery/post", "class"=>"form"]); ?>

									<div class="row">
										<div class="col-md-12">
											<ul class="product_images_container" id="pro_galleryimgbox">
												<?php
												 	$galimg = Upload::where('type', 'home')->get();
												?>
												<?php $__currentLoopData = $galimg; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<li>
														<button class="btn ink-reaction btn-icon-toggle btn-primary removeimg" data-id="<?php echo Crypt::encrypt($gal->id); ?>" type="button"><i class="fa fa-close"></i></button>
														<img src="<?php echo $gal->path; ?>">
														<input type="hidden" name="pro_galleryimage[]" value="<?php echo $gal->path; ?>">
														<input type="hidden" name="pro_gallerythumbimage[]" value="<?php echo $gal->thumbnail; ?>">
														<input type="hidden" name="pro_gallerythumb1image[]" value="<?php echo $gal->thumbnail1; ?>">
													</li>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>	
											</ul>
											<a href="javascript:;" id="pro_gallerybtn" class="btn btn-block ink-reaction btn-default">Upload Gallery Images</a>
											<div class="progress progress-striped active" id="pro_galleryprogressbox" style="display:none;">
												<div class="progress-bar progress-bar-warning" id="pro_galleryprogress"></div>
											</div>
											<input type="file" multiple="" id="pro_galleryfile" style="display:none;">
										

											<div class="card-actionbar">
												<div class="card-actionbar-row">
													<!-- <button class="btn ink-reaction btn-primary">Preview</button> -->
													<button type="submit" id="publishGallery" class="btn ink-reaction btn-primary-dark">Publish Gallery</button>
												</div>
											</div>
										</div>
									</div>
								<?php echo Form::close(); ?>

							</div>
						</div>
					</div><!--end .row -->
					<!-- END VERTICAL FORM -->
				</div>
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
<?php echo HTML::script('backend/assets/js/libs/global/iframe-transport.js'); ?>

<?php echo HTML::script('backend/assets/js/libs/global/jquery-ui.js'); ?>

<?php echo HTML::script('backend/assets/js/libs/global/fileupload.js'); ?>

<?php echo HTML::script('backend/js/balaFileUpload.js'); ?>


<script type="text/javascript">
	// $(document).on("change", ".getEvents", function(){
	// 	var current = $(this);
	// 	var ID = current.val();
	// 	$.ajax({
	// 		type: "POST",
	// 		url: "/admin/storefront/home/page/category/events",
	// 		headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
	// 		data: {ID:ID},
	// 		dataType: "json",
	// 		success: function(data){
	// 			// console.log(data);
	// 			// var place = current.parent().next().find(".placeEvents");
	// 			// current.parent().next().find(".placeEvents").select2("val", "");
	// 			// $(place).select2("val", "");
	// 			// $.each(data.events, function(key, val){
	// 			// 	$(place).append("<option value='"+key+"'>"+val+"</option>");
	// 			// });
	// 			return false;
	// 		},
	// 		error: function(e){
	// 			console.log(e.responseText);
	// 			return false;
	// 		}
	// 	});/* end of ajax */
	// });

	$(document).on('click', '#HPCBBtn', function(){
		var pval = $('#HPCBSproducts').val();
		if(pval.length > 3){
			alert('Maximum product allowed 3.'); 
			return false;
		}
	});

	$('#pro_gallerybtn').on('click', function(){ $('#pro_galleryfile').trigger('click'); });

	$(document).on('click', '.removeimg', function(){ $(this).parent().remove(); });

	$('#pro_galleryfile').fileupload({
	    url: '/imageuploadwiththumbnail',
	    headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
	    dataType: 'json',
	    formData: { path:'' },
	    done: function (e, data) {
	    	console.log(data);
	        var baseurl = document.location.origin;
	        var src = baseurl+'/'+data.result.files[0].url;
	        var thumbsrc = baseurl+'/'+data.result.files[0].thumbnailUrl;
	         var thumb1src = baseurl+'/'+data.result.files[0].thumbnail1Url;
	         console.log(data);
	         console.log('imgae uplaod');
	         console.log(thumb1src);
	        $('#pro_galleryimgbox').append('<li><button class="btn ink-reaction btn-icon-toggle btn-primary removeimg" type="button"><i class="fa fa-close"></i></button><img src="'+src+'"><input type="hidden" name="pro_galleryimage[]" value="'+src+'"><input type="hidden" name="pro_gallerythumbimage[]" value="'+thumbsrc+'"><input type="hidden" name="pro_gallerythumb1image[]" value="'+thumb1src+'"></li>'); 
	        $('#hiddenimgbox').append('');
	        console.log(src);
	    },
	    progressall: function (e, data) {
	        $('#pro_galleryprogressbox').show();
	        var progress = parseInt(data.loaded / data.total * 100, 10);
	        $('#pro_galleryprogress').css(
	            'width',
	            progress + '%'
	        ).text(progress+'%');
	        if(progress == 100){ closeprogress();  }
	    },error: function(e){
	      console.log(e.responseText);
	    }
	}).prop('disabled', !$.support.fileInput)
	.parent().addClass($.support.fileInput ? undefined : 'disabled');

	function closeprogress(){
		setTimeout(function(){ $('.progress').next().css('width','0%').text(''); $('.progress').hide(); }, 1000);
	}

	$(document).on('click', '.removeimg', function(){
		var current = $(this) ;
		var ID = current.attr("data-id");
		
		$.ajax({
			type: "POST",
			url: "/admin/gallery/modify/delete/image",
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
			data: {ID:ID},
			dataType: "json",
			success: function(data){
				current.parent().remove();
				return false;
			},
			error: function(e){
				console.log(e.responseText);
				return false;
			}
		});/* end of ajax */ 
	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/storefront/homePage.blade.php ENDPATH**/ ?>