<?php 
	use App\Models\CustomPages; 
	use App\Models\Option; 
?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active"><?php echo CustomPages::getcontent("ourFacilitiesPageTitle"); ?></li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary"><?php echo CustomPages::getcontent("ourFacilitiesPageTitle"); ?></h1>
					</div><!--end .col -->
					
					<div class="clearfix"></div>
					<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

					<div class="col-lg-12 col-md-12">
						<?php echo Form::open(["url"=>"admin/pages/aboutus/post","class"=>"form","enctype"=>"multipart/form-data","files"=>true]); ?>

							<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-8 col-lg-8">
							                <div class="form-group <?php if($errors->has('ourFacilitiesPageTitle')): ?>has-error <?php endif; ?>">
												<?php echo Form::text("ourFacilitiesPageTitle",CustomPages::getcontent("ourFacilitiesPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]); ?>

												<?php if($errors->has("ourFacilitiesPageTitle")): ?>
													<span id="ourFacilitiesPageTitle-error" class="help-block"><?php echo $errors->first("ourFacilitiesPageTitle"); ?></span>
												<?php endif; ?>
												<?php echo HTML::decode(Form::label("ourFacilitiesPageTitle","Page Title <span class='text-danger'>*</span>")); ?>

											</div>
						                </div>

						                <div class="col-md-4 col-lg-4 brd-left">
						                  	<div class="text-right">
						                    	<?php echo Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary']); ?>

						                    	<?php
						                    		$data = CustomPages::where("fieldName", "ourFacilitiesPageTitle")->first();
						                    	?>
					                    		<?php if($data): ?>
					                    			<p><b>Last Modified:</b>  <?php echo strtoupper($data->updatedByName); ?> (<?php echo date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)); ?>)</p>
					                    		<?php endif; ?>
						                      
						                  	</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-12 col-lg-12">
							                <div class="form-group <?php if($errors->has('ourFacilitiesDescription')): ?>has-error <?php endif; ?>">
												<?php echo Form::textarea("ourFacilitiesDescription",CustomPages::getcontent("ourFacilitiesDescription"),["class"=>"form-control","placeholder"=>"enter about short description","rows"=>"4"]); ?>

													<?php if($errors->has("ourFacilitiesDescription")): ?>
													<span id="ourFacilitiesDescription-error" class="help-block"><?php echo $errors->first("ourFacilitiesDescription"); ?></span>
													<?php endif; ?>
												<?php echo HTML::decode(Form::label("ourFacilitiesDescription","Short Description <span class='text-danger'>*</span>")); ?>

											</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>
				        <?php echo Form::close(); ?>

					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
	<?php echo HTML::script('backend/js/bala.js'); ?>

	<?php echo HTML::script('backend/ckeditor/ckeditor.js'); ?>

	<script type="text/javascript">
	    CKEDITOR.replace('ourFacilitiesDescription');
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/about/ourFacilities.blade.php ENDPATH**/ ?>