<?php
	use App\Models\Option;
	use App\Models\GalleryCategories;
?>

<?php $__env->startSection('styles'); ?>
	<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css'); ?>

	<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css'); ?>

	<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('maincontent'); ?>
	<div>
		<!-- BEGIN CONTENT-->
		<div id="content">
			<section class="style-default-bright">
				<div class="section-header ">
					<ol class="breadcrumb">
						<li class="active">Home</li>
						<li class="active">Gallery</li>
					</ol>
				</div>

				<div class="section-header">
					<div class="row">
						<div class="col-lg-6">
							<h2 class="text-primary">Gallery</h2>
						</div>

						<div class="col-lg-6">
							<?php echo HTML::link("admin/gallery/add/get", "Add New Gallery", ["class"=>"btn ink-reaction pull-right btn-primary"]); ?>

						</div>
					</div>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="col-lg-12">
							<div class="table-responsive">
								<table id="myTable" class="table table-striped table-hover">
									<thead>
										<tr>
											<th>#</th>
											<th>Title</th>
											<th>Category</th>
											<th>Created By</th>
											<th>Created On</th>
											<th class="sort-numeric">Status</th>
											<th class="sort-alpha">Actions</th>
										</tr>
									</thead>

									<tbody>
										<?php $i = 1; ?>
										<?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php
												$id = Crypt::encrypt($gallery->id);
											?>
											<tr class="gradeX">
												<td><?php echo $i; ?></td>
												<td><?php echo $gallery->galleryTitle; ?></td>
												<td><?php echo GalleryCategories::getcategoryname($gallery->galleryCategoryID); ?></td>
												<td><?php echo ucwords($gallery->createdByName); ?></td>
												<td><?php echo date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($gallery->created_at)); ?></td>
												<?php
													$gallery->status == "active" ? $class = "success" : $class = "danger";
												?>
												<td><button type="button" class="btn ink-reaction btn-xs btn-<?php echo $class; ?> galleryStatus" data-id="<?php echo $id; ?>"><?php echo ucfirst($gallery->status); ?></button></td>
												<td>
													<a href="<?php echo URL::to('admin/gallery/modify/'.$gallery->gallerySlug."/".$id); ?>" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Modify Gallery" data-id="<?php echo $id; ?>"><i class="fa fa-pencil"></i>
													</a>
													<button type="button" class="btn btn-icon-toggle galleryDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="<?php echo $id; ?>"><i class="fa fa-trash-o"></i></button>
												</td>
											</tr>
											<?php $i++; ?>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tbody>
								</table>
							</div><!--end .table-responsive -->
						</div><!--end .col -->
					</div><!--end .row -->
					<!-- END DATATABLE 1 -->
				</div><!--end .section-body -->
			</section>
		</div><!--end #content-->
		<!-- END CONTENT -->
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	<?php echo HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js'); ?>

	<?php echo HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js'); ?>

	<script>
		$(document).ready(function(){
	    	$('#myTable').DataTable();
		});

		$(document).on("click", ".galleryStatus", function(){
			var clicked = $(this);
			var id = clicked.attr("data-id");
			$("#processingIcon").remove();
			swal({
		        title: "Are you sure?",
		        text: "Do you really want to change this gallery status?",
		        type: "warning",
		        showCancelButton: true,
		        confirmButtonColor: "#EE2C47",
		        confirmButtonText: "Yes",
		        cancelButtonText: "No",
		        closeOnConfirm: true,
		        closeOnCancel: true
		    },
		    function(isConfirm){
		    	if(!isConfirm){
		    		return false;
		    	}

		        clicked.after('<span id="processingIcon" style="color:#399bff"><i class="fa fa-circle-o-notch fa-spin"></i></span>');

				$.ajax({
					type: "POST",
					url:  "/admin/gallery/status/post",
					headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
					data: {id:id},
					dataType: "json",
					success: function(data){
						console.log(data);
						var colour = "";
						if(data.status == "success"){
							data.current == "Inactive" ? colour = "btn-danger" : colour = "btn-success";
							clicked.text(data.current);
							clicked.removeClass("btn-success btn-danger").addClass(colour);
							$("#processingIcon").remove();
							swal("Changed!", "This gallery's status changed to "+data.current, "success");
							success_msg(data.msg);
						}
						return false;
					},
					error: function(e){
						console.log(e.responseText);
						return false;
					}
				});/* end of ajax */
			});/* end of confirm function */
			return false;
		});/* end of click function */

		$(document).on("click", ".galleryDelete", function(){
			var clicked = $(this);
			var id = clicked.attr("data-id");
			$("#processingIcon").remove();
			swal({
	            title: "Are you sure?",
	            text: "Do you really want to delete this gallery?",
	            type: "warning",
	            showCancelButton: true,
	            confirmButtonColor: "#EE2C47",
	            confirmButtonText: "Yes",
	            cancelButtonText: "No",
	            closeOnConfirm: true,
	            closeOnCancel: true
        	},
	        function(isConfirm){
	        	if(!isConfirm){
	        		return false;
	        	}
            	clicked.after('<span id="processingIcon" style="color:#399bff"><i class="fa fa-circle-o-notch fa-spin"></i></span>');

				$.ajax({
					type: "POST",
					url:  "/admin/gallery/delete/post",
					headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
					data: {id:id},
					dataType: "json",
					success: function(data){
						console.log(data);
						var colour="";
						if(data.status == "success"){
							clicked.closest("tr").hide();
							success_msg(data.msg);
							$("#processingIcon").remove();
							swal("Deleted!!!", "This gallery deleted successfully!!!", "success");
						}
						return false;
					},
					error: function(e){
						console.log(e.responseText);
						swal("Error", "Error processing your request", "error");
						return false;
					}
				});/* end of ajax */
			});/* end of confirm function */
			return false;
		});/* end of click function */
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/gallery/gallery.blade.php ENDPATH**/ ?>