	<?php
		use App\Models\Customfieldmeta;
	?>
	<ul id="sortable">
		<?php $__currentLoopData = $custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fields): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<li data-id="<?php echo e(encrypt($fields->id)); ?>">
			<?php if($fields->field_type == 'plain_text'): ?>
				<div class="form-group">
					<input type="text" class="form-control" id="<?php echo e($fields->field_slug); ?>" name="<?php echo e($fields->field_slug); ?>" value="<?php echo e($fields->field_value); ?>">
					<label><?php echo e($fields->label_name); ?> <?php if($fields->is_required == 'yes'): ?> <span class='text-danger'>*</span> <?php endif; ?></label>
				</div>
			<?php endif; ?>

			<?php if($fields->field_type == 'datepicker'): ?>
				<div class="form-group">
					<input type="text" readonly="" class="form-control custom_fields_date" name="<?php echo e($fields->field_slug); ?>" id="<?php echo e($fields->field_slug); ?>" value="<?php echo e($fields->field_value); ?>">
					<label><?php echo e($fields->label_name); ?> <?php if($fields->is_required == 'yes'): ?> <span class='text-danger'>*</span> <?php endif; ?></label>
				</div>
			<?php endif; ?>

			<?php if($fields->field_type == 'dateandtime'): ?>
				<div class="form-group">
					<input type="text" readonly="" class="form-control custom_fields_datetime" name="<?php echo e($fields->field_slug); ?>" id="<?php echo e($fields->field_slug); ?>" value="<?php echo e($fields->field_value); ?>">
					<label><?php echo e($fields->label_name); ?> <?php if($fields->is_required == 'yes'): ?> <span class='text-danger'>*</span> <?php endif; ?></label>
				</div>
			<?php endif; ?>

			<?php if($fields->field_type == 'single_file_upload'): ?>
				<div class="form-group">
					<input type="file" class="form-control" name="<?php echo e($fields->field_slug); ?>" id="<?php echo e($fields->field_slug); ?>">
					<label><?php echo e($fields->label_name); ?> <?php if($fields->is_required == 'yes'): ?> <span class='text-danger'>*</span> <?php endif; ?></label>
				</div>
				<?php if($fields->field_value != ''): ?>
					<div class="form-group">
						<a href="<?php echo e(asset($fields->field_value)); ?>" target="_blank" style="color: green;"><?php echo e($fields->extra_field); ?> <i class="fa fa-file"></i></a>
						<a href="javascript:;" class="removeCustomFieldFile" data-field="single" data-id="<?php echo e(encrypt($fields->id)); ?>" style="color: red;"><i class="fa fa-trash"></i></a>
						<label>Preview</label>
					</div>
				<?php endif; ?>
			<?php endif; ?>

			<?php if($fields->field_type == 'multiple_file_upload'): ?>
				<div class="form-group">
					<input type="file" class="form-control" name="<?php echo e($fields->field_slug); ?>[]" id="<?php echo e($fields->field_slug); ?>" multiple="">
					<label><?php echo e($fields->label_name); ?> <?php if($fields->is_required == 'yes'): ?> <span class='text-danger'>*</span> <?php endif; ?></label>
				</div>
				<?php
					$metadata = Customfieldmeta::where('custom_field_id',$fields->id)->get();
				?>
				<?php if(count($metadata) != 0): ?>
					<div class="form-group">
						<label>Preview</label>
						
						<ul>
							<?php $__currentLoopData = $metadata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<li>
									<a href="<?php echo e(asset($meta->field_value)); ?>" target="_blank" style="color: green;"><?php echo e($meta->extra_field); ?> <i class="fa fa-file"></i></a>
									<a href="javascript:;" class="removeCustomFieldFile" data-field="multiple" data-id="<?php echo e(encrypt($meta->id)); ?>" style="color: red;"><i class="fa fa-trash"></i></a>
								</li>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</ul>
					</div>
				<?php endif; ?>
			<?php endif; ?>
			<a href="javascript:;" class="removeCustomField" data-id="<?php echo e(encrypt($fields->id)); ?>" style="color:red;"><i class="fa fa-trash"></i> Remove Field</a>
			</li>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</ul>
	<?php if(count($custom_fields) == 0): ?>
		<b>No fields found</b>
	<?php else: ?>
		<input type="hidden" name="eventHiddenId" id="eventHiddenId" value="<?php echo e($eventId); ?>">
		<div class="form-group">
	        <button type="submit" id="customEventDataBtn" class="btn btn-sm btn-primary pull-right">Update</button> &nbsp;
	    </div>
	<?php endif; ?>
<?php /**PATH /home/adclubmadras/public_html/resources/views/backend/events/eventInfoTemplate.blade.php ENDPATH**/ ?>