<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>


<?php $__env->startSection('styles'); ?>
	<?php echo HTML::style('backend/assets/css/jquery-ui.css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content" ng-app="AdclubMadras" ng-controller="paymentReportController">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li>Reports</li>
					<li>Payments</li>
				</ol>
			</div>

			<div id="exclUploadDiv">
		      	<div class="card">
		        	<div class="card-body">
		          		<div class="row">
		            		<?php echo Form::open(["name"=>"paymentsReportSearchForm"]); ?>

		            			<div class="col-lg-3">
		              				<?php echo Form::text("dateFrom","",["class"=>"form-control","id"=>"dateFrom","placeholder"=>"From Date","ng-model"=>"params.dateFrom"]); ?>

					              	<?php if($errors->has("dateFrom")): ?>
										<span id="dateFrom-error" class="help-block"><?php echo $errors->first("dateFrom"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="col-lg-3">
		              				<?php echo Form::text("dateTo","",["class"=>"form-control","id"=>"dateTo","placeholder"=>"To Date","ng-model"=>"params.dateTo"]); ?>

					              	<?php if($errors->has("dateTo")): ?>
										<span id="dateTo-error" class="help-block"><?php echo $errors->first("dateTo"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="col-lg-3">
		              				<?php echo Form::text("orderID","",["class"=>"form-control","id"=>"orderID","placeholder"=>"Order ID","ng-model"=>"params.orderID"]); ?>

					              	<?php if($errors->has("orderID")): ?>
										<span id="orderID-error" class="help-block"><?php echo $errors->first("orderID"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="col-lg-3">
		              				<select ui-select2="{ allowClear: true}" ng-model="params.paymentStatus" data-placeholder="Select Payment Status">
		              					<option value=""></option>
									    <option value="Success">Success</option>
									    <option value="Failure">Failure</option>
									    <option value="Aborted">Aborted</option>
									</select>

					              	<?php if($errors->has("paymentStatus")): ?>
										<span id="paymentStatus-error" class="help-block"><?php echo $errors->first("paymentStatus"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="clearfix"></div>	
		            			<br>
		            			
					            <div class="col-lg-2">
					                <input type="submit" class="btn ink-reaction btn-success" ng-click="paymentReportSearchClick($event)" value="Search">
									
					                <input type="reset" class="btn ink-reaction btn-danger" value="Reset">
					            </div>
		            		<?php echo Form::close(); ?>

		          		</div>
		        	</div>
		      	</div>
		  	</div>

		  	<div class="clearfix"></div>

  			<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

  			<div class="processLoadingDiv" style='display:none'>
		        <div class="spinner">
				  <div class="bounce1"></div>
				  <div class="bounce2"></div>
				  <div class="bounce3"></div>
				</div>
		        <p class="text-center">Processing.... Please wait...</p>
		    </div>

			<section id="paymentReportsTable" style="display:none">

				<div class="section-header">
					<div class="row">
						<div class="col-lg-6">
							<h2 class="text-primary">Members Applied</h2>
						</div>

						<div class="col-lg-6">
							<button type="button" class="btn ink-reaction btn-sm btn-primary pull-right" ng-click="downloadExcelClick()">Download Excel</button>
						</div>
					</div>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="col-lg-12">
							<div class="table-responsive">
								<div style="float: left;"><b>Shows</b> &nbsp;&nbsp;
									<select ng-model="recordLimit"  ng-init="recordLimit=10" ng-options="item for item in recordArray">
									</select>
								</div>

								<div style="float: right;"><b>Search</b> &nbsp;&nbsp;<input type="text" ng-model="filterSearch"></div>

								<table id="myTable" class="table table-striped table-hover">
									<thead>
										<tr>
											<th ng-click="sort('sno')">#</th>
											<th ng-click="sort('order_id')">Order ID</th>
											<th ng-click="sort('tracking_id')">Tracking ID</th>
											<th ng-click="sort('billing_name')">Name</th>
											<th ng-click="sort('billing_email')">Email</th>
											<th ng-click="sort('order_status')">Payment Status</th>
											<th ng-click="sort('payment_mode')">Payment Mode</th>
											<th ng-click="sort('amount')">Amount (Rs.)</th>
											<th ng-click="sort('merchant_param1')">Type</th>
											<th ng-click="sort('trans_date')">Payment Date</th>
										</tr>
									</thead>

									<tbody>
										<tr dir-paginate="rec in records |orderBy:sortKey:reverse | filter: filterSearch|itemsPerPage:recordLimit">
											<td>{{ rec.sNo }}</td>
											<td>{{ rec.order_id }}</td>
											<td>{{ rec.tracking_id }}</td>
											<td>{{ rec.billing_name|capitalize }}</td>
											<td>{{ rec.billing_email }}</td>
											<td>
												<button ng-if="rec.order_status == 'Success'" type="button" class="btn ink-reaction btn-xs btn-success">{{ rec.order_status }}</button>

												<button ng-if="rec.order_status == 'Failure'" type="button" class="btn ink-reaction btn-xs btn-danger">{{ rec.order_status }}</button>

												<button ng-if="rec.order_status == 'Aborted'" type="button" class="btn ink-reaction btn-xs btn-warning">{{ rec.order_status }}</button>

												<button ng-if="rec.order_status == ''" type="button" class="btn ink-reaction btn-xs btn-primary">Invalid</button>
											</td>
											<td>{{ rec.payment_mode }}</td>
											<td>{{ rec.amount }}</td>
											<td>{{ rec.merchant_param1 }}</td>
											<td>{{ rec.trans_date }}</td>
										</tr>
									</tbody>
								</table>

								<dir-pagination-controls
							       max-size="10"
							       direction-links="true"
							       boundary-links="true" >
							    </dir-pagination-controls>
							</div><!--end .table-responsive -->
						</div><!--end .col -->
					</div><!--end .row -->
					<!-- END DATATABLE 1 -->
				</div><!--end .section-body -->
			</section>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	<?php echo HTML::script('backend/js/angular.min.js'); ?>

  	<?php echo HTML::script('backend/js/dirPagination.js'); ?>

  	<?php echo HTML::script('backend/assets/js/jquery-ui.js'); ?>

  	<?php echo HTML::script('backend/js/angular-select2.min.js'); ?>

	<script>
		$(document).ready(function(){
	    	$("#dateFrom").datepicker({
		      	changeMonth: false,
		      	dateFormat:'yy-mm-dd',
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$("#dateTo").datepicker( "option", "minDate", selectedDate );
		      	}
		    });

		    $( "#dateTo" ).datepicker({
		      	dateFormat:'yy-mm-dd',
		      	changeMonth: false,
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$( "#dateFrom" ).datepicker( "option", "maxDate", selectedDate );
		      	}
		    });
		});/* end of ready function */

		var app = angular.module('AdclubMadras',['angularUtils.directives.dirPagination', 'ui.select2']);
		app.controller('paymentReportController', function($timeout, $scope, $http){
			
			// $timeout(function(){
			// 	$scope.paymentReportSearchClick();
			// },500);

			$scope.params = {};
	        $scope.params.dateFrom = '';
	        $scope.params.dateTo = '';
	        $scope.params.orderID = '';
	        $scope.params.paymentStatus = '';
	      
			$scope.paymentReportSearchClick = function(event) {
				event.preventDefault();
				angular.element(document.querySelector('.processLoadingDiv')).show();
				angular.element(document.querySelector('#paymentReportsTable')).hide();
				angular.element(document.querySelector('#displayError')).hide();
				$scope.records = [];
				$scope.recordArray = [10, 25, 50, 100];
				$http({
		          	method  : 'POST',
		          	url     : '/admin/reports/payment/post',
		          	data    : $scope.params,
		        }).success(function(data){
		         	console.log(data);
		         	$scope.originaldata = data;
					$scope.datalength = $scope.originaldata.length;

					if($scope.datalength > 0){
						for(var i = 0; i < $scope.originaldata.length; i++){
							var sNo = i + 1;
							// var type = $scope.originaldata[i].merchant_param1;

							// if(type == "members"){
							// 	type = "New Registration";
							// }else if(type == "editMembers"){
							// 	type = "Renewal";
							// }else if(type == "maddysregistration"){
							// 	type = "Maddys 2017 Registration";
							// }else if(type == "maddysentryticket"){
							// 	type = "Maddys Entry Ticket 2017";
							// }

							$scope.originaldata[i].sNo = sNo;
							//$scope.originaldata[i].type = type;
							$scope.records.push($scope.originaldata[i]);
						}
						angular.element(document.querySelector('.processLoadingDiv')).hide();
						angular.element(document.querySelector('#paymentReportsTable')).show();
					}else{
						angular.element(document.querySelector('.processLoadingDiv')).hide();
						angular.element(document.querySelector('#paymentReportsTable')).hide();
		         		swal("No Records!", "No Records Found", "info");
		         		return false;
					}
				}).error(function(e){
		         	console.log(e.responseText);;
		         	swal("Error!", "Error processing your request", "error");
		         	return false;
				});
			}

			$scope.sort = function(keyname){
		        $scope.sortKey = keyname;   //set the sortKey to the param passed
		        $scope.reverse = !$scope.reverse; //if true make it false and vice versa
		    }

		    $scope.downloadExcelClick = function(){
		    	$scope.params.URL = "/admin/reports/payment/excel/get";

		    	$scope.params.URL = $scope.params.URL+'?';

		    	if($scope.params.dateFrom != ""){
		    		$scope.params.URL = $scope.params.URL+'from='+$scope.params.dateFrom+"&&";
		    	}

		    	if($scope.params.dateTo != ""){
		    		$scope.params.URL = $scope.params.URL+'to='+$scope.params.dateTo+"&&";
		    	}

		    	if($scope.params.orderID != ""){
		    		$scope.params.URL = $scope.params.URL+'order='+$scope.params.orderID+"&&";
		    	}

		    	if($scope.params.paymentStatus != ""){
		    		$scope.params.URL = $scope.params.URL+'status='+$scope.params.paymentStatus+"&&";
		    	}

		        var win = window.open($scope.params.URL);
		        win.focus();
		    }
		});

		app.filter('capitalize', function() {
		    return function(input) {
		      return (!!input) ? input.charAt(0).toUpperCase() + input.substr(1).toLowerCase() : '';
		    }
		});

		app.filter('secondsToDateTime', function() {
		    return function(seconds) {
		        var d = new Date(0,0,0,0,0,0,0);
		        d.setSeconds(seconds);
		        return d;
		    };
		});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/reports/payment.blade.php ENDPATH**/ ?>