<?php 

	use App\Models\User;

	use App\Models\Option; 

?>





<?php $__env->startSection('styles'); ?>

<style type="text/css">

	table.nominee-members .input-lg {

		margin-bottom: 0;

	}



</style>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('maincontent'); ?>

	<!-- BEGIN CONTENT-->

	<div id="content">

		<section>

			<div class="section-header ">

				<ol class="breadcrumb">

					<li class="active">Home</li>

					<li class="active">Members</li>

					<li>Add Individual Members</li>

				</ol>

			</div>



			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->

				<?php echo Form::open(["url"=>"admin/members/corporate/add/post"]); ?>


					<div class="row">

						<div class="col-lg-12">

							<h1 class="text-primary">Add Individual Members</h1>

						</div><!--end .col -->



						<div class="col-lg-3 col-md-3">

							<div class="section-header">

								<?php echo HTML::link("admin/members/individual/get", "Manage Individual Members", ["class"=>"btn ink-reaction btn-block btn-primary"]); ?>


							</div>



							<div class="card">

								<div class="card-head style-primary">

									<header>Sort By Alphabet</header>

								</div><!--end .card-head -->



								<div class="card-body small-padding height-8" style="overflow: scroll;">

									<ul data-sortable="true" class="list">

										<?php

											$alphabet = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'); 

										?>



										<?php $__currentLoopData = $alphabet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

											

											<li class="tile">

												<div class="radio radio-styled">

													<label>

														<input type="radio" name="sortByAlphabet" value="<?php echo $val; ?>" class="galleryCategories">

														<span><?php echo $val; ?></span>

													</label>

												</div>

											</li>

										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!-- 1-->			

									</ul>

								</div>

							</div><!--end .card -->

						</div><!--end .col -->



						<div class="col-md-9">

							<div class="card">

								<div class="card-head style-primary">

									<header>Add Individual Members</header>

								</div>



								<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>



								<?php if(Session::has('warnings')): ?> <?php echo HTML::display_error('warnings'); ?> <?php endif; ?>



								<?php if(Session::has('error')): ?> <?php echo HTML::display_error('error'); ?> <?php endif; ?>



								<div class="card-body">

									<div class="row">

										<div class="col-md-12">

						                    <?php

						                        $corporateAmount = Option::getvalue('corporate');

						                        $IndividualAmount = Option::getvalue('individual');

						                        $studentAmount = Option::getvalue('student');

						                        $currentServiceTax = Option::getvalue('GST'); 



						                        //corporate

						                        $corpPayable = $corporateAmount / 100;

						                        $finalCorporateCost = ceil($corporateAmount + ($corpPayable*$currentServiceTax));



						                        //individual

						                        $indiPayable = $IndividualAmount / 100;

						                        $finalIndividualCost = ceil($IndividualAmount + ($indiPayable*$currentServiceTax));



						                        //student

						                        $studPayable = $studentAmount / 100;

						                        $finalStudentCost = ceil($studentAmount + ($studPayable*$currentServiceTax));

						                    ?>



					                    

					                        <div><label>Category of Membership: <span class="req"></span></label></div>

					                        <div class="row">

					                            <div class="col-md-4 col-sm-4">

					                            	<div class="radio radio-styled">

														<label>

															<input type="radio" name="category" value="individual" class="radiobut" id="individual" checked="checked">

															<span>Individual</span>

														</label>

													</div>

					                            </div>



					                            <div class="col-md-4 col-sm-4">

					                                <div class="radio radio-styled">

														<label>

															<input type="radio" name="category" value="student" class="radiobut" id="student">

															<span>Student</span>

														</label>

													</div>

					                            </div>

					                        </div><!--end row-->



				                        	<div id="indi">

					                            <div class="row">

					                                <div class="col-md-6 col-sm-6">

				                                    	<label><span id="stu_name">Name of the Individual</span> <span class="req">*</span></label>



					                                    <input type="text" id="companyname_i" name="companyname_i" class="form-control input-lg" value=""/>

					                                    <?php if($errors->has("companyname_i")): ?>

					                                        <span class="req"><?php echo $errors->first("companyname_i"); ?></span>

					                                    <?php endif; ?>

					                                </div>



					                                <div class="col-md-6 col-sm-6">

				                                    	<label>Contact Person <span class="req">*</span></label>



				                                    	<input type="text" id="contactperson_i" name="contactperson_i" class="form-control input-lg" value=""/>

				                                    	<?php if($errors->has("contactperson_i")): ?>

					                                        <span class="req"><?php echo $errors->first("contactperson_i"); ?></span>

					                                    <?php endif; ?>

					                                </div>

					                            </div>



					                            <div class="row">

					                                <div class="col-md-6 col-sm-6">

					                                    <label>Address <span class="req">*</span></label>

					                                    <textarea class="form-control input-lg" id="address1_i" name="address1_i" style="min-height:134px"></textarea>

					                                    <?php if($errors->has("address1_i")): ?>

					                                        <span class="req"><?php echo $errors->first("address1_i"); ?></span>

					                                    <?php endif; ?>

					                                </div>



					                                <div class="col-md-3 col-sm-6">

					                                    <label>Telephone</label>

					                                    <input type="text" id="phoneno_i" name="phoneno_i" class="form-control input-lg" value=""/>

					                                </div>



					                                <div class="col-md-3 col-sm-6">

					                                    <label>Mobile Number <span class="req">*</span></label>

					                                    <input type="text" id="mobileno_i" name="mobileno_i" class="form-control input-lg" placeholder="Enter valid Mobile Number" value=""/>

					                                    <?php if($errors->has("mobileno_i")): ?>

					                                        <span class="req"><?php echo $errors->first("mobileno_i"); ?></span>

					                                    <?php endif; ?>

					                                </div>



					                                <div class="col-md-6 col-sm-6">

					                                    <label>Email ID <span class="req">*</span></label>

					                                    <input type="email" id="emailid_i" name="emailid_i" class="form-control input-lg" placeholder="Enter valid Email Address" value=""/>

					                                    <?php if($errors->has("emailid_i")): ?>

					                                        <span class="req"><?php echo $errors->first("emailid_i"); ?></span>

					                                    <?php endif; ?>

					                                </div>

					                            </div>



					                            



					                            <div><label>Social Profile Links:</label></div>

					                            <div class="row">

					                                <div class="col-md-4 col-sm-12">

					                                    <label>Facebook</label>

					                                    <input type="url" id="fb_i" name="fb_i" class="form-control input-lg" placeholder="Facebook URL" value=""/>

					                                </div>



					                                <div class="col-md-4 col-sm-12">

					                                    <label>Twitter</label>

					                                    <input type="url" id="twi_i" name="twi_i" class="form-control input-lg" placeholder="Twitter URL" value=""/>

					                                </div>



					                                <div class="col-md-4 col-sm-12">

					                                    <label>Linkedin</label>

					                                    <input type="url" id="ln_i" name="ln_i" class="form-control input-lg" placeholder="Linkedin URL" value=""/>

					                                </div>

					                            </div>



					                            <div class="spacer-30"></div>



					                            <div class="clearfix">

					                            	<br>

					                                <button type="submit" id="individuals" name="individuals" class="btn ink-reaction btn-primary">Submit</button>

					                            </div>

				                        	</div>

                						</div>

									</div><!--end row-->

								</div><!--end card-body-->

							</div><!--end card-->

						</div><!--end col-md-10-->

					</div>

				<?php echo Form::close(); ?>


			</div>

		</section>

	</div>

<?php $__env->stopSection(); ?>





<?php $__env->startSection('script'); ?>

	<script> 

        $(document).on('click', '.radiobut', function() {

            var id = $(this).attr('id');

            if(id == 'category') {

                $('#indi').hide();

                $('#cate').show();

                $('#bot_corp').show();

                $('.individualmsg').hide();

                $('.studentmsg').hide();

            } else {

                $('#cate').hide();

                $('#indi').show();

                $('.corporatemsg').hide();

                if(id == "individual"){

                    $('#stu_name').html('Name of the Individual');

                    $('#stu_insi').html('Name of the working company');

                    $('#bot_indi').show();

                    $('#bot_stu').hide();

                    $('.studentmsg').hide();

                    var indi_amn = "<?php echo Option::getvalue('individual'); ?>";

                    var re_ind_amn = indi_amn / 100;

                    var ind_ser_tx = "<?php echo Option::getvalue('GST'); ?>";

                    var indi_tax_amn = re_ind_amn * ind_ser_tx;

                    var fin_ind_amn = Math.ceil(parseInt(indi_amn) + parseInt(indi_tax_amn));

                    $('#indi_amount').text(fin_ind_amn);

                    $('.indi_amount').val(fin_ind_amn);

                } else{

                    $('#stu_name').html('Name of the Student');

                    $('#stu_insi').html('Name of the Institution');

                    $('#bot_stu').show();

                    $('#bot_indi').hide();

                    $('.individualmsg').hide();

                    var stud_amn = "<?php echo Option::getvalue('student'); ?>";

                    var re_stud_amn = stud_amn / 100;

                    var stu_ser_tx = "<?php echo Option::getvalue('GST'); ?>";

                    var stu_tax_amn = re_stud_amn * stu_ser_tx;

                    var fin_stud_amn = Math.ceil(parseInt(stud_amn) + parseInt(stu_tax_amn));

                    $('#stu_amount').html(fin_stud_amn);

                    $('.stu_amount').val(fin_stud_amn);

                }

            }

        });



        $(document).on('click', '#addNew', function(){

            var tot_mem = $('#tot_mem').val();

            var num = $('.member_nominated').length;

            var i = 0;

            var result = "yes";

            for(i = 0; i < num; i++){        

                var name = $('#name'+i).val();

                var designation = $('#designation'+i).val();

                var email = $('#email'+i).val();

                var mobile = $('#mobile'+i).val();

                if(name == ''){

                   swal('Mandatory', 'Please fill the required fields', 'info');

                   return false;

                } else {

                    result = "yes";

                }

            }



            if(result == "yes"){ 

                swal({

                    title: "Are you sure?",

                    text: "After five nominees, every additional nominee will be payable sum of rupees 690 (Including Service Tax) Would you like to proceed?",

                    type: "warning",

                    showCancelButton: true,

		            confirmButtonColor: "#EE2C47",

		            confirmButtonText: "Yes",

		            cancelButtonText: "No",

		            closeOnConfirm: true,

		            closeOnCancel: true

                },

                function(isConfirm){

                    if(!isConfirm){

	              		return false;

	            	}



                    var req_num = parseInt(num) + 1;

                    $('#tot_mem').val(req_num);

           

                    //Append code

                    var req_code = '<div class="maindiv_members'+num+'"><h4 class="accent-color margin-5 member_nominated  members_'+num+'"><b><span class="title'+num+'">Member '+req_num+'</span></b>';

                    req_code += '<span class="pull-right remove-member"><a class="remove_member remove_member'+num+'" id="'+num+'" href="javascript:void(0)">Remove this member &nbsp;<i class="fa fa-minus-circle"></i></a></span></h4>';

                            

                    req_code += '<table class="table table-bordered nominee-members">';

                    req_code += '<thead>';

                    req_code += '<tr>';

                    req_code += '<th><b>Name</b></th>';

                    req_code += '<th><b>Designation</b></th>';

                    req_code += '<th><b>Email ID</b></th>';

                    req_code += '<th><b>Mobile No.</b></th>';

                    req_code += '</tr>';

                    req_code += '</thead>';



                    req_code += '<tbody>';

                    req_code += '<tr>';

                    req_code += '<td><input type="text" id="name'+num+'" name="name'+num+'" class="form-control input-lg"></td>';

                    req_code += '<td><input type="text" id="designation'+num+'" name="designation'+num+'" class="form-control input-lg"></td>';

                    req_code += '<td><input type="text" id="email'+num+'" name="email'+num+'" class="form-control input-lg"></td>';

                    req_code += '<td><input type="text" id="mobile'+num+'" name="mobile'+num+'" class="form-control input-lg"></td>';

                    req_code += '</tr>';

                    req_code += '</tbody>';

                    req_code += '</table>';

                    req_code += '</div>';



                    $('#addinput').append(req_code);

                    var corpPrice = "<?php echo Option::getvalue('corporate'); ?>";

                    var withouttaxamt = parseFloat(corpPrice) + parseFloat(500 * (req_num - 5));

                    var tax = "<?php echo Option::getvalue('GST'); ?>";

                    var taxamount = (parseFloat(withouttaxamt) * parseFloat(tax)) / 100;

                    var withtax = parseFloat(withouttaxamt) + parseFloat(taxamount);

                    $('#corp_amount').text(Math.ceil(withtax));

                    $('#head_corp_amount').text(Math.ceil(withtax));

                    return false;

                });/* end of .then function */

            } else {

               swall('Mandatory', 'Please fill the required fields', 'info');

               return false;

            }

        });



        $(document).on('click', '.remove_member', function(){

            var tot_mem = $('#tot_mem').val();

            var req_tot_mem = parseInt(tot_mem)-1;

            $('#tot_mem').val(req_tot_mem);

            var id = $(this).attr('id');//5

            var i = 0;

            $('.maindiv_members'+id).remove();

            var req_id = parseInt(id) + 1;//6

            var total_len = $('.member_nominated').length;//7

            if(req_id > total_len){

                var corpPrice = "<?php echo Option::getvalue('corporate'); ?>";

                var withouttaxamt = parseInt(corpPrice) + parseInt(600 * (total_len - 5));

                var tax = "<?php echo Option::getvalue('GST'); ?>";

                var taxamount = (parseFloat(withouttaxamt) * parseFloat(tax)) / 100;

                var withtax = parseFloat(withouttaxamt) + parseFloat(taxamount);

                $('#corp_amount').text(Math.ceil(withtax));

                $('#head_corp_amount').text(Math.ceil(withtax));

                return false;

            } else {

                var substract = parseInt(total_len) - parseInt(id);//2

                for(i = 0; i < substract; i++){

                    $('.maindiv_members'+req_id).addClass('maindiv_members'+id).removeClass('maindiv_members'+req_id);

                    $('.title'+req_id).html('Member '+req_id);

                    $('.members_'+req_id).addClass('members_'+id).removeClass('members_'+req_id);

                    $('.remove_member'+req_id).attr('id',id);

                    $('.remove_member'+req_id).addClass('remove_member'+id).removeClass('remove_member'+id);

                    $('#name'+req_id).attr('name','name'+id);

                    $('#name'+req_id).attr('id','name'+id);

                   

                   $('#designation'+req_id).attr('name','designation'+id);

                   $('#designation'+req_id).attr('id','designation'+id);

                   

                   $('#email'+req_id).attr('name','email'+id);

                   $('#email'+req_id).attr('id','email'+id);

                   

                   $('#mobile'+req_id).attr('name','mobile'+id);

                   $('#mobile'+req_id).attr('id','mobile'+id);

                   id++;

                   req_id++;

                }

               

                //var withouttaxamt = (total_len - 1) * 500;

                var corpPrice = "<?php echo Option::getvalue('corporate'); ?>";

                var withouttaxamt = parseInt(corpPrice) + parseInt(600 * (total_len - 5));

                var tax = "<?php echo Option::getvalue('GST'); ?>";

                var taxamount = (parseFloat(withouttaxamt) * parseFloat(tax)) / 100;

                var withtax = parseFloat(withouttaxamt) + parseFloat(taxamount);

                $('#corp_amount').text(Math.ceil(withtax));

                $('#head_corp_amount').text(Math.ceil(withtax));

            }

        });



        $(document).on("click", "#corp", function(){

            var error = "no";

            $("#validation_cate :input").each(function(){

                var fieldid = $(this).attr('id');

                if(fieldid != 'address2_c' && fieldid != 'phoneno_c'  && fieldid != 'fb_c'  && fieldid != 'twi_c' && fieldid != 'ln_c'){

                    var fieldvalue = $(this).val();

                    if(fieldvalue == '' || fieldvalue == null){

                       $('#'+fieldid).after("<div class='validation_msg' style='color:red; margin-top:-10px'>Don't leave this field empty.</div>");

                       $('html,body').animate({ scrollTop: $('#'+fieldid).offset().top }, 500);

                       error = "yes";

                       return false;

                    }

                }

           

                if(fieldid == 'mobileno_c'){

                   var mob_num = $('#mobileno_c').val();

                    var filter = /^[0-9-+ ]+$/ ;

                    if (!filter.test(mob_num)) {

                        $('#'+fieldid).after("<div class='mobileno_msg' style='color:red; margin-top:-10px'>Please enter valid Mobile number.</div>");

                        $('html,body').animate({ scrollTop: $('#'+fieldid).offset().top }, 500);

                        error = "mobile";

                        return false;

                    }

                }

            });

            

            if(error == "yes"){

                setTimeout(function(){  $(".validation_msg").hide(); }, 3000);

                return false;

            }

            

            if(error==  "mobile"){

                setTimeout(function(){  $(".mobileno_msg").hide(); }, 5000);

                return false;

            }

            

            var num = $('.member_nominated').length;

            for(i = 5; i < num; i++){     

                var name = $('#name'+i).val();

                var designation = $('#designation'+i).val();

                var email = $('#email'+i).val();

                var mobile = $('#mobile'+i).val();

                var j = parseInt(i) + parseInt(1);

                if(name == '' && designation == '' && email == '' && mobile == ''){

                    alert("Please fill the required fields in Member "+j);

                    return false;

                }

            }



            // if(!$("input[name='sortByAlphabet']").is(':checked')){

            //     swal("Please Select", "Please sort members by alphabet", "info");

            //     return false;

            // }  

        });



        $(document).on("click", "#individuals", function(){

            var error = "no";

            $("#indi :input").each(function(){

                var fieldid = $(this).attr('id');

                if(fieldid != 'address2_i' && fieldid != 'phoneno_i'  && fieldid != 'fb_i'  && fieldid != 'twi_i' && fieldid != 'ln_i' && fieldid != 'individuals'){

                    var fieldvalue = $(this).val();

                    if(fieldvalue == '' || fieldvalue == null){

                       $('#'+fieldid).after("<div class='validation_msg' style='color:red; margin-top:-10px'>Don't leave this empty.</div>");

                       $('html,body').animate({ scrollTop: $('#'+fieldid).offset().top }, 500);

                       error = "yes";

                       return false;

                    }

                }

         

                // if(fieldid == 'phoneno_i'){

                //     var ph_num = $('#phoneno_i').val();

                //     var filter = /^[0-9-+ ]+$/ ;

                //     if(!filter.test(ph_num)) {

                //         $('#'+fieldid).after("<div class='phoneno_msg' style='color:red; margin-top:-10px'>Please enter valid Phone number.</div>");

                //         $('html,body').animate({ scrollTop: $('#'+fieldid).offset().top }, 500);

                //         error = "phone";

                //         return false;

                //     }

                // }

          

                if(fieldid == 'mobileno_i'){

                    var mob_num = $('#mobileno_i').val();

                    var filter = /^[0-9-+ ]+$/ ;

                    if (!filter.test(mob_num)) {

                        $('#'+fieldid).after("<div class='mobileno_msg' style='color:red; margin-top:-10px'>Please enter valid Mobile number.</div>");

                        $('html,body').animate({ scrollTop: $('#'+fieldid).offset().top }, 500);

                        error = "mobile";

                        return false;

                    }

                }

            });



            if(error == "yes"){

                setTimeout(function(){  $(".validation_msg").hide(); }, 5000);

                return false;

            }

        

            // if(error == "phone"){

            //     setTimeout(function(){  $(".phoneno_msg").hide(); }, 5000);

            //     return false;

            // }

            

            if(error == "mobile"){

                setTimeout(function(){  $(".mobileno_msg").hide(); }, 5000);

                return false;

            }



            // if(!$("input[name='sortByAlphabet']").is(':checked')){

            //     swal("Please Select", "Please sort members by alphabet", "info");

            //     return false;

            // }     

        });

    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/members/addIndividualMembers.blade.php ENDPATH**/ ?>