
<?php $__env->startSection('content'); ?>
    <div ng-app="AdclubMadras" ng-controller="corporateMembersController">
        <div ng-if="loaded">
          <div class="overlay"></div>
            <div class="modal-loader bg-color1">
                <div class="spinner">
                    <div class="bounce1"></div>
                    <div class="bounce2"></div>
                    <div class="bounce3"></div>
                    <p class="text-center">Processing.... Please wait...</p>
                </div>
            </div>
        </div>

        <div class="hero-area">
            <div class="page-header bg-color1 text-center">
                <div class="container">
                    <h1>Corporate Members</h1>
                    <ol class="breadcrumb">
                        <li><a href="<?php echo URL::to(''); ?>">Home</a></li>
                        <li><a href="<?php echo URL::to('membership'); ?>">Membership</a></li>
                        <li>Corporate Members</li>
                    </ol>
                </div>
            </div>
        </div>

        <div id="main-container">
            <div class="content padding-b40">
                <div class="container">
                    <div class="col-md-12">

                        <div class="row">
                            <div class="col-md-10">
                                <h4 class="inblock" ng-if="params.currentAlphabet=='All'">Displaying All Members ({{ datalength }})</h4>
                                <h4 class="inblock" ng-if="params.currentAlphabet!='All'">Displaying Members from Alphabet <b>{{ params.currentAlphabet }}</b> ({{ datalength }})</h4>
                                <ul class="nav-np hide">
                                    <li><a href="#"><i class="fa fa-angle-left"></i></a></li>
                                    <li><a href="#"><i class="fa fa-angle-right"></i></a></li>
                                </ul>
                            </div>
                            <div class="col-md-2">
                                <select class="form-control" ng-change="sortCorporateMembersByAlphabbet()" ng-model="params.currentAlphabet">
                                    <?php
                                        $alphabet = array('All','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'); 
                                    ?>
                                    <?php $__currentLoopData = $alphabet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo $val; ?>"><?php echo $val; ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="row" id="corporateMembersContainer">
                            <ul class="list-style">
                                <li class="grid-item col-md-3 col-sm-4" ng-repeat="rec in records">
                                    <div class="team-grid-item format-standard">
                                        <div class="grid-item-inner height-4">
                                            <h4>{{ rec.org_name }}</h4>
                                            <p>{{ rec.address }}</p>
                                            <p><i class="fa fa-phone"></i> {{ rec.phone }}<br>
                                            <i class="fa fa-envelope"></i> <a href="mailto:{{ rec.email }}">{{ rec.email }}</a><br>
                                            
                                            <hr class="sm">

                                            <ul class="carets">
                                                <li ng-repeat="name in rec.nominees" ng-if="name != ''">{{ name }}</li>
                                            </ul>

                                            <div class="contact_details">
                                                <ul class="social-icons">
                                                    <li ng-if="rec.facebook != ''"><a href="{{ rec.facebook }}" target="_blank"><i class="fa fa-facebook"></i></a></li>
                                                    <li ng-if="rec.twitter != ''"><a href="{{ rec.twitter }}" target="_blank"><i class="fa fa-twitter"></i></a></li>
                                                    <li ng-if="rec.linkedin != ''"><a href="{{ rec.linkedin }}" target="_blank"><i class="fa fa-linkedin"></i></a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <?php echo HTML::script('backend/js/angular.min.js'); ?>

    <script>
        var app = angular.module('AdclubMadras', []);
    
        app.controller('corporateMembersController', function($timeout, $scope, $http){
            $scope.loaded = false;
            $timeout(function(){
                $scope.sortCorporateMembersByAlphabbet();
            }, 500);

            $scope.params = {};
            $scope.params.currentAlphabet = "All";
            
            $scope.sortCorporateMembersByAlphabbet = function(){
                $scope.loaded = true;
                angular.element(document.querySelector('#corporateMembersContainer')).hide();
                $scope.records = [];
                $http({
                    method  : 'POST',
                    url     : '/membership/corporate-members',
                    data    : $scope.params,
                }).success(function(data){
                    console.log(data);
                    $scope.records = data;
                    $scope.datalength = $scope.records.length;

                    if($scope.datalength > 0){
                        $scope.loaded = false;
                        angular.element(document.querySelector('#corporateMembersContainer')).show();
                    }else{
                        $scope.loaded = false;
                        angular.element(document.querySelector('#corporateMembersContainer')).hide();
                        swal("Empty!!!", "No Records Found", "info");
                        return false;
                    }
                }).error(function(e){
                    console.log(e.responseText);
                    swal("Error!!!", "Error processing your request", "error");
                    $scope.loaded = false;
                });
            }
        });/* end angular controller */
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/corporate-members.blade.php ENDPATH**/ ?>