<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>

<?php $__env->startSection('styles'); ?>
<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css'); ?>

<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css'); ?>

<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">All News</li>
				</ol>
			</div>
			<div class="section-header">
				<div class="row">
					<div class="col-lg-6">
						<h2 class="text-primary">All News</h2>
					</div>
					<div class="col-lg-6">
						<?php echo HTML::link("admin/news/add/get","Add New News",["class"=>"btn ink-reaction pull-right btn-primary"]); ?>

					</div>
				</div>
			</div>

			<div class="section-body">
				<div class="row">
					<div class="col-lg-12">
						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Title</th>
										<th>Author</th>
										<th>Created On</th>
										<th>Last Modified</th>
										<th class="sort-numeric">Status</th>
										<th class="sort-alpha">Actions</th>
									</tr>
								</thead>
								<tbody>
									<?php $i = 1; ?>
									<?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<?php
											$news->status == "active" ? $class = "success" : $class = "danger";
											$lastModified = $news->newsUpdatorName != "" ? ucfirst($news->newsUpdatorName)." (".date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($news->created_at)).")" : "";
										?>
										<tr class="gradeX">
											<td><?php echo $i; ?></td>
											<td><?php echo $news->newsTitle; ?></td>
											<td><?php echo ucfirst($news->newsAuthorName); ?></td>
											<td><?php echo ucfirst($news->newsCreatorName); ?> (<?php echo date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($news->created_at)); ?>)</td>
											<td><?php echo $lastModified; ?></td>
											
											<td><button type="button" class="btn ink-reaction btn-xs btn-<?php echo $class; ?> newsStatus" data-id="<?php echo $news->id; ?>"><?php echo ucfirst($news->status); ?></button></td>
											<td>
												<a href="<?php echo URL::to('admin/news/modify/get/'.$news->id); ?>">
												<button type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
												</a>
												<button type="button" class="btn btn-icon-toggle newsDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="<?php echo $news->id; ?>"><i class="fa fa-trash-o"></i></button>
											</td>
										</tr>
									<?php $i++; ?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						</div><!--end .table-responsive -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	<?php echo HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js'); ?>

	<?php echo HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js'); ?>

	<?php echo HTML::script('backend/js/bala.js'); ?>

	<script type="text/javascript">
	$(document).ready(function(){
    	$('#myTable').DataTable();
	});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/news/news.blade.php ENDPATH**/ ?>