<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>


<?php $__env->startSection('styles'); ?>
	<?php echo HTML::style('backend/assets/css/jquery-ui.css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content" ng-app="courseAppliedFilter" ng-controller="courseAppliedController">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li>Courses Applied</li>
				</ol>
			</div>

			<div id="exclUploadDiv">
		      	<div class="card">
		        	<div class="card-body">
		          		<div class="row">
		            		<?php echo Form::open(["id"=>"courseAppliedSearchForm"]); ?>

		            			<div class="col-lg-3">
		              				<?php echo Form::text("dateFrom","",["class"=>"form-control","id"=>"dateFrom","placeholder"=>"From Date","ng-model"=>"params.dateFrom"]); ?>

					              	<?php if($errors->has("dateFrom")): ?>
										<span id="dateFrom-error" class="help-block"><?php echo $errors->first("dateFrom"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="col-lg-3">
		              				<?php echo Form::text("dateTo","",["class"=>"form-control","id"=>"dateTo","placeholder"=>"To Date","ng-model"=>"params.dateTo"]); ?>

					              	<?php if($errors->has("dateTo")): ?>
										<span id="dateTo-error" class="help-block"><?php echo $errors->first("dateTo"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="col-lg-3">
		              				<?php echo Form::select("paymentType",["offline"=>"Off-Line","online"=>"On-Line"],"",["class"=>"form-control","id"=>"paymentType","placeholder"=>"Payment Type","ng-model"=>"params.paymentType"]); ?>

					              	<?php if($errors->has("paymentType")): ?>
										<span id="process-error" class="help-block"><?php echo $errors->first("paymentType"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="clearfix"></div>	
		            			<br>
					            <div class="col-lg-2">
					                <input type="submit" class="btn ink-reaction pull-left btn-primary" ng-click="searchAppliedCourses($event)">
					            </div>
		            		<?php echo Form::close(); ?>

		          		</div>
		        	</div>
		      	</div>
		  	</div>

  			<div class="clearfix"></div>

  			<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

  			<div class="preLoadingDiv" style='display:none'>
		        <div class="spinner">
				  <div class="bounce1"></div>
				  <div class="bounce2"></div>
				  <div class="bounce3"></div>
				</div>
		        <p class="text-center">Processing.... Please wait...</p>
		    </div>

			<section id="courseAppliedTable" style="display:none">
				<div class="section-header">
					<div class="row">
						<div class="col-lg-6">
							<h2 class="text-primary">Courses Applied</h2>
						</div>
					</div>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="col-lg-12">
							<div class="table-responsive">
								<div style="float: left;"><b>Shows</b> &nbsp;&nbsp;
									<select ng-model="recordLimit"  ng-init="recordLimit=10" ng-options="item for item in recordArray">
									</select>
								</div>

								<div style="float: right;"><b>Search</b> &nbsp;&nbsp;<input type="text" ng-model="filterSearch"></div>

								<table class="table table-striped table-hover">
									<thead>
										<tr>
											<th ng-click="sort('sno')">#</th>
											<th ng-click="sort('unique_id')">Registration ID</th>
											<th ng-click="sort('name')">Name</th>
											<th ng-click="sort('emailid')">Email ID</th>
											<th ng-click="sort('mobile')">Mobile</th>
											<th ng-click="sort('registration_date')">Registered On</th>
											<th ng-click="sort('paymentType')">Payment Type</th>
											<th ng-click="sort('paymentStatus')">Payment Status</th>
											<th ng-click="sort('')">Actions</th>
										</tr>
									</thead>

									<tbody role="alert" aria-live="polite" aria-relevant="all">
										<tr dir-paginate="rec in records |orderBy:sortKey:reverse | filter: filterSearch|itemsPerPage:recordLimit">
											<td>{{ rec.sno }}</td>
											<td>{{ rec.unique_id }}</td>
											<td>{{ rec.name|uppercase }}</td>
											<td>{{ rec.emailid }}</td>
											<td>{{ rec.mobile }}</td>
											<td>{{ rec.registration_date }}</td>
											<td>{{ rec.paymentType|capitalize }}</td>
											<td>
												<div ng-if="rec.paymentStatus != ''">
													<button type="button" class="btn ink-reaction btn-xs btn-success">{{ rec.paymentStatus }}</button>
												</div>
											</td>

											<td>
												<a href="<?php echo URL::to('admin/courses/applied/modify/get/'); ?>/{{ rec.id }}" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit Course Application"><i class="fa fa-pencil"></i>
												</a>
												<!-- <button type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Delete Course Application" ng-click="deleteCourseApplied(rec)"><i class="fa fa-trash-o"></i></button> -->
											</td>
										</tr>
									</tbody>
								</table>

								<dir-pagination-controls
							       max-size="10"
							       direction-links="true"
							       boundary-links="true" >
							    </dir-pagination-controls>
							</div><!--end .table-responsive -->
						</div><!--end .col -->
					</div><!--end .row -->
					<!-- END DATATABLE 1 -->
				</div><!--end .section-body -->
			</section>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	<?php echo HTML::script('backend/js/angular.min.js'); ?>

  	<?php echo HTML::script('backend/js/dirPagination.js'); ?>

  	<?php echo HTML::script('backend/assets/js/jquery-ui.js'); ?>

	<script>
		$(document).ready(function(){
	    	$("#dateFrom").datepicker({
		      	changeMonth: false,
		      	dateFormat:'dd-M-yy',
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$("#dateTo").datepicker( "option", "minDate", selectedDate );
		      	}
		    });

		    $( "#dateTo" ).datepicker({
		      	dateFormat:'dd-M-yy',
		      	changeMonth: false,
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$( "#dateFrom" ).datepicker( "option", "maxDate", selectedDate );
		      	}
		    });
		});

		var app = angular.module('courseAppliedFilter',['angularUtils.directives.dirPagination']);
		app.controller('courseAppliedController', function($timeout, $scope, $http){
			
			// $timeout(function(){
			// 	$scope.searchAppliedCourses();
			// },500);

			$scope.params = {};
	        $scope.params.dateFrom = '';
	        $scope.params.dateTo = '';
	        $scope.params.paymentType = '';
	      
			$scope.searchAppliedCourses = function(event) {
				event.preventDefault();
				$('.preLoadingDiv').show();
				$('#courseAppliedTable').hide();
				$('#displayError').hide();
				$scope.records = [];
				$scope.recordArray = [10, 25, 50, 100];
				$http({
		          	method  : 'POST',
		          	url     : '/admin/courses/applied/post',
		          	data    : $scope.params,
		        }).success(function(data){
		         	console.log(data.result);
		         	if(data.status == 'success'){
		         		$scope.records = data.result;
		         		$('.preLoadingDiv').hide();
						$('#courseAppliedTable').show();
		         	}else{
		         		swal("Empty!!!", "No Records Found", "info");
		         		$('.preLoadingDiv').hide();
		         		return false;
		         	}
				});
		        
			}

			$scope.sort = function(keyname){
		        $scope.sortKey = keyname;   //set the sortKey to the param passed
		        $scope.reverse = !$scope.reverse; //if true make it false and vice versa
		    }
		});

		app.filter('capitalize', function() {
		    return function(input) {
		      return (!!input) ? input.charAt(0).toUpperCase() + input.substr(1).toLowerCase() : '';
		    }
		});

		app.filter('secondsToDateTime', function() {
		    return function(seconds) {
		        var d = new Date(0,0,0,0,0,0,0);
		        d.setSeconds(seconds);
		        return d;
		    };
		});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/courses/coursesApplied.blade.php ENDPATH**/ ?>