<?php
    use App\Models\NewsCategories;
    use App\Models\News;
    use App\Models\Upload;
?>


<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        .grid-item-inner {
            min-height: 45px;
        }
        .event-grid-time {
            background-color: rgba(5, 60, 90,0.8);
            padding: 5px 10px;
            top: -35px;
        }
        .grid-item h4 {
            text-overflow: ellipsis;
            white-space: nowrap;
            overflow: hidden;
        }
        .grid-item-inner p {
            font-size: 14px;
            margin-bottom: 0
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>News</h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo URL::to(''); ?>">Home</a></li>
                    <li>News</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-3 sidebar left-sidebar positioned hidden-xs">
                        <div class="widget sidebar-widget custom_menu">
                            <ul class="pages-sub-menu">
                                <li class='active'><a href="<?php echo URL::to('news/'); ?>">All News</a></li>
                                <li><a href="<?php echo URL::to('news/upcoming'); ?>">Upcoming</a></li>
                                <?php
                                    $categories = NewsCategories::where("status", "active")->get();
                                ?>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $link = $category->categorySlug?>
                                    <li><a href="<?php echo URL::to('news/'.$link); ?>"><?php echo ucwords($category->categoryName); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>

                    <div class="col-md-9 col-xs-12">
                        <?php
                            $news = News::where("status", "active")->orderBy("newsDate", "DESC")->get();
                        ?>

                        <h5 class="subhead"><?php echo count($news); ?> News</h5>
                        <h3 class="accent-color">All News</h3>
                        <ul class="events-list events-list-compact">
                            <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $newss): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $link = $newss->news_link;
                                    ?>
                                <li>
                                    <div class="event-date">
                                        <div class="event-month"><?php echo date("M'y", strtotime($newss->newsDate)); ?></div>
                                        <div class="event-day"><?php echo date("d", strtotime($newss->newsDate)); ?></div>
                                    </div>
                                    <a href="<?php echo URL::to($link); ?>" target="_blank" class="btn btn-default btn-sm">News Details</a>
                                    <a href="<?php echo URL::to($link); ?>" target="_blank"><strong><?php echo ucwords($newss->newsTitle); ?></strong></a>
                                    <span class="meta-data"><?php echo date("l", strtotime($newss->newsDate)); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/news.blade.php ENDPATH**/ ?>