<?php 
	use App\Models\Returnstatuses; 
	use App\Models\Option; 
	use App\Models\Upload; 
	use App\Models\CustomPages; 
?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i> Home</li>
					<li class="active">Store Frontend</li>
					<li class="active">Footer</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Theme Options</h1>
					</div><!--end .col -->

					<div class="col-md-3">
						<?php echo $__env->make("backend/storefront/storeFrontSidebar", ["page"=>"band"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div><!--end .col -->

					<div class="col-md-9">

						<div class="clearfix"></div>

						<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

						<?php echo Form::open(["url"=>"admin/storefront/footer/section/one/post", "class"=>"form", "id"=>"footerSectionOne", "files"=>true]); ?>

							<div class="card">
								<div class="card-head style-primary">
									<header>Footer Section (BAND)</header>
								</div>

								<div class="card-body">
									<div class="form-group">
										<?php echo Form::text("footerSectionOneBottomEmail", CustomPages::getcontent("footerSectionOneBottomEmail"), ["class"=>"form-control", "placeholder"=>"enter footer band email", "rows"=>2, "cols"=>2]); ?>

										<?php echo HTML::decode(Form::label("footerSectionOneBottomEmail","Email <span class='text-danger'>*</span>")); ?>

									</div><!--end form-group-->

									<div class="form-group">
										<?php echo Form::text("footerSectionOneBottomContactNo", CustomPages::getcontent("footerSectionOneBottomContactNo"), ["class"=>"form-control", "placeholder"=>"enter footer band contact no", "rows"=>2, "cols"=>2]); ?>

										<?php echo HTML::decode(Form::label("footerSectionOneBottomContactNo","Contact No <span class='text-danger'>*</span>")); ?>

									</div><!--end form-group-->
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Save Changes</button>
									</div>
								</div>
							</div><!--end .card -->
						<?php echo Form::close(); ?>

					</div><!-- end of col-md-8 -->

				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
<?php echo HTML::script('backend/assets/js/libs/global/iframe-transport.js'); ?>

<?php echo HTML::script('backend/assets/js/libs/global/jquery-ui.js'); ?>

<?php echo HTML::script('backend/assets/js/libs/global/fileupload.js'); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/storefront/footerSectionOne.blade.php ENDPATH**/ ?>