<?php
    use App\Models\CustomPages;
?>

<?php $__env->startSection('styles'); ?>
    <?php echo RecaptchaV3::initJs(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1><?php echo CustomPages::getcontent("contactUsPageTitle"); ?></h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo URL::to(''); ?>">Home</a></li>
                    <li><?php echo CustomPages::getcontent("contactUsPageTitle"); ?></li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-md-7">
                        <h4 class="widgettitle">Request Information</h4>
                        <?php if(Session::has('success')): ?>
                            <div class="alert alert-success"><?php echo e(Session::get('success')); ?></div>
                        <?php endif; ?>
                        <?php if($errors->has('g-recaptcha-response')): ?>
                            <div class="alert alert-danger">Recaptcha failed. Please refresh and try again.</div>
                        <?php endif; ?>
                        <form method="post" action="<?php echo e(url('/contact/post')); ?>" class="clearfix">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-6 col-sm-6">
                                    <label>Full Name <span class="req">*</span></label>
                                    <input type="text" id="name" name="name" class="form-control input-lg">
                                    <?php if($errors->has("name")): ?>
                                        <span class="required"><?php echo $errors->first("name"); ?></span>
                                   <?php endif; ?>
                                </div>
                                <div class="col-md-6 col-sm-6">
                                    <label>Company Name</label>
                                    <input type="text" id="company_name" name="company_name" class="form-control input-lg">
                                    <?php if($errors->has("company_name")): ?>
                                        <span class="required"><?php echo $errors->first("company_name"); ?></span>
                                   <?php endif; ?>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-sm-6">
                                    <label>Email ID <span class="req">*</span></label>
                                    <input type="text" id="email" name="email" class="form-control input-lg">
                                    <?php if($errors->has("email")): ?>
                                        <span class="required"><?php echo $errors->first("email"); ?></span>
                                   <?php endif; ?>
                                </div>
                                <div class="col-md-6 col-sm-6">
                                    <label>Contact Number <span class="req">*</span></label>
                                    <input type="text" id="contact_number" name="contact_number" class="form-control input-lg">
                                    <?php if($errors->has("contact_number")): ?>
                                        <span class="required"><?php echo $errors->first("contact_number"); ?></span>
                                   <?php endif; ?>
                                </div>
                            </div>

                            <label>Message <span class="req">*</span></label>
                            <textarea class="form-control input-lg" id="comments" name="comments" rows="6"></textarea>
                            <?php if($errors->has("comments")): ?>
                                <span class="required"><?php echo $errors->first("comments"); ?></span>
                           <?php endif; ?>

                            <div class="form-group<?php echo e($errors->has('g-recaptcha-response') ? ' has-error' : ''); ?>">
                                <div class="col-md-6">
                                    <?php echo RecaptchaV3::field('register'); ?>

                                </div>
                            </div>

                            <div class="spacer-10"></div>

                            <div class="clearfix">
                                <button type="submit" name="submit" class="btn btn-primary btn-lg">Submit</button>
                            </div>

                        </form>
                    </div>
                    <div class="col-md-4 col-md-offset-1">
                        <h4 class="widgettitle">Get in touch with us</h4>
                        <h4 class="accent-color"><b>ADVERTISING CLUB MADRAS</b></h4>
                        <p>
                            <?php echo CustomPages::getcontent("contactUsAddress"); ?><br><br>
                            <b>Phone:</b> <?php echo CustomPages::getcontent("contactUsPhone"); ?><br>
                            <!--<b>Fax:</b> <?php echo CustomPages::getcontent("contactUsFax"); ?><br>-->
                            <b>Email:</b> 
                            <?php
                                $emails = CustomPages::getcontent("contactUsEmail");
                                $emailArray = explode(",", $emails);
                                $i = 0;
                            ?>

                            <?php $__currentLoopData = $emailArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $array): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($i > 0): ?> , <?php endif; ?>
                                <a href="mailto:<?php echo $array; ?>"><?php echo $array; ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </p>

                        <p>
                            <b>PAN No.:</b> AAAAA5944J<br>
                            <b>GST No.:</b> 33AAAAA5944J1ZV
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <?php echo CustomPages::getcontent("contactUsMap"); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <!-- <script src="https://www.google.com/recaptcha/api.js?render=reCAPTCHA_site_key"></script> -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/contact.blade.php ENDPATH**/ ?>